/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.diag;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Range;

public class LineMap {
    private final String source;
    private final ImmutableRangeMap<Integer, Integer> lines;

    private LineMap(String source, ImmutableRangeMap<Integer, Integer> lines) {
        this.source = source;
        this.lines = lines;
    }

    public static LineMap create(String source) {
        int last = 0;
        int line = 1;
        ImmutableRangeMap.Builder builder = ImmutableRangeMap.builder();
        block4: for (int idx = 0; idx < source.length(); ++idx) {
            char ch = source.charAt(idx);
            switch (ch) {
                case '\r': {
                    if (idx + 1 < source.length() && source.charAt(idx + 1) == '\n') {
                        ++idx;
                    }
                }
                case '\n': {
                    builder.put(Range.closedOpen((Comparable)Integer.valueOf(last), (Comparable)Integer.valueOf(idx + 1)), (Object)line++);
                    last = idx + 1;
                    continue block4;
                }
            }
        }
        if (last < source.length()) {
            builder.put(Range.closedOpen((Comparable)Integer.valueOf(last), (Comparable)Integer.valueOf(source.length())), (Object)line++);
        }
        return new LineMap(source, (ImmutableRangeMap<Integer, Integer>)builder.build());
    }

    public int column(int position) {
        Preconditions.checkArgument((0 <= position && position < this.source.length() ? 1 : 0) != 0, (String)"%s", (int)position);
        return position - (Integer)((Range)this.lines.getEntry((Comparable)Integer.valueOf(position)).getKey()).lowerEndpoint();
    }

    public int lineNumber(int position) {
        Preconditions.checkArgument((0 <= position && position < this.source.length() ? 1 : 0) != 0, (String)"%s", (int)position);
        return (Integer)this.lines.get((Comparable)Integer.valueOf(position));
    }

    public String line(int position) {
        Preconditions.checkArgument((0 <= position && position < this.source.length() ? 1 : 0) != 0, (String)"%s", (int)position);
        Range range = (Range)this.lines.getEntry((Comparable)Integer.valueOf(position)).getKey();
        return this.source.substring((Integer)range.lowerEndpoint(), (Integer)range.upperEndpoint());
    }
}

