/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.BuiltInVariableExpr;
import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.writer.KCode;
import android.databinding.tool.writer.LayoutBinderWriterKt;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class IdentifierExpr
extends Expr {
    String mName;
    String mUserDefinedType;
    private boolean mIsDeclared;

    IdentifierExpr(String name) {
        super(new Expr[0]);
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setUserDefinedType(String userDefinedType) {
        this.mUserDefinedType = userDefinedType;
    }

    @Override
    protected String computeUniqueKey() {
        return this.mName;
    }

    public String getUserDefinedType() {
        return this.mUserDefinedType;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        Preconditions.checkNotNull((Object)this.mUserDefinedType, (String)"Could not find identifier '%s'\n\nCheck that the identifier is spelled correctly, and that no <import> or <variable> tags are missing.", (Object[])new Object[]{this.mName});
        return modelAnalyzer.findClass(this.mUserDefinedType, this.getModel().getImports());
    }

    @Override
    public void injectSafeUnboxing(ModelAnalyzer modelAnalyzer, ExprModel model) {
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return new ArrayList<Dependency>();
    }

    @Override
    protected String asPackage() {
        return this.mUserDefinedType == null ? this.mName : null;
    }

    @Override
    protected KCode generateCode() {
        return new KCode(LayoutBinderWriterKt.scopedName(this));
    }

    public void setDeclared() {
        this.mIsDeclared = true;
    }

    public boolean isDeclared() {
        return this.mIsDeclared;
    }

    @Override
    public String getInvertibleError() {
        return null;
    }

    @Override
    public Expr generateInverse(ExprModel model, Expr value, String bindingClassName) {
        String thisType = bindingClassName + ".this";
        BuiltInVariableExpr target = model.builtInVariable(thisType, bindingClassName, thisType);
        return model.methodCall(target, LayoutBinderWriterKt.getSetterName(this), Lists.newArrayList((Object[])new Expr[]{value}));
    }

    @Override
    public Expr cloneToModel(ExprModel model) {
        return model.identifier(this.mName);
    }

    @Override
    public String toString() {
        return this.mName;
    }
}

