/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

@Beta
@GwtCompatible
public class FakeTicker
extends Ticker {
    private final AtomicLong nanos = new AtomicLong();
    private volatile long autoIncrementStepNanos;

    public FakeTicker advance(long time, TimeUnit timeUnit) {
        return this.advance(timeUnit.toNanos(time));
    }

    public FakeTicker advance(long nanoseconds) {
        this.nanos.addAndGet(nanoseconds);
        return this;
    }

    @GwtIncompatible
    public FakeTicker advance(Duration duration) {
        return this.advance(duration.toNanos());
    }

    public FakeTicker setAutoIncrementStep(long autoIncrementStep, TimeUnit timeUnit) {
        Preconditions.checkArgument((autoIncrementStep >= 0L ? 1 : 0) != 0, (Object)"May not auto-increment by a negative amount");
        this.autoIncrementStepNanos = timeUnit.toNanos(autoIncrementStep);
        return this;
    }

    @GwtIncompatible
    public FakeTicker setAutoIncrementStep(Duration autoIncrementStep) {
        return this.setAutoIncrementStep(autoIncrementStep.toNanos(), TimeUnit.NANOSECONDS);
    }

    public long read() {
        return this.nanos.getAndAdd(this.autoIncrementStepNanos);
    }
}

