/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;

class LongArrayCodec
implements ObjectCodec<long[]> {
    LongArrayCodec() {
    }

    @Override
    public Class<? extends long[]> getEncodedClass() {
        return long[].class;
    }

    @Override
    public void serialize(SerializationContext context, long[] obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        codedOut.writeInt32NoTag(obj.length);
        for (long l : obj) {
            codedOut.writeInt64NoTag(l);
        }
    }

    @Override
    public long[] deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        long[] result = new long[codedIn.readInt32()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = codedIn.readInt64();
        }
        return result;
    }
}

