/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization.autocodec;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.RegisteredSingletonDoNotUse;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationConstant;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationProcessorUtil;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.Collection;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class SerializationConstantProcessor
extends AbstractProcessor {
    private ProcessingEnvironment env;
    private static final ImmutableList<Modifier> REQUIRED_SINGLETON_MODIFIERS = ImmutableList.of((Object)((Object)Modifier.STATIC), (Object)((Object)Modifier.FINAL));

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.env = processingEnv;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            this.processInternal(roundEnv);
        }
        catch (SerializationProcessorUtil.SerializationProcessingFailedException e) {
            this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage(), e.getElement());
        }
        return false;
    }

    private void processInternal(RoundEnvironment roundEnv) throws SerializationProcessorUtil.SerializationProcessingFailedException {
        for (Element element : roundEnv.getElementsAnnotatedWith(SerializationConstant.class)) {
            SerializationProcessorUtil.writeGeneratedClassToFile((Element)element, (TypeSpec)SerializationConstantProcessor.buildRegisteredSingletonClass((VariableElement)element, this.env), (ProcessingEnvironment)this.env);
        }
    }

    static TypeSpec buildRegisteredSingletonClass(VariableElement symbol, ProcessingEnvironment env) throws SerializationProcessorUtil.SerializationProcessingFailedException {
        if (!symbol.getModifiers().containsAll((Collection<?>)REQUIRED_SINGLETON_MODIFIERS)) {
            throw new SerializationProcessorUtil.SerializationProcessingFailedException((Element)symbol, "Field must be static and final to be annotated with @SerializationConstant or @AutoCodec", new Object[0]);
        }
        return TypeSpec.classBuilder((String)SerializationProcessorUtil.getGeneratedName((Element)symbol, (String)"RegisteredSingleton")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(RegisteredSingletonDoNotUse.class).addField(FieldSpec.builder(Object.class, (String)"REGISTERED_SINGLETON_INSTANCE_VAR_NAME_GLFKMEBDQFHOJQKEHHQPGMNQBOBFEJADCMDP", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.$L", new Object[]{SerializationProcessorUtil.sanitizeTypeParameter((TypeMirror)symbol.getEnclosingElement().asType(), (ProcessingEnvironment)env), symbol.getSimpleName()}).build()).build();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)SerializationConstant.class.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

