/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Preconditions;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.ElementKind;

@BugPattern(name="UnnecessaryBoxedVariable", summary="It is unnecessary for this variable to be boxed. Use the primitive instead.", explanation="This variable is of boxed type, but equivalent semantics can be achieved using the corresponding primitive type, which avoids the cost of constructing an unnecessary object.", severity=BugPattern.SeverityLevel.SUGGESTION)
public class UnnecessaryBoxedVariable
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final Matcher<ExpressionTree> VALUE_OF_MATCHER = MethodMatchers.staticMethod().onClass(UnnecessaryBoxedVariable::isBoxableType).named("valueOf");

    public Description matchVariable(VariableTree tree, VisitorState state) {
        Optional<Type> unboxed = UnnecessaryBoxedVariable.unboxed(tree, state);
        if (!unboxed.isPresent()) {
            return Description.NO_MATCH;
        }
        Symbol.VarSymbol varSymbol = ASTHelpers.getSymbol((VariableTree)tree);
        if (varSymbol == null) {
            return Description.NO_MATCH;
        }
        switch (varSymbol.getKind()) {
            case PARAMETER: {
                if (!UnnecessaryBoxedVariable.canChangeMethodSignature(state, (Symbol.MethodSymbol)varSymbol.getEnclosingElement())) {
                    return Description.NO_MATCH;
                }
            }
            case LOCAL_VARIABLE: {
                if (UnnecessaryBoxedVariable.variableMatches(tree, state)) break;
                return Description.NO_MATCH;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        Optional<TreePath> enclosingMethod = UnnecessaryBoxedVariable.getEnclosingMethod(state.getPath());
        if (!enclosingMethod.isPresent()) {
            return Description.NO_MATCH;
        }
        TreePath path = enclosingMethod.get();
        FindBoxedUsagesScanner scanner = new FindBoxedUsagesScanner(varSymbol, path, state);
        scanner.scan(path, null);
        if (scanner.boxedUsageFound) {
            return Description.NO_MATCH;
        }
        if (!scanner.used && varSymbol.getKind() == ElementKind.PARAMETER) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        fixBuilder.replace(tree.getType(), ((Name)unboxed.get().tsym.getSimpleName()).toString());
        UnnecessaryBoxedVariable.fixMethodInvocations(scanner.fixableSimpleMethodInvocations, fixBuilder, state);
        UnnecessaryBoxedVariable.fixNullCheckInvocations(scanner.fixableNullCheckInvocations, fixBuilder, state);
        UnnecessaryBoxedVariable.fixCastingInvocations(scanner.fixableCastMethodInvocations, enclosingMethod.get(), fixBuilder, state);
        AnnotationTree nullableAnnotation = ASTHelpers.getAnnotationWithSimpleName(tree.getModifiers().getAnnotations(), (String)"Nullable");
        if (nullableAnnotation != null) {
            fixBuilder.replace((Tree)nullableAnnotation, "");
            return this.buildDescription(tree).setMessage("All usages of this @Nullable variable would result in a NullPointerException when it actually is null. Use the primitive type if this variable should never be null, or else fix the code to avoid unboxing or invoking its instance methods.").addFix((Fix)fixBuilder.build()).build();
        }
        return this.describeMatch(tree, (Fix)fixBuilder.build());
    }

    private static Optional<Type> unboxed(Tree tree, VisitorState state) {
        Type type = ASTHelpers.getType((Tree)tree);
        if (type == null || !type.isReference()) {
            return Optional.empty();
        }
        Type unboxed = state.getTypes().unboxedType(type);
        if (unboxed == null || unboxed.getTag() == TypeTag.NONE || unboxed.getTag() == TypeTag.VOID) {
            return Optional.empty();
        }
        return Optional.of(unboxed);
    }

    private static void fixNullCheckInvocations(List<TreePath> nullCheckInvocations, SuggestedFix.Builder fixBuilder, VisitorState state) {
        for (TreePath pathForTree : nullCheckInvocations) {
            Preconditions.checkArgument((boolean)(pathForTree.getLeaf() instanceof MethodInvocationTree));
            MethodInvocationTree methodInvocation = (MethodInvocationTree)pathForTree.getLeaf();
            ASTHelpers.TargetType targetType = ASTHelpers.targetType((VisitorState)state.withPath(pathForTree));
            if (targetType == null) {
                StatementTree statementTree = (StatementTree)ASTHelpers.findEnclosingNode((TreePath)pathForTree, StatementTree.class);
                if (statementTree == null) continue;
                fixBuilder.delete((Tree)statementTree);
                continue;
            }
            fixBuilder.replace((Tree)methodInvocation, state.getSourceForNode((Tree)methodInvocation.getArguments().get(0)));
        }
    }

    private static void fixMethodInvocations(List<MethodInvocationTree> simpleMethodInvocations, SuggestedFix.Builder fixBuilder, VisitorState state) {
        for (MethodInvocationTree methodInvocation : simpleMethodInvocations) {
            ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)methodInvocation);
            Type receiverType = ASTHelpers.getType((Tree)receiver);
            MemberSelectTree methodSelect = (MemberSelectTree)methodInvocation.getMethodSelect();
            fixBuilder.replace((Tree)methodInvocation, String.format("%s.%s(%s)", receiverType.tsym.getSimpleName(), methodSelect.getIdentifier(), state.getSourceForNode((Tree)receiver)));
        }
    }

    private static void fixCastingInvocations(List<MethodInvocationTree> castMethodInvocations, TreePath enclosingMethod, SuggestedFix.Builder fixBuilder, VisitorState state) {
        for (MethodInvocationTree castInvocation : castMethodInvocations) {
            ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)castInvocation);
            Type expressionType = ASTHelpers.getType((Tree)castInvocation);
            TreePath castPath = TreePath.getPath(enclosingMethod, (Tree)castInvocation);
            if (castPath.getParentPath() != null && castPath.getParentPath().getLeaf().getKind() == Tree.Kind.EXPRESSION_STATEMENT) {
                fixBuilder.delete(castPath.getParentPath().getLeaf());
                continue;
            }
            Type unboxedReceiverType = state.getTypes().unboxedType(ASTHelpers.getType((Tree)receiver));
            if (unboxedReceiverType.getTag() == expressionType.getTag()) {
                fixBuilder.replace((Tree)castInvocation, state.getSourceForNode((Tree)receiver));
                continue;
            }
            fixBuilder.replace((Tree)castInvocation, String.format("(%s) %s", expressionType.tsym.getSimpleName(), state.getSourceForNode((Tree)receiver)));
        }
    }

    private static boolean variableMatches(VariableTree tree, VisitorState state) {
        ExpressionTree expression = tree.getInitializer();
        if (expression == null) {
            Tree leaf = state.getPath().getParentPath().getLeaf();
            if (!(leaf instanceof EnhancedForLoopTree)) {
                return true;
            }
            EnhancedForLoopTree node = (EnhancedForLoopTree)leaf;
            Type expressionType = ASTHelpers.getType((Tree)node.getExpression());
            if (expressionType == null) {
                return false;
            }
            Type elemtype = state.getTypes().elemtype(expressionType);
            return elemtype != null && elemtype.isPrimitive();
        }
        Type initializerType = ASTHelpers.getType((Tree)expression);
        if (initializerType == null) {
            return false;
        }
        if (initializerType.isPrimitive()) {
            return true;
        }
        return VALUE_OF_MATCHER.matches((Tree)expression, state);
    }

    private static Optional<TreePath> getEnclosingMethod(TreePath path) {
        while (path != null && path.getLeaf().getKind() != Tree.Kind.CLASS && path.getLeaf().getKind() != Tree.Kind.LAMBDA_EXPRESSION) {
            if (path.getLeaf().getKind() == Tree.Kind.METHOD) {
                return Optional.of(path);
            }
            path = path.getParentPath();
        }
        return Optional.empty();
    }

    private static boolean isBoxableType(Type type, VisitorState state) {
        Type unboxedType = state.getTypes().unboxedType(type);
        return unboxedType != null && unboxedType.getTag() != TypeTag.NONE;
    }

    private static boolean canChangeMethodSignature(VisitorState state, Symbol.MethodSymbol methodSymbol) {
        return !ASTHelpers.methodCanBeOverridden((Symbol.MethodSymbol)methodSymbol) && ASTHelpers.findSuperMethods((Symbol.MethodSymbol)methodSymbol, (Types)state.getTypes()).isEmpty();
    }

    private static class FindBoxedUsagesScanner
    extends TreePathScanner<Void, Void> {
        private static final Matcher<ExpressionTree> SIMPLE_METHOD_MATCH = MethodMatchers.instanceMethod().anyClass().namedAnyOf(new String[]{"hashCode", "toString"});
        private static final Matcher<ExpressionTree> CAST_METHOD_MATCH = MethodMatchers.instanceMethod().onClass((TypePredicate & Serializable)(x$0, x$1) -> UnnecessaryBoxedVariable.access$600(x$0, x$1)).namedAnyOf(new String[]{"byteValue", "shortValue", "intValue", "longValue", "floatValue", "doubleValue", "booleanValue"});
        private static final Matcher<ExpressionTree> NULL_CHECK_MATCH = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("com.google.common.base.Preconditions").named("checkNotNull"), MethodMatchers.staticMethod().onClass("com.google.common.base.Verify").named("verifyNonNull"), MethodMatchers.staticMethod().onClass("java.util.Objects").named("requireNonNull")});
        private final Symbol.VarSymbol varSymbol;
        private final TreePath path;
        private final VisitorState state;
        private final List<MethodInvocationTree> fixableSimpleMethodInvocations = new ArrayList<MethodInvocationTree>();
        private final List<TreePath> fixableNullCheckInvocations = new ArrayList<TreePath>();
        private final List<MethodInvocationTree> fixableCastMethodInvocations = new ArrayList<MethodInvocationTree>();
        private boolean boxedUsageFound;
        private boolean used;

        FindBoxedUsagesScanner(Symbol.VarSymbol varSymbol, TreePath path, VisitorState state) {
            this.varSymbol = varSymbol;
            this.path = path;
            this.state = state;
        }

        @Override
        public Void scan(Tree tree, Void unused) {
            if (this.boxedUsageFound) {
                return null;
            }
            return (Void)super.scan(tree, unused);
        }

        @Override
        public Void visitAssignment(AssignmentTree node, Void unused) {
            Symbol nodeSymbol = ASTHelpers.getSymbol((Tree)node.getVariable());
            if (!Objects.equals(nodeSymbol, this.varSymbol)) {
                return (Void)super.visitAssignment(node, unused);
            }
            this.used = true;
            if (!this.checkAssignmentExpression(node.getExpression())) {
                return this.scan((Tree)node.getExpression(), unused);
            }
            this.boxedUsageFound = true;
            return null;
        }

        private boolean checkAssignmentExpression(ExpressionTree expression) {
            Type expressionType = ASTHelpers.getType((Tree)expression);
            if (expressionType.isPrimitive()) {
                return false;
            }
            return !VALUE_OF_MATCHER.matches((Tree)expression, this.state.withPath(TreePath.getPath(this.path, (Tree)expression))) && expression.getKind() != Tree.Kind.NEW_CLASS;
        }

        @Override
        public Void visitIdentifier(IdentifierTree node, Void unused) {
            Symbol nodeSymbol = ASTHelpers.getSymbol((Tree)node);
            if (Objects.equals(nodeSymbol, this.varSymbol)) {
                this.used = true;
                TreePath identifierPath = TreePath.getPath(this.path, (Tree)node);
                VisitorState identifierState = this.state.withPath(identifierPath);
                ASTHelpers.TargetType targetType = ASTHelpers.targetType((VisitorState)identifierState);
                if (targetType != null && !targetType.type().isPrimitive()) {
                    this.boxedUsageFound = true;
                    return null;
                }
            }
            return (Void)super.visitIdentifier(node, unused);
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, Void unused) {
            return this.scan((Tree)node.getExpression(), unused);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
            Symbol firstArgSymbol;
            if (NULL_CHECK_MATCH.matches((Tree)node, this.state) && Objects.equals(firstArgSymbol = ASTHelpers.getSymbol((Tree)ASTHelpers.stripParentheses((ExpressionTree)node.getArguments().get(0))), this.varSymbol)) {
                this.used = true;
                this.fixableNullCheckInvocations.add(this.getCurrentPath());
                return null;
            }
            ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)node);
            if (receiver != null && Objects.equals(ASTHelpers.getSymbol((Tree)receiver), this.varSymbol)) {
                this.used = true;
                if (SIMPLE_METHOD_MATCH.matches((Tree)node, this.state)) {
                    this.fixableSimpleMethodInvocations.add(node);
                    return null;
                }
                if (CAST_METHOD_MATCH.matches((Tree)node, this.state)) {
                    this.fixableCastMethodInvocations.add(node);
                    return null;
                }
                this.boxedUsageFound = true;
                return null;
            }
            return (Void)super.visitMethodInvocation(node, unused);
        }

        @Override
        public Void visitReturn(ReturnTree node, Void unused) {
            MethodTree enclosingMethod;
            Type returnType;
            Symbol nodeSymbol = ASTHelpers.getSymbol((Tree)ASTHelpers.stripParentheses((ExpressionTree)node.getExpression()));
            if (!Objects.equals(nodeSymbol, this.varSymbol)) {
                return (Void)super.visitReturn(node, unused);
            }
            this.used = true;
            if (this.varSymbol.getKind() == ElementKind.PARAMETER && !(returnType = ASTHelpers.getType((Tree)(enclosingMethod = (MethodTree)ASTHelpers.findEnclosingNode((TreePath)this.getCurrentPath(), MethodTree.class)).getReturnType())).isPrimitive()) {
                this.boxedUsageFound = true;
            }
            return null;
        }

        @Override
        public Void visitMemberReference(MemberReferenceTree node, Void unused) {
            Symbol symbol;
            ExpressionTree qualifierExpression = node.getQualifierExpression();
            if (qualifierExpression.getKind() == Tree.Kind.IDENTIFIER && Objects.equals(symbol = ASTHelpers.getSymbol((Tree)qualifierExpression), this.varSymbol)) {
                this.boxedUsageFound = true;
                this.used = true;
                return null;
            }
            return (Void)super.visitMemberReference(node, unused);
        }
    }
}

