/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.javadoc.Utils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.tools.javac.code.Type;

@BugPattern(name="ReturnFromVoid", summary="Void methods should not have a @return tag.", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"}, documentSuppression=false)
public final class ReturnFromVoid
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            new VoidReturnTypeChecker(state, methodTree).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    private final class VoidReturnTypeChecker
    extends DocTreePathScanner<Void, Void> {
        private final VisitorState state;
        private final MethodTree methodTree;

        private VoidReturnTypeChecker(VisitorState state, MethodTree methodTree) {
            this.state = state;
            this.methodTree = methodTree;
        }

        @Override
        public Void visitReturn(ReturnTree returnTree, Void unused) {
            if (ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)this.methodTree.getReturnType()), (Type)this.state.getSymtab().voidType, (VisitorState)this.state)) {
                this.state.reportMatch(ReturnFromVoid.this.describeMatch(Utils.diagnosticPosition(this.getCurrentPath(), this.state), (Fix)Utils.replace(returnTree, "", this.state)));
            }
            return (Void)super.visitReturn(returnTree, null);
        }
    }
}

