/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Streams;
import com.google.errorprone.VisitorState;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnalysis;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.AutoValue_ASTHelpers_TargetType;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.PackageTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotations;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;

public class ASTHelpers {
    private static final Cache<Name, Boolean> inheritedAnnotationCache = Caffeine.newBuilder().maximumSize(1000L).build();
    private static final Set<TypeTag> SUBTYPE_UNDEFINED = EnumSet.of(TypeTag.METHOD, TypeTag.PACKAGE, TypeTag.UNKNOWN, TypeTag.ERROR);
    private static final CharMatcher BACKSLASH_MATCHER = CharMatcher.is((char)'\\');

    public static boolean sameVariable(ExpressionTree expr1, ExpressionTree expr2) {
        Objects.requireNonNull(expr1);
        Objects.requireNonNull(expr2);
        if (expr1.getKind() != Tree.Kind.IDENTIFIER && expr1.getKind() != Tree.Kind.MEMBER_SELECT || expr2.getKind() != Tree.Kind.IDENTIFIER && expr2.getKind() != Tree.Kind.MEMBER_SELECT) {
            return false;
        }
        Symbol sym1 = ASTHelpers.getSymbol(expr1);
        Symbol sym2 = ASTHelpers.getSymbol(expr2);
        if (sym1 == null) {
            throw new IllegalStateException("Couldn't get symbol for " + expr1);
        }
        if (sym2 == null) {
            throw new IllegalStateException("Couldn't get symbol for " + expr2);
        }
        if (expr1.getKind() == Tree.Kind.IDENTIFIER && expr2.getKind() == Tree.Kind.IDENTIFIER) {
            return sym1.equals(sym2);
        }
        if (expr1.getKind() == Tree.Kind.MEMBER_SELECT && expr2.getKind() == Tree.Kind.MEMBER_SELECT) {
            return sym1.equals(sym2) && ASTHelpers.sameVariable(((JCTree.JCFieldAccess)expr1).selected, ((JCTree.JCFieldAccess)expr2).selected);
        }
        JCTree.JCExpression selected = null;
        selected = expr1.getKind() == Tree.Kind.IDENTIFIER ? ((JCTree.JCFieldAccess)expr2).selected : ((JCTree.JCFieldAccess)expr1).selected;
        return ((Object)selected).toString().equals("this") && sym1.equals(sym2);
    }

    @Nullable
    public static Symbol getDeclaredSymbol(Tree tree) {
        if (tree instanceof AnnotationTree) {
            return ASTHelpers.getSymbol(((AnnotationTree)tree).getAnnotationType());
        }
        if (tree instanceof PackageTree) {
            return ASTHelpers.getSymbol((PackageTree)tree);
        }
        if (tree instanceof TypeParameterTree) {
            Type type = ((JCTree.JCTypeParameter)tree).type;
            return type == null ? null : type.tsym;
        }
        if (tree instanceof ClassTree) {
            return ASTHelpers.getSymbol((ClassTree)tree);
        }
        if (tree instanceof MethodTree) {
            return ASTHelpers.getSymbol((MethodTree)tree);
        }
        if (tree instanceof VariableTree) {
            return ASTHelpers.getSymbol((VariableTree)tree);
        }
        return null;
    }

    public static Symbol getSymbol(Tree tree) {
        if (tree instanceof JCTree.JCFieldAccess) {
            return ((JCTree.JCFieldAccess)tree).sym;
        }
        if (tree instanceof JCTree.JCIdent) {
            return ((JCTree.JCIdent)tree).sym;
        }
        if (tree instanceof JCTree.JCMethodInvocation) {
            return ASTHelpers.getSymbol((MethodInvocationTree)tree);
        }
        if (tree instanceof JCTree.JCNewClass) {
            return ASTHelpers.getSymbol((NewClassTree)tree);
        }
        if (tree instanceof MemberReferenceTree) {
            return ((JCTree.JCMemberReference)tree).sym;
        }
        if (tree instanceof JCTree.JCAnnotatedType) {
            return ASTHelpers.getSymbol(((JCTree.JCAnnotatedType)tree).underlyingType);
        }
        if (tree instanceof ParameterizedTypeTree) {
            return ASTHelpers.getSymbol(((ParameterizedTypeTree)tree).getType());
        }
        if (tree instanceof ClassTree) {
            return ASTHelpers.getSymbol((ClassTree)tree);
        }
        return ASTHelpers.getDeclaredSymbol(tree);
    }

    public static Symbol.ClassSymbol getSymbol(ClassTree tree) {
        return ((JCTree.JCClassDecl)tree).sym;
    }

    public static Symbol.PackageSymbol getSymbol(PackageTree tree) {
        return ((JCTree.JCPackageDecl)tree).packge;
    }

    public static Symbol.MethodSymbol getSymbol(MethodTree tree) {
        return ((JCTree.JCMethodDecl)tree).sym;
    }

    @Nullable
    public static Symbol.MethodSymbol getSymbol(NewClassTree tree) {
        Symbol sym = ((JCTree.JCNewClass)tree).constructor;
        return sym instanceof Symbol.MethodSymbol ? (Symbol.MethodSymbol)sym : null;
    }

    public static Symbol.VarSymbol getSymbol(VariableTree tree) {
        return ((JCTree.JCVariableDecl)tree).sym;
    }

    @Nullable
    public static Symbol.MethodSymbol getSymbol(MethodInvocationTree tree) {
        Symbol sym = ASTHelpers.getSymbol(tree.getMethodSelect());
        if (!(sym instanceof Symbol.MethodSymbol)) {
            return null;
        }
        return (Symbol.MethodSymbol)sym;
    }

    @Nullable
    public static Symbol.MethodSymbol getSymbol(MemberReferenceTree tree) {
        Symbol sym = ((JCTree.JCMemberReference)tree).sym;
        return sym instanceof Symbol.MethodSymbol ? (Symbol.MethodSymbol)sym : null;
    }

    public static boolean requiresParentheses(ExpressionTree expression, VisitorState state) {
        switch (expression.getKind()) {
            case IDENTIFIER: 
            case MEMBER_SELECT: 
            case METHOD_INVOCATION: 
            case ARRAY_ACCESS: 
            case PARENTHESIZED: 
            case NEW_CLASS: 
            case MEMBER_REFERENCE: 
            case LAMBDA_EXPRESSION: {
                return false;
            }
        }
        if (expression instanceof LiteralTree) {
            if (!ASTHelpers.isSameType(ASTHelpers.getType(expression), state.getSymtab().stringType, state)) {
                return false;
            }
            return state.getOffsetTokensForNode(expression).stream().anyMatch(t -> t.kind() == Tokens.TokenKind.PLUS);
        }
        return !(expression instanceof UnaryTree);
    }

    public static Tree stripParentheses(Tree tree) {
        return tree instanceof ExpressionTree ? ASTHelpers.stripParentheses((ExpressionTree)tree) : tree;
    }

    public static ExpressionTree stripParentheses(ExpressionTree tree) {
        while (tree instanceof ParenthesizedTree) {
            tree = ((ParenthesizedTree)tree).getExpression();
        }
        return tree;
    }

    public static <T> TreePath findPathFromEnclosingNodeToTopLevel(TreePath path, Class<T> klass) {
        if (path != null) {
            while ((path = path.getParentPath()) != null && !klass.isInstance(path.getLeaf())) {
            }
        }
        return path;
    }

    @Nullable
    public static <T> T findEnclosingNode(TreePath path, Class<T> klass) {
        return (path = ASTHelpers.findPathFromEnclosingNodeToTopLevel(path, klass)) == null ? null : (T)klass.cast(path.getLeaf());
    }

    @Nullable
    public static ExpressionTree getRootAssignable(MethodInvocationTree methodInvocationTree) {
        if (!(methodInvocationTree instanceof JCTree.JCMethodInvocation)) {
            throw new IllegalArgumentException("Expected type to be JCMethodInvocation, but was " + methodInvocationTree.getClass());
        }
        if (((JCTree.JCMethodInvocation)methodInvocationTree).getMethodSelect() instanceof JCTree.JCIdent) {
            return null;
        }
        ExpressionTree expr = methodInvocationTree;
        while (expr instanceof JCTree.JCMethodInvocation) {
            if (!((expr = ((JCTree.JCMethodInvocation)expr).getMethodSelect()) instanceof JCTree.JCFieldAccess)) continue;
            expr = ((JCTree.JCFieldAccess)expr).getExpression();
        }
        Symbol sym = ASTHelpers.getSymbol(expr);
        if (sym instanceof Symbol.VarSymbol) {
            return expr;
        }
        return null;
    }

    public static Type getReturnType(ExpressionTree expressionTree) {
        if (expressionTree instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess methodCall = (JCTree.JCFieldAccess)expressionTree;
            return methodCall.type.getReturnType();
        }
        if (expressionTree instanceof JCTree.JCIdent) {
            JCTree.JCIdent methodCall = (JCTree.JCIdent)expressionTree;
            return methodCall.type.getReturnType();
        }
        if (expressionTree instanceof JCTree.JCMethodInvocation) {
            return ASTHelpers.getReturnType(((JCTree.JCMethodInvocation)expressionTree).getMethodSelect());
        }
        if (expressionTree instanceof JCTree.JCMemberReference) {
            return ((JCTree.JCMemberReference)expressionTree).sym.type.getReturnType();
        }
        throw new IllegalArgumentException("Expected a JCFieldAccess or JCIdent");
    }

    @Nullable
    public static Type getResultType(ExpressionTree expressionTree) {
        Type type = ASTHelpers.getType(expressionTree);
        return type == null ? null : Optional.ofNullable(type.getReturnType()).orElse(type);
    }

    public static Type getReceiverType(ExpressionTree expressionTree) {
        if (expressionTree instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess methodSelectFieldAccess = (JCTree.JCFieldAccess)expressionTree;
            return methodSelectFieldAccess.selected.type;
        }
        if (expressionTree instanceof JCTree.JCIdent) {
            JCTree.JCIdent methodCall = (JCTree.JCIdent)expressionTree;
            return methodCall.sym.owner.type;
        }
        if (expressionTree instanceof JCTree.JCMethodInvocation) {
            return ASTHelpers.getReceiverType(((JCTree.JCMethodInvocation)expressionTree).getMethodSelect());
        }
        if (expressionTree instanceof JCTree.JCMemberReference) {
            return ((JCTree.JCMemberReference)expressionTree).getQualifierExpression().type;
        }
        throw new IllegalArgumentException("Expected a JCFieldAccess or JCIdent from expression " + expressionTree);
    }

    @Nullable
    public static ExpressionTree getReceiver(ExpressionTree expressionTree) {
        if (expressionTree instanceof MethodInvocationTree) {
            ExpressionTree methodSelect = ((MethodInvocationTree)expressionTree).getMethodSelect();
            if (methodSelect instanceof IdentifierTree) {
                return null;
            }
            return ASTHelpers.getReceiver(methodSelect);
        }
        if (expressionTree instanceof MemberSelectTree) {
            return ((MemberSelectTree)expressionTree).getExpression();
        }
        if (expressionTree instanceof MemberReferenceTree) {
            return ((MemberReferenceTree)expressionTree).getQualifierExpression();
        }
        throw new IllegalStateException(String.format("Expected expression '%s' to be a method invocation or field access, but was %s", new Object[]{expressionTree, expressionTree.getKind()}));
    }

    @Nullable
    public static java.util.List<ExpressionTree> matchBinaryTree(BinaryTree tree, java.util.List<Matcher<ExpressionTree>> matchers, VisitorState state) {
        ExpressionTree leftOperand = tree.getLeftOperand();
        ExpressionTree rightOperand = tree.getRightOperand();
        if (matchers.get(0).matches(leftOperand, state) && matchers.get(1).matches(rightOperand, state)) {
            return Arrays.asList(leftOperand, rightOperand);
        }
        if (matchers.get(0).matches(rightOperand, state) && matchers.get(1).matches(leftOperand, state)) {
            return Arrays.asList(rightOperand, leftOperand);
        }
        return null;
    }

    @Nullable
    public static MethodTree findMethod(Symbol.MethodSymbol symbol, VisitorState state) {
        return JavacTrees.instance(state.context).getTree(symbol);
    }

    @Nullable
    public static ClassTree findClass(Symbol.ClassSymbol symbol, VisitorState state) {
        return JavacTrees.instance(state.context).getTree(symbol);
    }

    @Nullable
    public static Symbol.MethodSymbol findSuperMethodInType(Symbol.MethodSymbol methodSymbol, Type superType, Types types) {
        if (methodSymbol.isStatic() || superType.equals(methodSymbol.owner.type)) {
            return null;
        }
        Scope.WriteableScope scope = superType.tsym.members();
        for (Symbol sym : scope.getSymbolsByName(methodSymbol.name)) {
            if (sym == null || sym.isStatic() || (sym.flags() & 0x1000L) != 0L || !methodSymbol.overrides(sym, (Symbol.TypeSymbol)methodSymbol.owner, types, true)) continue;
            return (Symbol.MethodSymbol)sym;
        }
        return null;
    }

    public static Set<Symbol.MethodSymbol> findSuperMethods(Symbol.MethodSymbol methodSymbol, Types types) {
        return ASTHelpers.findSuperMethods(methodSymbol, types, false).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Optional<Symbol.MethodSymbol> findSuperMethod(Symbol.MethodSymbol methodSymbol, Types types) {
        return ASTHelpers.findSuperMethods(methodSymbol, types, true).findFirst();
    }

    private static Stream<Symbol.MethodSymbol> findSuperMethods(Symbol.MethodSymbol methodSymbol, Types types, boolean skipInterfaces) {
        Symbol.TypeSymbol owner = (Symbol.TypeSymbol)methodSymbol.owner;
        Stream<Object> typeStream = types.closure(owner.type).stream();
        if (skipInterfaces) {
            typeStream = typeStream.filter(type -> !type.isInterface());
        }
        return typeStream.map(type -> ASTHelpers.findSuperMethodInType(methodSymbol, type, types)).filter(Objects::nonNull);
    }

    public static Stream<Symbol.MethodSymbol> matchingMethods(Name name, Predicate<Symbol.MethodSymbol> predicate, Type startClass, Types types) {
        Filter matchesMethodPredicate = sym -> sym instanceof Symbol.MethodSymbol && predicate.test((Symbol.MethodSymbol)sym);
        return types.closure(startClass).stream().flatMap(superClass -> {
            Symbol.TypeSymbol superClassSymbol = superClass.tsym;
            Scope.WriteableScope superClassSymbols = superClassSymbol.members();
            if (superClassSymbols == null) {
                return Stream.empty();
            }
            return Streams.stream((Iterable)superClassSymbols.getSymbolsByName(name, matchesMethodPredicate, Scope.LookupKind.NON_RECURSIVE)).map(symbol -> (Symbol.MethodSymbol)symbol);
        });
    }

    public static Set<Symbol.MethodSymbol> findMatchingMethods(Name name, com.google.common.base.Predicate<Symbol.MethodSymbol> predicate, Type startClass, Types types) {
        return (Set)ASTHelpers.matchingMethods(name, predicate, startClass, types).collect(ImmutableSet.toImmutableSet());
    }

    public static boolean methodCanBeOverridden(Symbol.MethodSymbol methodSymbol) {
        if (methodSymbol.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return true;
        }
        if (methodSymbol.isStatic() || methodSymbol.isPrivate() || ASTHelpers.isFinal(methodSymbol) || methodSymbol.isConstructor()) {
            return false;
        }
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)methodSymbol.owner;
        return !ASTHelpers.isFinal(classSymbol) && !classSymbol.isAnonymous();
    }

    private static boolean isFinal(Symbol symbol) {
        return (symbol.flags() & 0x10L) == 16L;
    }

    public static boolean hasAnnotation(Symbol sym, String annotationClass, VisitorState state) {
        if (sym == null) {
            return false;
        }
        Name annotationName = state.getName(annotationClass = annotationClass.replace('$', '.'));
        if (ASTHelpers.hasAttribute(sym, annotationName)) {
            return true;
        }
        if (sym instanceof Symbol.ClassSymbol && ASTHelpers.isInherited(state, annotationClass)) {
            do {
                if (!ASTHelpers.hasAttribute(sym, annotationName)) continue;
                return true;
            } while ((sym = ((Symbol.ClassSymbol)sym).getSuperclass().tsym) instanceof Symbol.ClassSymbol);
        }
        return false;
    }

    private static boolean isInherited(VisitorState state, Name annotationName) {
        return (Boolean)inheritedAnnotationCache.get((Object)annotationName, name -> {
            Symbol.ClassSymbol annotationSym = state.getSymbolFromName((Name)name);
            if (annotationSym == null) {
                return false;
            }
            try {
                ((Symbol)annotationSym).complete();
            }
            catch (Symbol.CompletionFailure completionFailure) {
                // empty catch block
            }
            Symbol.TypeSymbol inheritedSym = state.getSymtab().inheritedType.tsym;
            return annotationSym.attribute(inheritedSym) != null;
        });
    }

    private static boolean isInherited(VisitorState state, String annotationName) {
        return ASTHelpers.isInherited(state, state.binaryNameFromClassname(annotationName));
    }

    private static boolean hasAttribute(Symbol sym, Name annotationName) {
        for (Attribute.Compound a : sym.getRawAttributes()) {
            if (!a.type.tsym.getQualifiedName().equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    public static Set<Name> annotationsAmong(Symbol sym, Set<? extends Name> annotationClasses, VisitorState state) {
        if (sym == null) {
            return ImmutableSet.of();
        }
        Set<Name> result = ASTHelpers.directAnnotationsAmong(sym, annotationClasses);
        if (!(sym instanceof Symbol.ClassSymbol)) {
            return result;
        }
        HashSet<Name> possibleInherited = new HashSet<Name>();
        for (Name name : annotationClasses) {
            if (result.contains(name) || !ASTHelpers.isInherited(state, name)) continue;
            possibleInherited.add(name);
        }
        sym = ((Symbol.ClassSymbol)sym).getSuperclass().tsym;
        while (sym instanceof Symbol.ClassSymbol && !possibleInherited.isEmpty()) {
            for (Name name : ASTHelpers.directAnnotationsAmong(sym, possibleInherited)) {
                result.add(name);
                possibleInherited.remove(name);
            }
            sym = ((Symbol.ClassSymbol)sym).getSuperclass().tsym;
        }
        return result;
    }

    private static Set<Name> directAnnotationsAmong(Symbol sym, Set<? extends Name> binaryAnnotationNames) {
        HashSet<Name> result = new HashSet<Name>();
        for (Attribute.Compound a : sym.getRawAttributes()) {
            Name annoName = a.type.tsym.flatName();
            if (!binaryAnnotationNames.contains(annoName)) continue;
            result.add(annoName);
        }
        return result;
    }

    public static boolean hasAnnotation(Symbol sym, Class<? extends Annotation> annotationClass, VisitorState state) {
        return ASTHelpers.hasAnnotation(sym, annotationClass.getName(), state);
    }

    public static boolean hasAnnotation(Tree tree, String annotationClass, VisitorState state) {
        Symbol sym = ASTHelpers.getDeclaredSymbol(tree);
        return ASTHelpers.hasAnnotation(sym, annotationClass, state);
    }

    public static boolean hasAnnotation(Tree tree, Class<? extends Annotation> annotationClass, VisitorState state) {
        return ASTHelpers.hasAnnotation(tree, annotationClass.getName(), state);
    }

    public static boolean hasDirectAnnotationWithSimpleName(Symbol sym, String simpleName) {
        for (AnnotationMirror annotation : sym.getAnnotationMirrors()) {
            if (!annotation.getAnnotationType().asElement().getSimpleName().contentEquals(simpleName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDirectAnnotationWithSimpleName(Tree tree, String simpleName) {
        return ASTHelpers.hasDirectAnnotationWithSimpleName(ASTHelpers.getDeclaredSymbol(tree), simpleName);
    }

    @Nullable
    @Deprecated
    public static <T extends Annotation> T getAnnotation(Tree tree, Class<T> annotationClass) {
        Symbol sym = ASTHelpers.getSymbol(tree);
        return sym == null ? null : (T)ASTHelpers.getAnnotation(sym, annotationClass);
    }

    @Nullable
    @Deprecated
    public static <T extends Annotation> T getAnnotation(Symbol sym, Class<T> annotationClass) {
        return sym == null ? null : (T)sym.getAnnotation(annotationClass);
    }

    public static LinkedHashSet<String> enumValues(Symbol.TypeSymbol enumType) {
        if (enumType.getKind() != ElementKind.ENUM) {
            throw new IllegalStateException();
        }
        Scope.WriteableScope scope = enumType.members();
        ArrayDeque<String> values = new ArrayDeque<String>();
        for (Symbol sym : scope.getSymbols()) {
            Symbol.VarSymbol var;
            if (!(sym instanceof Symbol.VarSymbol) || ((var = (Symbol.VarSymbol)sym).flags() & 0x4000L) == 0L) continue;
            values.push(sym.name.toString());
        }
        return new LinkedHashSet<String>(values);
    }

    public static boolean isGeneratedConstructor(MethodTree tree) {
        if (!(tree instanceof JCTree.JCMethodDecl)) {
            return false;
        }
        return (((JCTree.JCMethodDecl)tree).mods.flags & 0x1000000000L) == 0x1000000000L;
    }

    public static java.util.List<MethodTree> getConstructors(ClassTree classTree) {
        ArrayList<MethodTree> constructors = new ArrayList<MethodTree>();
        for (Tree tree : classTree.getMembers()) {
            MethodTree methodTree;
            if (!(tree instanceof MethodTree) || !ASTHelpers.getSymbol(methodTree = (MethodTree)tree).isConstructor()) continue;
            constructors.add(methodTree);
        }
        return constructors;
    }

    @Nullable
    public static Type getType(@Nullable Tree tree) {
        return tree instanceof JCTree ? ((JCTree)tree).type : null;
    }

    @Nullable
    public static Type.ClassType getType(@Nullable ClassTree tree) {
        Type type = ASTHelpers.getType((Tree)tree);
        return type instanceof Type.ClassType ? (Type.ClassType)type : null;
    }

    @Nullable
    public static String getAnnotationName(AnnotationTree tree) {
        Symbol sym = ASTHelpers.getSymbol(tree);
        return sym == null ? null : sym.name.toString();
    }

    public static Tree getErasedTypeTree(Tree tree) {
        return tree.accept(new SimpleTreeVisitor<Tree, Void>(){

            @Override
            public Tree visitIdentifier(IdentifierTree tree, Void unused) {
                return tree;
            }

            @Override
            public Tree visitParameterizedType(ParameterizedTypeTree tree, Void unused) {
                return tree.getType();
            }
        }, null);
    }

    public static Symbol.ClassSymbol enclosingClass(Symbol sym) {
        return sym.owner == null ? null : sym.owner.enclClass();
    }

    public static Symbol.PackageSymbol enclosingPackage(Symbol sym) {
        return sym.packge();
    }

    public static boolean inSamePackage(Symbol targetSymbol, VisitorState state) {
        JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)state.getPath().getCompilationUnit();
        Symbol.PackageSymbol usePackage = compilationUnit.packge;
        Symbol.PackageSymbol targetPackage = targetSymbol.packge();
        return targetPackage != null && usePackage != null && targetPackage.getQualifiedName().equals(usePackage.getQualifiedName());
    }

    public static Nullness getNullnessValue(ExpressionTree expr, VisitorState state, NullnessAnalysis nullnessAnalysis) {
        TreePath pathToExpr = new TreePath(state.getPath(), expr);
        return nullnessAnalysis.getNullness(pathToExpr, state.context);
    }

    @Nullable
    public static Object constValue(Tree tree) {
        Object value;
        if (tree == null) {
            return null;
        }
        tree = ASTHelpers.stripParentheses(tree);
        Type type = ASTHelpers.getType(tree);
        if (tree instanceof JCTree.JCLiteral) {
            value = ((JCTree.JCLiteral)tree).value;
        } else if (type != null) {
            value = type.constValue();
        } else {
            return null;
        }
        if (type.hasTag(TypeTag.BOOLEAN) && value instanceof Integer) {
            return (Integer)value == 1;
        }
        return value;
    }

    @Nullable
    public static <T> T constValue(Tree tree, Class<? extends T> clazz) {
        Object value = ASTHelpers.constValue(tree);
        return clazz.isInstance(value) ? (T)clazz.cast(value) : null;
    }

    public static boolean isVoidType(Type type, VisitorState state) {
        if (type == null) {
            return false;
        }
        return type.getKind() == TypeKind.VOID || state.getTypes().isSameType(Suppliers.JAVA_LANG_VOID_TYPE.get(state), type);
    }

    public static boolean isSubtype(Type s, Type t, VisitorState state) {
        if (s == null || t == null) {
            return false;
        }
        if (SUBTYPE_UNDEFINED.contains((Object)s.getTag()) || SUBTYPE_UNDEFINED.contains((Object)t.getTag())) {
            return false;
        }
        Types types = state.getTypes();
        return types.isSubtype(types.erasure(s), types.erasure(t));
    }

    public static boolean isCheckedExceptionType(Type t, VisitorState state) {
        Symtab symtab = state.getSymtab();
        return ASTHelpers.isSubtype(t, symtab.throwableType, state) && !ASTHelpers.isSubtype(t, symtab.runtimeExceptionType, state) && !ASTHelpers.isSubtype(t, symtab.errorType, state);
    }

    public static boolean isCastable(Type s, Type t, VisitorState state) {
        if (s == null || t == null) {
            return false;
        }
        Types types = state.getTypes();
        return types.isCastable(types.erasure(s), types.erasure(t));
    }

    public static boolean isSameType(Type s, Type t, VisitorState state) {
        if (s == null || t == null) {
            return false;
        }
        Types types = state.getTypes();
        return types.isSameType(types.erasure(s), types.erasure(t));
    }

    @Nullable
    public static ModifiersTree getModifiers(Tree tree) {
        if (tree instanceof ClassTree) {
            return ((ClassTree)tree).getModifiers();
        }
        if (tree instanceof MethodTree) {
            return ((MethodTree)tree).getModifiers();
        }
        if (tree instanceof VariableTree) {
            return ((VariableTree)tree).getModifiers();
        }
        return null;
    }

    public static Type getUpperBound(Type type, Types types) {
        if (type.hasTag(TypeTag.WILDCARD)) {
            return types.wildUpperBound(type);
        }
        if (type.hasTag(TypeTag.TYPEVAR) && ((Type.TypeVar)type).isCaptured()) {
            return types.cvarUpperBound(type);
        }
        if (type.getUpperBound() != null) {
            return type.getUpperBound();
        }
        return type;
    }

    public static boolean isJUnitTestCode(VisitorState state) {
        for (Tree ancestor : state.getPath()) {
            if (ancestor instanceof MethodTree && JUnitMatchers.hasJUnitAnnotation((MethodTree)ancestor, state)) {
                return true;
            }
            if (!(ancestor instanceof ClassTree) || !JUnitMatchers.isTestCaseDescendant.matches((ClassTree)ancestor, state) && !ASTHelpers.hasAnnotation(ASTHelpers.getSymbol(ancestor), "org.junit.runner.RunWith", state)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static AnnotationTree getAnnotationWithSimpleName(java.util.List<? extends AnnotationTree> annotations, String name) {
        for (AnnotationTree annotationTree : annotations) {
            if (!ASTHelpers.hasSimpleName(annotationTree, name)) continue;
            return annotationTree;
        }
        return null;
    }

    private static boolean hasSimpleName(AnnotationTree annotation, String name) {
        javax.lang.model.element.Name simpleName;
        Tree annotationType = annotation.getAnnotationType();
        if (annotationType instanceof IdentifierTree) {
            simpleName = ((IdentifierTree)annotationType).getName();
        } else if (annotationType instanceof MemberSelectTree) {
            simpleName = ((MemberSelectTree)annotationType).getIdentifier();
        } else {
            return false;
        }
        return simpleName.contentEquals(name);
    }

    @Nullable
    public static TypeAnnotations.AnnotationType getAnnotationType(AnnotationTree anno, @Nullable Symbol target, VisitorState state) {
        if (target == null) {
            return null;
        }
        Symbol annoSymbol = ASTHelpers.getSymbol(anno);
        if (annoSymbol == null) {
            return null;
        }
        Attribute.Compound compound = target.attribute(annoSymbol);
        if (compound == null) {
            for (Attribute.TypeCompound typeCompound : target.getRawTypeAttributes()) {
                if (!typeCompound.type.tsym.equals(annoSymbol)) continue;
                compound = typeCompound;
                break;
            }
        }
        if (compound == null) {
            return null;
        }
        return TypeAnnotations.instance(state.context).annotationTargetType(compound, target);
    }

    @Nullable
    public static String getFileName(CompilationUnitTree tree) {
        return ASTHelpers.getFileNameFromUri(tree.getSourceFile().toUri());
    }

    @Nullable
    public static String getFileNameFromUri(URI uri) {
        if (!uri.getScheme().equals("jar")) {
            return uri.getPath();
        }
        try {
            String jarEntryFileName = ((JarURLConnection)uri.toURL().openConnection()).getEntryName();
            jarEntryFileName = BACKSLASH_MATCHER.replaceFrom((CharSequence)jarEntryFileName, '/');
            if (!jarEntryFileName.startsWith("/")) {
                jarEntryFileName = "/" + jarEntryFileName;
            }
            return jarEntryFileName;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Symbol.MethodSymbol resolveExistingMethod(VisitorState state, Symbol.TypeSymbol base, Name name, Iterable<Type> argTypes, Iterable<Type> tyargTypes) {
        Resolve resolve = Resolve.instance(state.context);
        Enter enter = Enter.instance(state.context);
        Log log = Log.instance(state.context);
        Log.DeferredDiagnosticHandler handler = new Log.DeferredDiagnosticHandler(log);
        try {
            Symbol.MethodSymbol methodSymbol = resolve.resolveInternalMethod(null, enter.getEnv(base), base.type, name, List.from(argTypes), List.from(tyargTypes));
            return methodSymbol;
        }
        catch (FatalError e) {
            Symbol.MethodSymbol methodSymbol = null;
            return methodSymbol;
        }
        finally {
            log.popDiagnosticHandler(handler);
        }
    }

    public static ImmutableSet<String> getGeneratedBy(VisitorState state) {
        return (ImmutableSet)Streams.stream((Iterable)state.getPath()).filter(ClassTree.class::isInstance).flatMap(enclosing -> ASTHelpers.getGeneratedBy(ASTHelpers.getSymbol(enclosing), state).stream()).collect(ImmutableSet.toImmutableSet());
    }

    public static ImmutableSet<String> getGeneratedBy(Symbol symbol, VisitorState state) {
        Preconditions.checkNotNull((Object)symbol);
        Optional<Attribute.Compound> c = Stream.of("javax.annotation.Generated", "javax.annotation.processing.Generated").map(state::getSymbolFromString).filter(a -> a != null).map(symbol::attribute).filter(a -> a != null).findFirst();
        if (!c.isPresent()) {
            return ImmutableSet.of();
        }
        Optional<Attribute> values = c.get().getElementValues().entrySet().stream().filter(e -> ((Name)((Symbol.MethodSymbol)e.getKey()).getSimpleName()).contentEquals("value")).map(e -> (Attribute)e.getValue()).findAny();
        if (!values.isPresent()) {
            return ImmutableSet.of();
        }
        return (ImmutableSet)MoreAnnotations.asStrings((AnnotationValue)values.get()).collect(ImmutableSet.toImmutableSet());
    }

    @Nullable
    private static Type unaryNumericPromotion(Type type, VisitorState state) {
        Type unboxed = ASTHelpers.unboxAndEnsureNumeric(type, state);
        switch (unboxed.getTag()) {
            case BYTE: 
            case SHORT: 
            case CHAR: {
                return state.getSymtab().intType;
            }
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return unboxed;
            }
        }
        throw new AssertionError((Object)("Should not reach here: " + type));
    }

    @Nullable
    private static Type binaryNumericPromotion(Type leftType, Type rightType, VisitorState state) {
        Type unboxedLeft = ASTHelpers.unboxAndEnsureNumeric(leftType, state);
        Type unboxedRight = ASTHelpers.unboxAndEnsureNumeric(rightType, state);
        EnumSet<TypeTag> tags = EnumSet.of(unboxedLeft.getTag(), unboxedRight.getTag());
        if (tags.contains((Object)TypeTag.DOUBLE)) {
            return state.getSymtab().doubleType;
        }
        if (tags.contains((Object)TypeTag.FLOAT)) {
            return state.getSymtab().floatType;
        }
        if (tags.contains((Object)TypeTag.LONG)) {
            return state.getSymtab().longType;
        }
        return state.getSymtab().intType;
    }

    private static Type unboxAndEnsureNumeric(Type type, VisitorState state) {
        Type unboxed = state.getTypes().unboxedTypeOrType(type);
        Preconditions.checkArgument((boolean)unboxed.isNumeric(), (String)"[%s] is not numeric", (Object)type);
        return unboxed;
    }

    @Nullable
    public static TargetType targetType(VisitorState state) {
        ExpressionTree current;
        if (!ASTHelpers.canHaveTargetType(state.getPath().getLeaf())) {
            return null;
        }
        TreePath parent = state.getPath();
        do {
            current = (ExpressionTree)parent.getLeaf();
        } while ((parent = parent.getParentPath()) != null && parent.getLeaf().getKind() == Tree.Kind.PARENTHESIZED);
        if (parent == null) {
            return null;
        }
        Type type = (Type)new TargetTypeVisitor(current, state, parent).visit(parent.getLeaf(), null);
        if (type == null) {
            return null;
        }
        return TargetType.create(type, parent);
    }

    private static boolean canHaveTargetType(Tree tree) {
        if (!(tree instanceof ExpressionTree)) {
            return false;
        }
        switch (tree.getKind()) {
            case IDENTIFIER: 
            case MEMBER_SELECT: {
                if (ASTHelpers.getSymbol(tree) instanceof Symbol.VarSymbol) break;
                return false;
            }
            case PRIMITIVE_TYPE: 
            case ARRAY_TYPE: 
            case PARAMETERIZED_TYPE: 
            case EXTENDS_WILDCARD: 
            case SUPER_WILDCARD: 
            case UNBOUNDED_WILDCARD: 
            case ANNOTATED_TYPE: 
            case INTERSECTION_TYPE: 
            case TYPE_ANNOTATION: {
                return false;
            }
            case ANNOTATION: {
                return false;
            }
        }
        return true;
    }

    public static Stream<Attribute.Compound> getDeclarationAndTypeAttributes(Symbol sym) {
        return MoreAnnotations.getDeclarationAndTypeAttributes(sym);
    }

    public static AnnotationMirror getAnnotationMirror(AnnotationTree annotationTree) {
        return ((JCTree.JCAnnotation)annotationTree).attribute;
    }

    public static boolean containsComments(Tree tree, VisitorState state) {
        return state.getOffsetTokensForNode(tree).stream().anyMatch(t -> !t.comments().isEmpty());
    }

    @Nullable
    public static Symbol.ClassSymbol outermostClass(Symbol symbol) {
        Symbol.ClassSymbol encl;
        Symbol.ClassSymbol curr = symbol.enclClass();
        while (curr != null && curr.owner != null && (encl = curr.owner.enclClass()) != null) {
            curr = encl;
        }
        return curr;
    }

    public static boolean isConsideredFinal(Symbol symbol) {
        return (symbol.flags() & 0x20000000010L) != 0L;
    }

    public static ImmutableSet<Type> getThrownExceptions(Tree tree, VisitorState state) {
        ScanThrownTypes scanner = new ScanThrownTypes(state);
        scanner.scan(tree, null);
        return ImmutableSet.copyOf(scanner.getThrownTypes());
    }

    public static final class ScanThrownTypes
    extends TreeScanner<Void, Void> {
        boolean inResources = false;
        ArrayDeque<Set<Type>> thrownTypes = new ArrayDeque();
        SetMultimap<Symbol.VarSymbol, Type> thrownTypesByVariable = HashMultimap.create();
        private final VisitorState state;
        private final Types types;
        private static final Supplier<Type> AUTOCLOSEABLE = Suppliers.typeFromString("java.lang.AutoCloseable");
        private static final Supplier<Name> CLOSE = VisitorState.memoize(state -> state.getName("close"));

        public ScanThrownTypes(VisitorState state) {
            this.state = state;
            this.types = state.getTypes();
            this.thrownTypes.push(new HashSet());
        }

        public Set<Type> getThrownTypes() {
            return this.thrownTypes.peek();
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree invocation, Void unused) {
            Type type = ASTHelpers.getType(invocation.getMethodSelect());
            if (type != null) {
                this.getThrownTypes().addAll(type.getThrownTypes());
            }
            return (Void)super.visitMethodInvocation(invocation, null);
        }

        @Override
        public Void visitTry(TryTree tree, Void unused) {
            this.thrownTypes.push(new HashSet());
            this.scanResources(tree);
            this.scan(tree.getBlock(), null);
            for (CatchTree catchTree : tree.getCatches()) {
                Type type = ASTHelpers.getType(catchTree.getParameter());
                HashSet<Type> matchingTypes = new HashSet<Type>();
                for (Type unionMember : ScanThrownTypes.extractTypes(type)) {
                    for (Type thrownType : this.getThrownTypes()) {
                        if (!this.types.isSubtype(thrownType, unionMember)) continue;
                        matchingTypes.add(thrownType);
                    }
                }
                this.getThrownTypes().removeAll(matchingTypes);
                this.thrownTypesByVariable.putAll((Object)ASTHelpers.getSymbol(catchTree.getParameter()), matchingTypes);
            }
            for (CatchTree catchTree : tree.getCatches()) {
                this.scan(catchTree.getBlock(), null);
            }
            this.scan(tree.getFinallyBlock(), null);
            Set<Type> fromBlock = this.thrownTypes.pop();
            this.getThrownTypes().addAll(fromBlock);
            return null;
        }

        public void scanResources(TryTree tree) {
            this.inResources = true;
            this.scan(tree.getResources(), null);
            this.inResources = false;
        }

        @Override
        public Void visitThrow(ThrowTree tree, Void unused) {
            Symbol symbol;
            if (tree.getExpression() instanceof IdentifierTree && this.thrownTypesByVariable.containsKey((Object)(symbol = ASTHelpers.getSymbol(tree.getExpression())))) {
                this.getThrownTypes().addAll(this.thrownTypesByVariable.get((Object)((Symbol.VarSymbol)symbol)));
                return (Void)super.visitThrow(tree, null);
            }
            this.getThrownTypes().addAll((Collection<Type>)ScanThrownTypes.extractTypes(ASTHelpers.getType(tree.getExpression())));
            return (Void)super.visitThrow(tree, null);
        }

        @Override
        public Void visitNewClass(NewClassTree tree, Void unused) {
            Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(tree);
            if (symbol != null) {
                this.getThrownTypes().addAll(symbol.getThrownTypes());
            }
            return (Void)super.visitNewClass(tree, null);
        }

        @Override
        public Void visitVariable(VariableTree tree, Void unused) {
            Symbol symbol;
            if (this.inResources && (symbol = ASTHelpers.getSymbol(tree.getType())) instanceof Symbol.ClassSymbol) {
                ScanThrownTypes.getCloseMethod((Symbol.ClassSymbol)symbol, this.state).ifPresent(methodSymbol -> this.getThrownTypes().addAll(methodSymbol.getThrownTypes()));
            }
            return (Void)super.visitVariable(tree, null);
        }

        @Override
        public Void visitLambdaExpression(LambdaExpressionTree tree, Void unused) {
            return null;
        }

        @Override
        public Void visitClass(ClassTree tree, Void unused) {
            return null;
        }

        @Override
        public Void visitMethod(MethodTree tree, Void unused) {
            return null;
        }

        private static Optional<Symbol.MethodSymbol> getCloseMethod(Symbol.ClassSymbol symbol, VisitorState state) {
            Types types = state.getTypes();
            if (!types.isAssignable(symbol.type, AUTOCLOSEABLE.get(state))) {
                return Optional.empty();
            }
            Type.JCVoidType voidType = state.getSymtab().voidType;
            Optional<Symbol.MethodSymbol> declaredCloseMethod = ASTHelpers.matchingMethods(CLOSE.get(state), s -> !s.isConstructor() && s.params.isEmpty() && types.isSameType(s.getReturnType(), voidType), symbol.type, types).findFirst();
            Verify.verify((boolean)declaredCloseMethod.isPresent(), (String)"%s implements AutoCloseable but no method named close() exists, even inherited", (Object)symbol);
            return declaredCloseMethod;
        }

        private static ImmutableList<Type> extractTypes(@Nullable Type type) {
            if (type == null) {
                return ImmutableList.of();
            }
            if (type.isUnion()) {
                Type.UnionClassType unionType = (Type.UnionClassType)type;
                return ImmutableList.copyOf(unionType.getAlternativeTypes());
            }
            return ImmutableList.of((Object)type);
        }
    }

    @VisibleForTesting
    static class TargetTypeVisitor
    extends SimpleTreeVisitor<Type, Void> {
        private final VisitorState state;
        private final TreePath parent;
        private final ExpressionTree current;

        private TargetTypeVisitor(ExpressionTree current, VisitorState state, TreePath parent) {
            this.current = current;
            this.state = state;
            this.parent = parent;
        }

        @Override
        @Nullable
        public Type visitArrayAccess(ArrayAccessTree node, Void unused) {
            if (this.current.equals(node.getIndex())) {
                return this.state.getSymtab().intType;
            }
            return ASTHelpers.getType(node.getExpression());
        }

        @Override
        public Type visitAssert(AssertTree node, Void unused) {
            return this.current.equals(node.getCondition()) ? this.state.getSymtab().booleanType : this.state.getSymtab().stringType;
        }

        @Override
        @Nullable
        public Type visitAssignment(AssignmentTree tree, Void unused) {
            return ASTHelpers.getType(tree.getVariable());
        }

        @Override
        public Type visitAnnotation(AnnotationTree tree, Void unused) {
            return null;
        }

        @Override
        public Type visitCase(CaseTree tree, Void unused) {
            SwitchTree switchTree = (SwitchTree)this.parent.getParentPath().getLeaf();
            return ASTHelpers.getType(switchTree.getExpression());
        }

        @Override
        public Type visitClass(ClassTree node, Void unused) {
            return null;
        }

        @Override
        @Nullable
        public Type visitCompoundAssignment(CompoundAssignmentTree tree, Void unused) {
            Type variableType = ASTHelpers.getType(tree.getVariable());
            Type expressionType = ASTHelpers.getType(tree.getExpression());
            Types types = this.state.getTypes();
            switch (tree.getKind()) {
                case LEFT_SHIFT_ASSIGNMENT: 
                case RIGHT_SHIFT_ASSIGNMENT: 
                case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                    if (!tree.getExpression().equals(this.current)) break;
                    return ASTHelpers.unaryNumericPromotion(expressionType, this.state);
                }
                case PLUS_ASSIGNMENT: {
                    Type stringType = this.state.getSymtab().stringType;
                    if (!types.isSameType(stringType, variableType)) break;
                    return stringType;
                }
            }
            return types.unboxedTypeOrType(variableType).getTag() == TypeTag.BOOLEAN ? this.state.getSymtab().booleanType : ASTHelpers.binaryNumericPromotion(variableType, expressionType, this.state);
        }

        @Override
        public Type visitEnhancedForLoop(EnhancedForLoopTree node, Void unused) {
            Type variableType = ASTHelpers.getType(node.getVariable());
            if (this.state.getTypes().isArray(ASTHelpers.getType(node.getExpression()))) {
                return this.state.getType(variableType, true, (java.util.List<Type>)ImmutableList.of());
            }
            variableType = this.state.getTypes().boxedTypeOrType(variableType);
            return this.state.getType(this.state.getSymtab().iterableType, false, (java.util.List<Type>)ImmutableList.of((Object)new Type.WildcardType(variableType, BoundKind.EXTENDS, variableType.tsym)));
        }

        @Override
        public Type visitInstanceOf(InstanceOfTree node, Void unused) {
            return this.state.getSymtab().objectType;
        }

        @Override
        public Type visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree, Void unused) {
            return this.state.getTypes().findDescriptorType(ASTHelpers.getType(lambdaExpressionTree)).getReturnType();
        }

        @Override
        public Type visitMethod(MethodTree node, Void unused) {
            return null;
        }

        @Override
        public Type visitParenthesized(ParenthesizedTree node, Void unused) {
            return (Type)this.visit(node.getExpression(), unused);
        }

        @Override
        @Nullable
        public Type visitReturn(ReturnTree tree, Void unused) {
            for (TreePath path = this.parent; path != null; path = path.getParentPath()) {
                Tree enclosing = path.getLeaf();
                switch (enclosing.getKind()) {
                    case METHOD: {
                        return ASTHelpers.getType(((MethodTree)enclosing).getReturnType());
                    }
                    case LAMBDA_EXPRESSION: {
                        return this.visitLambdaExpression((LambdaExpressionTree)enclosing, null);
                    }
                }
            }
            throw new AssertionError((Object)"return not enclosed by method or lambda");
        }

        @Override
        public Type visitSynchronized(SynchronizedTree node, Void unused) {
            return Objects.equals(this.current, node.getExpression()) ? this.state.getSymtab().objectType : null;
        }

        @Override
        public Type visitThrow(ThrowTree node, Void unused) {
            return ASTHelpers.getType(this.current);
        }

        @Override
        public Type visitTypeCast(TypeCastTree node, Void unused) {
            return ASTHelpers.getType(node.getType());
        }

        @Override
        @Nullable
        public Type visitVariable(VariableTree tree, Void unused) {
            return ASTHelpers.getType(tree.getType());
        }

        @Override
        @Nullable
        public Type visitUnary(UnaryTree tree, Void unused) {
            return ASTHelpers.getType(tree);
        }

        @Override
        @Nullable
        public Type visitBinary(BinaryTree tree, Void unused) {
            Type leftType = (Type)Preconditions.checkNotNull((Object)ASTHelpers.getType(tree.getLeftOperand()));
            Type rightType = (Type)Preconditions.checkNotNull((Object)ASTHelpers.getType(tree.getRightOperand()));
            switch (tree.getKind()) {
                case PLUS: {
                    Type stringType = this.state.getSymtab().stringType;
                    if (ASTHelpers.isSameType(stringType, leftType, this.state) || ASTHelpers.isSameType(stringType, rightType, this.state)) {
                        return stringType;
                    }
                }
                case MINUS: 
                case MULTIPLY: 
                case DIVIDE: 
                case REMAINDER: 
                case LESS_THAN: 
                case LESS_THAN_EQUAL: 
                case GREATER_THAN: 
                case GREATER_THAN_EQUAL: 
                case AND: 
                case XOR: 
                case OR: {
                    if (TargetTypeVisitor.typeIsBoolean(this.state.getTypes().unboxedTypeOrType(leftType)) && TargetTypeVisitor.typeIsBoolean(this.state.getTypes().unboxedTypeOrType(rightType))) {
                        return this.state.getSymtab().booleanType;
                    }
                    return ASTHelpers.binaryNumericPromotion(leftType, rightType, this.state);
                }
                case EQUAL_TO: 
                case NOT_EQUAL_TO: {
                    return this.handleEqualityOperator(tree, leftType, rightType);
                }
                case LEFT_SHIFT: 
                case RIGHT_SHIFT: 
                case UNSIGNED_RIGHT_SHIFT: {
                    return ASTHelpers.unaryNumericPromotion(ASTHelpers.getType(this.current), this.state);
                }
            }
            return ASTHelpers.getType(tree);
        }

        @Nullable
        private Type handleEqualityOperator(BinaryTree tree, Type leftType, Type rightType) {
            Type unboxedLeft = (Type)Preconditions.checkNotNull((Object)this.state.getTypes().unboxedTypeOrType(leftType));
            Type unboxedRight = (Type)Preconditions.checkNotNull((Object)this.state.getTypes().unboxedTypeOrType(rightType));
            if (leftType.isNumeric() && rightType.isNumeric() || leftType.isNumeric() != rightType.isNumeric() && (unboxedLeft.isNumeric() || unboxedRight.isNumeric())) {
                return ASTHelpers.binaryNumericPromotion(unboxedLeft, unboxedRight, this.state);
            }
            boolean leftIsBoolean = TargetTypeVisitor.typeIsBoolean(leftType);
            boolean rightIsBoolean = TargetTypeVisitor.typeIsBoolean(rightType);
            if (leftIsBoolean && rightIsBoolean || leftIsBoolean != rightIsBoolean && (TargetTypeVisitor.typeIsBoolean(unboxedLeft) || TargetTypeVisitor.typeIsBoolean(unboxedRight))) {
                return this.state.getSymtab().booleanType;
            }
            return tree.getLeftOperand().equals(this.current) ? leftType : rightType;
        }

        private static boolean typeIsBoolean(Type type) {
            return type.getTag() == TypeTag.BOOLEAN;
        }

        @Override
        @Nullable
        public Type visitConditionalExpression(ConditionalExpressionTree tree, Void unused) {
            return tree.getCondition().equals(this.current) ? this.state.getSymtab().booleanType : ASTHelpers.getType(tree);
        }

        @Override
        public Type visitNewClass(NewClassTree tree, Void unused) {
            if (Objects.equals(this.current, tree.getEnclosingExpression())) {
                return ((Symbol.ClassSymbol)ASTHelpers.getSymbol((Tree)tree.getIdentifier())).owner.type;
            }
            return this.visitMethodInvocationOrNewClass(tree.getArguments(), ASTHelpers.getSymbol(tree), ((JCTree.JCNewClass)tree).constructorType);
        }

        @Override
        public Type visitMethodInvocation(MethodInvocationTree tree, Void unused) {
            return this.visitMethodInvocationOrNewClass(tree.getArguments(), ASTHelpers.getSymbol(tree), ((JCTree.JCMethodInvocation)tree).meth.type);
        }

        @Nullable
        private Type visitMethodInvocationOrNewClass(java.util.List<? extends ExpressionTree> arguments, Symbol.MethodSymbol sym, Type type) {
            int idx = arguments.indexOf(this.current);
            if (idx == -1) {
                return null;
            }
            if (type.getParameterTypes().size() <= idx) {
                if (!sym.isVarArgs()) {
                    if ((sym.flags() & 0x2000000000L) != 0L) {
                        return null;
                    }
                    throw new IllegalStateException(String.format("saw %d formal parameters and %d actual parameters on non-varargs method %s\n", type.getParameterTypes().size(), arguments.size(), sym));
                }
                idx = type.getParameterTypes().size() - 1;
            }
            Type argType = type.getParameterTypes().get(idx);
            if (sym.isVarArgs() && idx == type.getParameterTypes().size() - 1) {
                argType = this.state.getTypes().elemtype(argType);
            }
            return argType;
        }

        @Override
        public Type visitIf(IfTree tree, Void unused) {
            return this.getConditionType(tree.getCondition());
        }

        @Override
        public Type visitWhileLoop(WhileLoopTree tree, Void unused) {
            return this.getConditionType(tree.getCondition());
        }

        @Override
        public Type visitDoWhileLoop(DoWhileLoopTree tree, Void unused) {
            return this.getConditionType(tree.getCondition());
        }

        @Override
        public Type visitForLoop(ForLoopTree tree, Void unused) {
            return this.getConditionType(tree.getCondition());
        }

        @Override
        @Nullable
        public Type visitSwitch(SwitchTree node, Void unused) {
            if (this.current == node.getExpression()) {
                return this.state.getTypes().unboxedTypeOrType(ASTHelpers.getType(this.current));
            }
            return null;
        }

        @Override
        @Nullable
        public Type visitNewArray(NewArrayTree node, Void unused) {
            if (Objects.equals(node.getType(), this.current)) {
                return null;
            }
            if (node.getDimensions().contains(this.current)) {
                return this.state.getSymtab().intType;
            }
            if (node.getInitializers() != null && node.getInitializers().contains(this.current)) {
                return this.state.getTypes().elemtype(ASTHelpers.getType(node));
            }
            return null;
        }

        @Override
        @Nullable
        public Type visitMemberSelect(MemberSelectTree node, Void unused) {
            if (this.current.equals(node.getExpression())) {
                return ASTHelpers.getType(node.getExpression());
            }
            return null;
        }

        @Override
        public Type visitMemberReference(MemberReferenceTree node, Void unused) {
            return this.state.getTypes().findDescriptorType(ASTHelpers.getType(node)).getReturnType();
        }

        @Nullable
        private Type getConditionType(Tree condition) {
            if (condition != null && condition.equals(this.current)) {
                return this.state.getSymtab().booleanType;
            }
            return null;
        }
    }

    @AutoValue
    public static abstract class TargetType {
        public abstract Type type();

        public abstract TreePath path();

        static TargetType create(Type type, TreePath path) {
            return new AutoValue_ASTHelpers_TargetType(type, path);
        }
    }
}

