// Copyright 2018 The Bazel Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.devtools.build.lib.starlarkbuildapi.apple;

import com.google.devtools.build.docgen.annot.DocCategory;
import com.google.devtools.build.docgen.annot.StarlarkConstructor;
import com.google.devtools.build.lib.starlarkbuildapi.FileApi;
import com.google.devtools.build.lib.starlarkbuildapi.core.ProviderApi;
import com.google.devtools.build.lib.starlarkbuildapi.core.StructApi;
import net.starlark.java.annot.Param;
import net.starlark.java.annot.StarlarkBuiltin;
import net.starlark.java.annot.StarlarkMethod;
import net.starlark.java.eval.EvalException;

/**
 * Interface for an info type containing information regarding multi-architecture Apple static
 * libraries.
 */
@StarlarkBuiltin(
    name = "AppleStaticLibrary",
    category = DocCategory.PROVIDER,
    doc =
        "A provider containing information regarding multi-architecture Apple static libraries, "
            + "as is propagated by the apple_static_library rule.")
public interface AppleStaticLibraryInfoApi extends StructApi {

  /** Starlark name for this interface. */
  String STARLARK_NAME = "AppleStaticLibrary";

  @StarlarkMethod(
      name = "archive",
      structField = true,
      doc = "The multi-arch archive (.a) output by apple_static_library.")
  FileApi getMultiArchArchive();

  @StarlarkMethod(
      name = "objc",
      structField = true,
      doc =
          "A provider which contains information about the transitive dependencies linked into "
              + "the archive.")
  ObjcProviderApi<?> getDepsObjcProvider();

  /** Interface for the provider type for {@link AppleStaticLibraryInfoApi}. */
  interface AppleStaticLibraryInfoProvider<
          FileApiT extends FileApi, ObjcProviderApiT extends ObjcProviderApi<?>>
      extends ProviderApi {

    @StarlarkMethod(
        name = STARLARK_NAME,
        doc = "The <code>AppleStaticLibrary</code> constructor.",
        parameters = {
          @Param(
              name = "archive",
              named = true,
              positional = false,
              doc = "Multi-architecture archive (.a) representing a static library"),
          @Param(
              name = "objc",
              named = true,
              positional = false,
              doc =
                  "A provider which contains information about the transitive dependencies "
                      + "linked into the archive."),
        },
        selfCall = true)
    @StarlarkConstructor
    AppleStaticLibraryInfoApi appleStaticLibrary(FileApiT archive, ObjcProviderApiT objcProvider)
        throws EvalException;
  }
}
