/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@CheckReturnValue
abstract class AbstractPatternSyntaxChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> REGEX_USAGE = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onExactClass("java.lang.String").namedAnyOf(new String[]{"matches", "split"}).withParameters("java.lang.String", new String[0]), Matchers.instanceMethod().onExactClass("java.lang.String").named("split").withParameters("java.lang.String", new String[]{"int"}), Matchers.instanceMethod().onExactClass("java.lang.String").namedAnyOf(new String[]{"replaceFirst", "replaceAll"}).withParameters("java.lang.String", new String[]{"java.lang.String"}), Matchers.staticMethod().onClass("java.util.regex.Pattern").named("matches"), Matchers.staticMethod().onClass("com.google.common.base.Splitter").named("onPattern")});

    AbstractPatternSyntaxChecker() {
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!REGEX_USAGE.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree arg = tree.getArguments().get(0);
        String value = (String)ASTHelpers.constValue((Tree)arg, String.class);
        if (value == null) {
            return Description.NO_MATCH;
        }
        return this.matchRegexLiteral(tree, value);
    }

    @ForOverride
    protected abstract Description matchRegexLiteral(MethodInvocationTree var1, String var2);
}

