/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;

@BugPattern(name="CheckReturnValue", altNames={"ResultOfMethodCallIgnored", "ReturnValueIgnored"}, summary="Ignored return value of method that is annotated with @CheckReturnValue", severity=BugPattern.SeverityLevel.ERROR)
public class CheckReturnValue
extends AbstractReturnValueIgnored
implements BugChecker.MethodTreeMatcher,
BugChecker.ClassTreeMatcher {
    private static final String CHECK_RETURN_VALUE = "CheckReturnValue";
    private static final String CAN_IGNORE_RETURN_VALUE = "CanIgnoreReturnValue";
    private static final String BOTH_ERROR = "@CheckReturnValue and @CanIgnoreReturnValue cannot both be applied to the same %s";

    private static Stream<Boolean> shouldCheckReturnValue(Symbol sym) {
        if (ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)sym, (String)CAN_IGNORE_RETURN_VALUE)) {
            return Stream.of(Boolean.valueOf(false));
        }
        if (ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)sym, (String)CHECK_RETURN_VALUE)) {
            return Stream.of(Boolean.valueOf(true));
        }
        return Stream.empty();
    }

    public CheckReturnValue(ErrorProneFlags flags) {
        super(flags);
    }

    public Matcher<ExpressionTree> specializedMatcher() {
        return (Matcher & Serializable)(tree, state) -> {
            Symbol sym = ASTHelpers.getSymbol((Tree)tree);
            if (!(sym instanceof Symbol.MethodSymbol)) {
                return false;
            }
            return ASTHelpers.enclosingElements((Symbol)sym).flatMap(CheckReturnValue::shouldCheckReturnValue).findFirst().orElse(false);
        };
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        String annotationToValidate;
        Symbol.MethodSymbol method = ASTHelpers.getSymbol((MethodTree)tree);
        boolean checkReturn = ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)method, (String)CHECK_RETURN_VALUE);
        boolean canIgnore = ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)method, (String)CAN_IGNORE_RETURN_VALUE);
        if (checkReturn && canIgnore) {
            return this.buildDescription(tree).setMessage(String.format(BOTH_ERROR, "method")).build();
        }
        if (checkReturn) {
            annotationToValidate = CHECK_RETURN_VALUE;
        } else if (canIgnore) {
            annotationToValidate = CAN_IGNORE_RETURN_VALUE;
        } else {
            return Description.NO_MATCH;
        }
        if (method.getKind() != ElementKind.METHOD) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isVoidType((Type)method.getReturnType(), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        String message = String.format("@%s may not be applied to void-returning methods", annotationToValidate);
        return this.buildDescription(tree).setMessage(message).build();
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)ASTHelpers.getSymbol((ClassTree)tree), (String)CHECK_RETURN_VALUE) && ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)ASTHelpers.getSymbol((ClassTree)tree), (String)CAN_IGNORE_RETURN_VALUE)) {
            return this.buildDescription(tree).setMessage(String.format(BOTH_ERROR, "class")).build();
        }
        return Description.NO_MATCH;
    }

    @Override
    protected String getMessage(Name name) {
        return String.format("Ignored return value of '%s', which is annotated with @CheckReturnValue", name);
    }
}

