/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;

@BugPattern(name="IdentityHashMapBoxing", summary="Using IdentityHashMap with a boxed type as the key is risky since boxing may produce distinct instances", severity=BugPattern.SeverityLevel.ERROR)
public class IdentityHashMapBoxing
extends BugChecker
implements BugChecker.NewClassTreeMatcher,
BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> NEW_IDENTITY_HASH_MAP = MethodMatchers.constructor().forClass("java.util.IdentityHashMap");
    private static final Matcher<ExpressionTree> MAPS_NEW_IDENTITY_HASH_MAP = MethodMatchers.staticMethod().onClass("com.google.common.collect.Maps").named("newIdentityHashMap");

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!NEW_IDENTITY_HASH_MAP.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.checkTypes(tree, state);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MAPS_NEW_IDENTITY_HASH_MAP.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.checkTypes(tree, state);
    }

    private Description checkTypes(ExpressionTree tree, VisitorState state) {
        List<Type> argumentTypes = ASTHelpers.getResultType((ExpressionTree)tree).getTypeArguments();
        if (argumentTypes.size() != 2) {
            return Description.NO_MATCH;
        }
        Type type = state.getTypes().unboxedType((Type)argumentTypes.get(0));
        switch (type.getKind()) {
            case DOUBLE: 
            case LONG: 
            case INT: 
            case FLOAT: {
                return this.describeMatch(tree);
            }
        }
        return Description.NO_MATCH;
    }
}

