/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.errorprone.refaster.AutoValue_UBinary;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.tree.JCTree;

@AutoValue
abstract class UBinary
extends UExpression
implements BinaryTree {
    static final ImmutableBiMap<Tree.Kind, JCTree.Tag> OP_CODES = new ImmutableBiMap.Builder().put((Object)Tree.Kind.PLUS, (Object)JCTree.Tag.PLUS).put((Object)Tree.Kind.MINUS, (Object)JCTree.Tag.MINUS).put((Object)Tree.Kind.MULTIPLY, (Object)JCTree.Tag.MUL).put((Object)Tree.Kind.DIVIDE, (Object)JCTree.Tag.DIV).put((Object)Tree.Kind.REMAINDER, (Object)JCTree.Tag.MOD).put((Object)Tree.Kind.LEFT_SHIFT, (Object)JCTree.Tag.SL).put((Object)Tree.Kind.RIGHT_SHIFT, (Object)JCTree.Tag.SR).put((Object)Tree.Kind.UNSIGNED_RIGHT_SHIFT, (Object)JCTree.Tag.USR).put((Object)Tree.Kind.OR, (Object)JCTree.Tag.BITOR).put((Object)Tree.Kind.AND, (Object)JCTree.Tag.BITAND).put((Object)Tree.Kind.XOR, (Object)JCTree.Tag.BITXOR).put((Object)Tree.Kind.CONDITIONAL_AND, (Object)JCTree.Tag.AND).put((Object)Tree.Kind.CONDITIONAL_OR, (Object)JCTree.Tag.OR).put((Object)Tree.Kind.LESS_THAN, (Object)JCTree.Tag.LT).put((Object)Tree.Kind.LESS_THAN_EQUAL, (Object)JCTree.Tag.LE).put((Object)Tree.Kind.GREATER_THAN, (Object)JCTree.Tag.GT).put((Object)Tree.Kind.GREATER_THAN_EQUAL, (Object)JCTree.Tag.GE).put((Object)Tree.Kind.EQUAL_TO, (Object)JCTree.Tag.EQ).put((Object)Tree.Kind.NOT_EQUAL_TO, (Object)JCTree.Tag.NE).buildOrThrow();
    static final ImmutableBiMap<Tree.Kind, Tree.Kind> NEGATION = new ImmutableBiMap.Builder().put((Object)Tree.Kind.LESS_THAN, (Object)Tree.Kind.GREATER_THAN_EQUAL).put((Object)Tree.Kind.LESS_THAN_EQUAL, (Object)Tree.Kind.GREATER_THAN).put((Object)Tree.Kind.GREATER_THAN, (Object)Tree.Kind.LESS_THAN_EQUAL).put((Object)Tree.Kind.GREATER_THAN_EQUAL, (Object)Tree.Kind.LESS_THAN).put((Object)Tree.Kind.EQUAL_TO, (Object)Tree.Kind.NOT_EQUAL_TO).put((Object)Tree.Kind.NOT_EQUAL_TO, (Object)Tree.Kind.EQUAL_TO).buildOrThrow();
    static final ImmutableBiMap<Tree.Kind, Tree.Kind> DEMORGAN = new ImmutableBiMap.Builder().put((Object)Tree.Kind.CONDITIONAL_AND, (Object)Tree.Kind.CONDITIONAL_OR).put((Object)Tree.Kind.CONDITIONAL_OR, (Object)Tree.Kind.CONDITIONAL_AND).put((Object)Tree.Kind.AND, (Object)Tree.Kind.OR).put((Object)Tree.Kind.OR, (Object)Tree.Kind.AND).buildOrThrow();

    UBinary() {
    }

    public static UBinary create(Tree.Kind binaryOp, UExpression lhs, UExpression rhs) {
        Preconditions.checkArgument((boolean)OP_CODES.containsKey((Object)binaryOp), (String)"%s is not a supported binary operation", (Object)((Object)binaryOp));
        return new AutoValue_UBinary(binaryOp, lhs, rhs);
    }

    @Override
    public abstract Tree.Kind getKind();

    @Override
    public abstract UExpression getLeftOperand();

    @Override
    public abstract UExpression getRightOperand();

    @Override
    public Choice<Unifier> visitBinary(BinaryTree binary, Unifier unifier) {
        return Choice.condition(this.getKind().equals((Object)binary.getKind()), unifier).thenChoose(Unifier.unifications(this.getLeftOperand(), binary.getLeftOperand())).thenChoose(Unifier.unifications(this.getRightOperand(), binary.getRightOperand()));
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitBinary(this, data);
    }

    @Override
    public JCTree.JCBinary inline(Inliner inliner) throws CouldNotResolveImportException {
        return inliner.maker().Binary((JCTree.Tag)((Object)OP_CODES.get((Object)this.getKind())), (JCTree.JCExpression)this.getLeftOperand().inline(inliner), (JCTree.JCExpression)this.getRightOperand().inline(inliner));
    }

    @Override
    public UExpression negate() {
        if (NEGATION.containsKey((Object)this.getKind())) {
            return UBinary.create((Tree.Kind)((Object)NEGATION.get((Object)this.getKind())), this.getLeftOperand(), this.getRightOperand());
        }
        if (DEMORGAN.containsKey((Object)this.getKind())) {
            return UBinary.create((Tree.Kind)((Object)DEMORGAN.get((Object)this.getKind())), this.getLeftOperand().negate(), this.getRightOperand().negate());
        }
        return super.negate();
    }
}

