/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation;

import java.lang.reflect.Method;
import org.mockito.internal.creation.SuspendMethod;
import org.mockito.internal.invocation.MockitoMethod;

public class DelegatingMethod
implements MockitoMethod {
    private final Method method;
    private final Class<?>[] parameterTypes;

    public DelegatingMethod(Method method) {
        assert (method != null) : "Method cannot be null";
        this.method = method;
        this.parameterTypes = SuspendMethod.trimSuspendParameterTypes(method.getParameterTypes());
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return this.method.getExceptionTypes();
    }

    @Override
    public Method getJavaMethod() {
        return this.method;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    @Override
    public boolean isVarArgs() {
        return this.method.isVarArgs();
    }

    @Override
    public boolean isAbstract() {
        return (this.method.getModifiers() & 0x400) != 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DelegatingMethod) {
            DelegatingMethod that = (DelegatingMethod)o;
            return this.method.equals(that.method);
        }
        return this.method.equals(o);
    }

    public int hashCode() {
        return this.method.hashCode();
    }
}

