/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis;

import java.util.HashSet;
import java.util.Set;
import org.jacoco.asm.AnnotationVisitor;
import org.jacoco.asm.Attribute;
import org.jacoco.asm.FieldVisitor;
import org.jacoco.asm.MethodVisitor;
import org.jacoco.asm.tree.MethodNode;
import org.jacoco.core.internal.analysis.ClassCoverageImpl;
import org.jacoco.core.internal.analysis.InstructionsBuilder;
import org.jacoco.core.internal.analysis.MethodAnalyzer;
import org.jacoco.core.internal.analysis.MethodCoverageCalculator;
import org.jacoco.core.internal.analysis.MethodCoverageImpl;
import org.jacoco.core.internal.analysis.StringPool;
import org.jacoco.core.internal.analysis.filter.Filters;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.flow.ClassProbesVisitor;
import org.jacoco.core.internal.flow.MethodProbesVisitor;
import org.jacoco.core.internal.instr.InstrSupport;

public class ClassAnalyzer
extends ClassProbesVisitor
implements IFilterContext {
    private final ClassCoverageImpl coverage;
    private final boolean[] probes;
    private final StringPool stringPool;
    private final Set<String> classAnnotations = new HashSet<String>();
    private final Set<String> classAttributes = new HashSet<String>();
    private String sourceDebugExtension;
    private final IFilter filter;

    public ClassAnalyzer(ClassCoverageImpl coverage, boolean[] probes, StringPool stringPool) {
        this.coverage = coverage;
        this.probes = probes;
        this.stringPool = stringPool;
        this.filter = Filters.all();
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.coverage.setSignature(this.stringPool.get(signature));
        this.coverage.setSuperName(this.stringPool.get(superName));
        this.coverage.setInterfaces(this.stringPool.get(interfaces));
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.classAnnotations.add(desc);
        return super.visitAnnotation(desc, visible);
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.classAttributes.add(attribute.type);
    }

    @Override
    public void visitSource(String source, String debug) {
        this.coverage.setSourceFileName(this.stringPool.get(source));
        this.sourceDebugExtension = debug;
    }

    @Override
    public MethodProbesVisitor visitMethod(int access, final String name, final String desc, final String signature, String[] exceptions) {
        InstrSupport.assertNotInstrumented(name, this.coverage.getName());
        final InstructionsBuilder builder = new InstructionsBuilder(this.probes);
        return new MethodAnalyzer(builder){

            @Override
            public void accept(MethodNode methodNode, MethodVisitor methodVisitor) {
                super.accept(methodNode, methodVisitor);
                ClassAnalyzer.this.addMethodCoverage(ClassAnalyzer.this.stringPool.get(name), ClassAnalyzer.this.stringPool.get(desc), ClassAnalyzer.this.stringPool.get(signature), builder, methodNode);
            }
        };
    }

    private void addMethodCoverage(String name, String desc, String signature, InstructionsBuilder icc, MethodNode methodNode) {
        MethodCoverageCalculator mcc = new MethodCoverageCalculator(icc.getInstructions());
        this.filter.filter(methodNode, this, mcc);
        MethodCoverageImpl mc = new MethodCoverageImpl(name, desc, signature);
        mcc.calculate(mc);
        if (mc.containsCode()) {
            this.coverage.addMethod(mc);
        }
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        InstrSupport.assertNotInstrumented(name, this.coverage.getName());
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public void visitTotalProbeCount(int count) {
    }

    @Override
    public String getClassName() {
        return this.coverage.getName();
    }

    @Override
    public String getSuperClassName() {
        return this.coverage.getSuperName();
    }

    @Override
    public Set<String> getClassAnnotations() {
        return this.classAnnotations;
    }

    @Override
    public Set<String> getClassAttributes() {
        return this.classAttributes;
    }

    @Override
    public String getSourceFileName() {
        return this.coverage.getSourceFileName();
    }

    @Override
    public String getSourceDebugExtension() {
        return this.sourceDebugExtension;
    }
}

