/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.runtime.instrumentation.common.graph;

import com.google.monitoring.runtime.instrumentation.common.annotations.Beta;
import com.google.monitoring.runtime.instrumentation.common.base.Optional;
import com.google.monitoring.runtime.instrumentation.common.base.Preconditions;
import com.google.monitoring.runtime.instrumentation.common.graph.AbstractGraphBuilder;
import com.google.monitoring.runtime.instrumentation.common.graph.ConfigurableMutableGraph;
import com.google.monitoring.runtime.instrumentation.common.graph.ElementOrder;
import com.google.monitoring.runtime.instrumentation.common.graph.Graph;
import com.google.monitoring.runtime.instrumentation.common.graph.Graphs;
import com.google.monitoring.runtime.instrumentation.common.graph.ImmutableGraph;
import com.google.monitoring.runtime.instrumentation.common.graph.MutableGraph;

@Beta
public final class GraphBuilder<N>
extends AbstractGraphBuilder<N> {
    private GraphBuilder(boolean directed) {
        super(directed);
    }

    public static GraphBuilder<Object> directed() {
        return new GraphBuilder<Object>(true);
    }

    public static GraphBuilder<Object> undirected() {
        return new GraphBuilder<Object>(false);
    }

    public static <N> GraphBuilder<N> from(Graph<N> graph) {
        return new GraphBuilder<N>(graph.isDirected()).allowsSelfLoops(graph.allowsSelfLoops()).nodeOrder(graph.nodeOrder());
    }

    public <N1 extends N> ImmutableGraph.Builder<N1> immutable() {
        GraphBuilder<N1> castBuilder = this.cast();
        return new ImmutableGraph.Builder<N1>(castBuilder);
    }

    public GraphBuilder<N> allowsSelfLoops(boolean allowsSelfLoops) {
        this.allowsSelfLoops = allowsSelfLoops;
        return this;
    }

    public GraphBuilder<N> expectedNodeCount(int expectedNodeCount) {
        this.expectedNodeCount = Optional.of(Graphs.checkNonNegative(expectedNodeCount));
        return this;
    }

    public <N1 extends N> GraphBuilder<N1> nodeOrder(ElementOrder<N1> nodeOrder) {
        GraphBuilder<N1> newBuilder = this.cast();
        newBuilder.nodeOrder = Preconditions.checkNotNull(nodeOrder);
        return newBuilder;
    }

    public <N1 extends N> MutableGraph<N1> build() {
        return new ConfigurableMutableGraph(this);
    }

    private <N1 extends N> GraphBuilder<N1> cast() {
        return this;
    }
}

