/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.javacutil;

import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.errorprone.checker.nullness.qual.KeyFor;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.javacutil.AnnotationMirrorSet;
import org.checkerframework.errorprone.javacutil.AnnotationUtils;

public class AnnotationMirrorMap<V>
implements Map<AnnotationMirror, V> {
    private final NavigableMap<@KeyFor(value={"this"}) AnnotationMirror, V> shadowMap = new TreeMap<AnnotationMirror, V>(AnnotationUtils::compareAnnotationMirrors);

    public AnnotationMirrorMap() {
    }

    public AnnotationMirrorMap(Map<AnnotationMirror, ? extends V> copy) {
        this();
        this.putAll(copy);
    }

    @Override
    public int size() {
        return this.shadowMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.shadowMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof AnnotationMirror) {
            return AnnotationUtils.containsSame(this.shadowMap.keySet(), (AnnotationMirror)key);
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.shadowMap.containsValue(value);
    }

    @Override
    @Pure
    public @Nullable V get(Object key) {
        AnnotationMirror keyAnno;
        if (key instanceof AnnotationMirror && (keyAnno = AnnotationUtils.getSame(this.shadowMap.keySet(), (AnnotationMirror)key)) != null) {
            return this.shadowMap.get(keyAnno);
        }
        return null;
    }

    @Override
    public @Nullable V put(AnnotationMirror key, V value) {
        V pre = this.get(key);
        this.remove(key);
        this.shadowMap.put(key, value);
        return pre;
    }

    @Override
    public @Nullable V remove(Object key) {
        AnnotationMirror keyAnno;
        if (key instanceof AnnotationMirror && (keyAnno = AnnotationUtils.getSame(this.shadowMap.keySet(), (AnnotationMirror)key)) != null) {
            return this.shadowMap.remove(keyAnno);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends AnnotationMirror, ? extends V> m4) {
        for (Map.Entry<AnnotationMirror, V> entry : m4.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.shadowMap.clear();
    }

    public AnnotationMirrorSet keySet() {
        return new AnnotationMirrorSet(this.shadowMap.keySet());
    }

    @Override
    public Collection<V> values() {
        return this.shadowMap.values();
    }

    @Override
    public Set<Map.Entry<@KeyFor(value={"this"}) AnnotationMirror, V>> entrySet() {
        return this.shadowMap.entrySet();
    }

    public String toString() {
        return this.shadowMap.toString();
    }

    @Override
    @Pure
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnnotationMirrorMap)) {
            return false;
        }
        AnnotationMirrorMap m4 = (AnnotationMirrorMap)o;
        if (m4.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<AnnotationMirror, V> e : this.entrySet()) {
                AnnotationMirror key = e.getKey();
                V value = e.getValue();
                if (!(value == null ? m4.get(key) != null || !m4.containsKey(key) : !value.equals(m4.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        for (Map.Entry<AnnotationMirror, V> entry : this.entrySet()) {
            result += entry.hashCode();
        }
        return result;
    }
}

