/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.javacutil;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.checkerframework.errorprone.checker.nullness.qual.PolyNull;
import org.checkerframework.errorprone.checker.signedness.qual.PolySigned;
import org.checkerframework.errorprone.javacutil.DeepCopyable;

public class CollectionUtils {
    public static <K, V> Map<K, V> createLRUCache(final int size) {
        return new LinkedHashMap<K, V>(size, 0.75f, true){
            private static final long serialVersionUID = 5261489276168775084L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
                return this.size() > size;
            }
        };
    }

    public static <T, C extends Collection<T>> @PolyNull C cloneElements(@PolyNull C orig) {
        if (orig == null) {
            return null;
        }
        C result = CollectionUtils.clone(orig);
        result.clear();
        for (T elt : orig) {
            result.add(CollectionUtils.clone(elt));
        }
        return result;
    }

    public static <K, V, M extends Map<K, V>> @PolyNull M cloneElements(@PolyNull M orig) {
        return CollectionUtils.cloneElements(orig, true);
    }

    public static <K, V, M extends Map<K, V>> @PolyNull M cloneValues(@PolyNull M orig) {
        return CollectionUtils.cloneElements(orig, false);
    }

    private static <K, V, M extends Map<K, V>> @PolyNull M cloneElements(@PolyNull M orig, boolean cloneKeys) {
        if (orig == null) {
            return null;
        }
        M result = CollectionUtils.clone(orig);
        result.clear();
        for (Map.Entry<K, V> mapEntry : orig.entrySet()) {
            K oldKey = mapEntry.getKey();
            K newKey = cloneKeys ? CollectionUtils.clone(oldKey) : oldKey;
            result.put(newKey, CollectionUtils.clone(mapEntry.getValue()));
        }
        return result;
    }

    public static <T extends DeepCopyable<T>, C extends Collection<T>> @PolyNull C deepCopy(@PolyNull C orig) {
        if (orig == null) {
            return null;
        }
        C result = CollectionUtils.clone(orig);
        result.clear();
        for (DeepCopyable elt : orig) {
            result.add((DeepCopyable)DeepCopyable.deepCopyOrNull(elt));
        }
        return result;
    }

    public static <K extends DeepCopyable<K>, V extends DeepCopyable<V>, M extends Map<K, V>> @PolyNull M deepCopy(@PolyNull M orig) {
        if (orig == null) {
            return null;
        }
        M result = CollectionUtils.clone(orig);
        result.clear();
        for (Map.Entry<K, V> mapEntry : orig.entrySet()) {
            DeepCopyable oldKey = (DeepCopyable)mapEntry.getKey();
            DeepCopyable oldValue = (DeepCopyable)mapEntry.getValue();
            result.put((DeepCopyable)DeepCopyable.deepCopyOrNull(oldKey), (DeepCopyable)DeepCopyable.deepCopyOrNull(oldValue));
        }
        return result;
    }

    public static <K, V extends DeepCopyable<V>, M extends Map<K, V>> @PolyNull M deepCopyValues(@PolyNull M orig) {
        if (orig == null) {
            return null;
        }
        M result = CollectionUtils.clone(orig);
        result.clear();
        for (Map.Entry<K, V> mapEntry : orig.entrySet()) {
            K oldKey = mapEntry.getKey();
            DeepCopyable oldValue = (DeepCopyable)mapEntry.getValue();
            result.put(oldKey, (DeepCopyable)DeepCopyable.deepCopyOrNull(oldValue));
        }
        return result;
    }

    public static <T> @PolyNull @PolySigned T clone(@PolyNull @PolySigned T data) {
        if (data == null) {
            return null;
        }
        try {
            return (T)data.getClass().getMethod("clone", new Class[0]).invoke(data, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new Error(e);
        }
    }
}

