/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.tree;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.tree.Tree;
import com.google.turbine.tree.TurbineModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jspecify.nullness.Nullable;

public class Pretty
implements Tree.Visitor<Void, Void> {
    private final StringBuilder sb = new StringBuilder();
    int indent = 0;
    boolean newLine = false;

    static String pretty(Tree tree) {
        Pretty pretty = new Pretty();
        tree.accept(pretty, null);
        return pretty.sb.toString();
    }

    void printLine() {
        this.append('\n');
        this.newLine = true;
    }

    void printLine(String line) {
        if (!this.newLine) {
            this.append('\n');
        }
        this.append(line).append('\n');
        this.newLine = true;
    }

    @CanIgnoreReturnValue
    Pretty append(char c) {
        if (c == '\n') {
            this.newLine = true;
        } else if (this.newLine) {
            this.sb.append(Strings.repeat((String)" ", (int)(this.indent * 2)));
            this.newLine = false;
        }
        this.sb.append(c);
        return this;
    }

    @CanIgnoreReturnValue
    Pretty append(String s) {
        if (this.newLine) {
            this.sb.append(Strings.repeat((String)" ", (int)(this.indent * 2)));
            this.newLine = false;
        }
        this.sb.append(s);
        return this;
    }

    @Override
    public @Nullable Void visitIdent(Tree.Ident ident, @Nullable Void input) {
        this.sb.append(ident.value());
        return null;
    }

    @Override
    public @Nullable Void visitWildTy(Tree.WildTy wildTy, @Nullable Void input) {
        this.printAnnos(wildTy.annos());
        this.append('?');
        if (wildTy.lower().isPresent()) {
            this.append(" super ");
            wildTy.lower().get().accept(this, null);
        }
        if (wildTy.upper().isPresent()) {
            this.append(" extends ");
            wildTy.upper().get().accept(this, null);
        }
        return null;
    }

    @Override
    public @Nullable Void visitArrTy(Tree.ArrTy arrTy, @Nullable Void input) {
        Tree.ArrTy curr;
        ImmutableList.Builder flat = ImmutableList.builder();
        Tree.Type next = arrTy;
        do {
            curr = next;
            flat.add((Object)curr);
        } while ((next = curr.elem()).kind().equals((Object)Tree.Kind.ARR_TY));
        next.accept(this, null);
        for (Tree.ArrTy dim : flat.build()) {
            if (!dim.annos().isEmpty()) {
                this.append(' ');
                this.printAnnos(dim.annos());
            }
            this.append("[]");
        }
        return null;
    }

    @Override
    public @Nullable Void visitPrimTy(Tree.PrimTy primTy, @Nullable Void input) {
        this.printAnnos(primTy.annos());
        this.append(primTy.tykind().toString());
        return null;
    }

    @Override
    public @Nullable Void visitVoidTy(Tree.VoidTy voidTy, @Nullable Void input) {
        this.append("void");
        return null;
    }

    @Override
    public @Nullable Void visitClassTy(Tree.ClassTy classTy, @Nullable Void input) {
        if (classTy.base().isPresent()) {
            classTy.base().get().accept(this, null);
            this.append('.');
        }
        this.printAnnos(classTy.annos());
        this.append(classTy.name().value());
        if (!classTy.tyargs().isEmpty()) {
            this.append('<');
            boolean first = true;
            for (Tree t : classTy.tyargs()) {
                if (!first) {
                    this.append(", ");
                }
                t.accept(this, null);
                first = false;
            }
            this.append('>');
        }
        return null;
    }

    @Override
    public @Nullable Void visitLiteral(Tree.Literal literal, @Nullable Void input) {
        this.append(literal.value().toString());
        return null;
    }

    @Override
    public @Nullable Void visitParen(Tree.Paren paren, @Nullable Void input) {
        paren.expr().accept(this, null);
        return null;
    }

    @Override
    public @Nullable Void visitTypeCast(Tree.TypeCast typeCast, @Nullable Void input) {
        this.append('(');
        typeCast.ty().accept(this, null);
        this.append(") ");
        typeCast.expr().accept(this, null);
        return null;
    }

    @Override
    public @Nullable Void visitUnary(Tree.Unary unary, @Nullable Void input) {
        switch (unary.op()) {
            case POST_INCR: 
            case POST_DECR: {
                unary.expr().accept(this, null);
                this.append(unary.op().toString());
                break;
            }
            case PRE_INCR: 
            case PRE_DECR: 
            case UNARY_PLUS: 
            case NEG: 
            case NOT: 
            case BITWISE_COMP: {
                this.append(unary.op().toString());
                unary.expr().accept(this, null);
                break;
            }
            default: {
                throw new AssertionError((Object)unary.op().name());
            }
        }
        return null;
    }

    @Override
    public @Nullable Void visitBinary(Tree.Binary binary, @Nullable Void input) {
        this.append('(');
        boolean first = true;
        for (Tree tree : binary.children()) {
            if (!first) {
                this.append(" ").append(binary.op().toString()).append(" ");
            }
            tree.accept(this, null);
            first = false;
        }
        this.append(')');
        return null;
    }

    @Override
    public @Nullable Void visitConstVarName(Tree.ConstVarName constVarName, @Nullable Void input) {
        this.append(Joiner.on((char)'.').join(constVarName.name()));
        return null;
    }

    @Override
    public @Nullable Void visitClassLiteral(Tree.ClassLiteral classLiteral, @Nullable Void input) {
        classLiteral.type().accept(this, input);
        this.append(".class");
        return null;
    }

    @Override
    public @Nullable Void visitAssign(Tree.Assign assign, @Nullable Void input) {
        this.append(assign.name().value()).append(" = ");
        assign.expr().accept(this, null);
        return null;
    }

    @Override
    public @Nullable Void visitConditional(Tree.Conditional conditional, @Nullable Void input) {
        this.append("(");
        conditional.cond().accept(this, null);
        this.append(" ? ");
        conditional.iftrue().accept(this, null);
        this.append(" : ");
        conditional.iffalse().accept(this, null);
        this.append(")");
        return null;
    }

    @Override
    public @Nullable Void visitArrayInit(Tree.ArrayInit arrayInit, @Nullable Void input) {
        this.append('{');
        boolean first = true;
        for (Tree.Expression e : arrayInit.exprs()) {
            if (!first) {
                this.append(", ");
            }
            e.accept(this, null);
            first = false;
        }
        this.append('}');
        return null;
    }

    @Override
    public @Nullable Void visitCompUnit(Tree.CompUnit compUnit, @Nullable Void input) {
        if (compUnit.pkg().isPresent()) {
            compUnit.pkg().get().accept(this, null);
            this.printLine();
        }
        for (Tree.ImportDecl i : compUnit.imports()) {
            i.accept(this, null);
        }
        if (compUnit.mod().isPresent()) {
            this.printLine();
            compUnit.mod().get().accept(this, null);
        }
        for (Tree.TyDecl decl : compUnit.decls()) {
            this.printLine();
            decl.accept(this, null);
        }
        return null;
    }

    @Override
    public @Nullable Void visitImportDecl(Tree.ImportDecl importDecl, @Nullable Void input) {
        this.append("import ");
        if (importDecl.stat()) {
            this.append("static ");
        }
        this.append(Joiner.on((char)'.').join(importDecl.type()));
        if (importDecl.wild()) {
            this.append(".*");
        }
        this.append(";").append('\n');
        return null;
    }

    @Override
    public @Nullable Void visitVarDecl(Tree.VarDecl varDecl, @Nullable Void input) {
        this.printVarDecl(varDecl);
        this.append(';');
        return null;
    }

    private void printVarDecl(Tree.VarDecl varDecl) {
        this.printAnnos(varDecl.annos());
        this.printModifiers(varDecl.mods());
        varDecl.ty().accept(this, null);
        this.append(' ').append(varDecl.name().value());
        if (varDecl.init().isPresent()) {
            this.append(" = ");
            varDecl.init().get().accept(this, null);
        }
    }

    private void printAnnos(ImmutableList<Tree.Anno> annos) {
        for (Tree.Anno anno : annos) {
            anno.accept(this, null);
            this.append(' ');
        }
    }

    @Override
    public @Nullable Void visitMethDecl(Tree.MethDecl methDecl, @Nullable Void input) {
        for (Tree.Anno anno : methDecl.annos()) {
            anno.accept(this, null);
            this.printLine();
        }
        this.printModifiers(methDecl.mods());
        if (!methDecl.typarams().isEmpty()) {
            this.append('<');
            boolean first = true;
            for (Tree.TyParam t : methDecl.typarams()) {
                if (!first) {
                    this.append(", ");
                }
                t.accept(this, null);
                first = false;
            }
            this.append('>');
            this.append(' ');
        }
        if (methDecl.ret().isPresent()) {
            methDecl.ret().get().accept(this, null);
            this.append(' ');
        }
        this.append(methDecl.name().value());
        this.append('(');
        boolean first = true;
        for (Tree.VarDecl param : methDecl.params()) {
            if (!first) {
                this.append(", ");
            }
            this.printVarDecl(param);
            first = false;
        }
        this.append(')');
        if (!methDecl.exntys().isEmpty()) {
            this.append(" throws ");
            first = true;
            for (Tree.Type e : methDecl.exntys()) {
                if (!first) {
                    this.append(", ");
                }
                e.accept(this, null);
                first = false;
            }
        }
        if (methDecl.defaultValue().isPresent()) {
            this.append(" default ");
            methDecl.defaultValue().get().accept(this, null);
            this.append(";");
        } else if (methDecl.mods().contains((Object)TurbineModifier.ABSTRACT) || methDecl.mods().contains((Object)TurbineModifier.NATIVE)) {
            this.append(";");
        } else {
            this.append(" {}");
        }
        return null;
    }

    @Override
    public @Nullable Void visitAnno(Tree.Anno anno, @Nullable Void input) {
        this.append('@');
        this.append(Joiner.on((char)'.').join(anno.name()));
        if (!anno.args().isEmpty()) {
            this.append('(');
            boolean first = true;
            for (Tree.Expression e : anno.args()) {
                if (!first) {
                    this.append(", ");
                }
                e.accept(this, null);
                first = false;
            }
            this.append(')');
        }
        return null;
    }

    @Override
    public @Nullable Void visitTyDecl(Tree.TyDecl tyDecl, @Nullable Void input) {
        for (Tree.Anno anno : tyDecl.annos()) {
            anno.accept(this, null);
            this.printLine();
        }
        this.printModifiers(tyDecl.mods());
        switch (tyDecl.tykind()) {
            case CLASS: {
                this.append("class");
                break;
            }
            case INTERFACE: {
                this.append("interface");
                break;
            }
            case ENUM: {
                this.append("enum");
                break;
            }
            case ANNOTATION: {
                this.append("@interface");
                break;
            }
            case RECORD: {
                this.append("record");
            }
        }
        this.append(' ').append(tyDecl.name().value());
        if (!tyDecl.typarams().isEmpty()) {
            this.append('<');
            boolean first = true;
            for (Object t : tyDecl.typarams()) {
                if (!first) {
                    this.append(", ");
                }
                ((Tree.TyParam)t).accept(this, null);
                first = false;
            }
            this.append('>');
        }
        if (tyDecl.tykind().equals((Object)TurbineTyKind.RECORD)) {
            this.append("(");
            boolean first = true;
            for (Tree.VarDecl c : tyDecl.components()) {
                if (!first) {
                    this.append(", ");
                }
                this.printVarDecl(c);
                first = false;
            }
            this.append(")");
        }
        if (tyDecl.xtnds().isPresent()) {
            this.append(" extends ");
            tyDecl.xtnds().get().accept(this, null);
        }
        if (!tyDecl.impls().isEmpty()) {
            this.append(" implements ");
            boolean first = true;
            for (Object t : tyDecl.impls()) {
                if (!first) {
                    this.append(", ");
                }
                ((Tree.ClassTy)t).accept(this, null);
                first = false;
            }
        }
        if (!tyDecl.permits().isEmpty()) {
            this.append(" permits ");
            boolean first = true;
            for (Object t : tyDecl.permits()) {
                if (!first) {
                    this.append(", ");
                }
                ((Tree.ClassTy)t).accept(this, null);
                first = false;
            }
        }
        this.append(" {").append('\n');
        ++this.indent;
        switch (tyDecl.tykind()) {
            case ENUM: {
                ArrayList<Object> nonConsts = new ArrayList<Object>();
                for (Object t : tyDecl.members()) {
                    Tree.VarDecl decl;
                    if (t instanceof Tree.VarDecl && (decl = (Tree.VarDecl)t).mods().contains((Object)TurbineModifier.ACC_ENUM)) {
                        this.append(decl.name().value()).append(',').append('\n');
                        continue;
                    }
                    nonConsts.add(t);
                }
                this.printLine(";");
                boolean first = true;
                for (Tree t : nonConsts) {
                    if (!first) {
                        this.printLine();
                    }
                    t.accept(this, null);
                    first = false;
                }
                break;
            }
            default: {
                boolean first = true;
                for (Object t : tyDecl.members()) {
                    if (!first) {
                        this.printLine();
                    }
                    ((Tree)t).accept(this, null);
                    first = false;
                }
            }
        }
        --this.indent;
        this.printLine("}");
        return null;
    }

    private void printModifiers(ImmutableSet<TurbineModifier> mods) {
        ArrayList<TurbineModifier> modifiers = new ArrayList<TurbineModifier>((Collection<TurbineModifier>)mods);
        Collections.sort(modifiers);
        for (TurbineModifier mod : modifiers) {
            switch (mod) {
                case PRIVATE: 
                case PROTECTED: 
                case PUBLIC: 
                case ABSTRACT: 
                case FINAL: 
                case STATIC: 
                case VOLATILE: 
                case SYNCHRONIZED: 
                case STRICTFP: 
                case NATIVE: 
                case TRANSIENT: 
                case DEFAULT: 
                case TRANSITIVE: 
                case SEALED: 
                case NON_SEALED: {
                    this.append(mod.toString()).append(' ');
                    break;
                }
            }
        }
    }

    @Override
    public @Nullable Void visitTyParam(Tree.TyParam tyParam, @Nullable Void input) {
        this.printAnnos(tyParam.annos());
        this.append(tyParam.name().value());
        if (!tyParam.bounds().isEmpty()) {
            this.append(" extends ");
            boolean first = true;
            for (Tree bound : tyParam.bounds()) {
                if (!first) {
                    this.append(" & ");
                }
                bound.accept(this, null);
                first = false;
            }
        }
        return null;
    }

    @Override
    public @Nullable Void visitPkgDecl(Tree.PkgDecl pkgDecl, @Nullable Void input) {
        for (Tree.Anno anno : pkgDecl.annos()) {
            anno.accept(this, null);
            this.printLine();
        }
        this.append("package ").append(Joiner.on((char)'.').join(pkgDecl.name())).append(';');
        return null;
    }

    @Override
    public @Nullable Void visitModDecl(Tree.ModDecl modDecl, @Nullable Void input) {
        for (Tree.Anno anno : modDecl.annos()) {
            anno.accept(this, null);
            this.printLine();
        }
        if (modDecl.open()) {
            this.append("open ");
        }
        this.append("module ").append(modDecl.moduleName()).append(" {");
        ++this.indent;
        this.append('\n');
        for (Tree.ModDirective directive : modDecl.directives()) {
            directive.accept(this, null);
        }
        --this.indent;
        this.append("}\n");
        return null;
    }

    @Override
    public @Nullable Void visitModRequires(Tree.ModRequires modRequires, @Nullable Void input) {
        this.append("requires ");
        this.printModifiers(modRequires.mods());
        this.append(modRequires.moduleName());
        this.append(";");
        this.append('\n');
        return null;
    }

    @Override
    public @Nullable Void visitModExports(Tree.ModExports modExports, @Nullable Void input) {
        this.append("exports ");
        this.append(modExports.packageName().replace('/', '.'));
        if (!modExports.moduleNames().isEmpty()) {
            this.append(" to").append('\n');
            this.indent += 2;
            boolean first = true;
            for (String moduleName : modExports.moduleNames()) {
                if (!first) {
                    this.append(',').append('\n');
                }
                this.append(moduleName);
                first = false;
            }
            this.indent -= 2;
        }
        this.append(";");
        this.append('\n');
        return null;
    }

    @Override
    public @Nullable Void visitModOpens(Tree.ModOpens modOpens, @Nullable Void input) {
        this.append("opens ");
        this.append(modOpens.packageName().replace('/', '.'));
        if (!modOpens.moduleNames().isEmpty()) {
            this.append(" to").append('\n');
            this.indent += 2;
            boolean first = true;
            for (String moduleName : modOpens.moduleNames()) {
                if (!first) {
                    this.append(',').append('\n');
                }
                this.append(moduleName);
                first = false;
            }
            this.indent -= 2;
        }
        this.append(";");
        this.append('\n');
        return null;
    }

    @Override
    public @Nullable Void visitModUses(Tree.ModUses modUses, @Nullable Void input) {
        this.append("uses ");
        this.append(Joiner.on((char)'.').join(modUses.typeName()));
        this.append(";");
        this.append('\n');
        return null;
    }

    @Override
    public @Nullable Void visitModProvides(Tree.ModProvides modProvides, @Nullable Void input) {
        this.append("provides ");
        this.append(Joiner.on((char)'.').join(modProvides.typeName()));
        if (!modProvides.implNames().isEmpty()) {
            this.append(" with").append('\n');
            this.indent += 2;
            boolean first = true;
            for (ImmutableList implName : modProvides.implNames()) {
                if (!first) {
                    this.append(',').append('\n');
                }
                this.append(Joiner.on((char)'.').join((Iterable)implName));
                first = false;
            }
            this.indent -= 2;
        }
        this.append(";");
        this.append('\n');
        return null;
    }
}

