/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Preconditions;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import javax.lang.model.type.TypeMirror;

@BugPattern(summary="A conditional expression with numeric operands of differing types will perform binary numeric promotion of the operands; when these operands are of reference types, the expression's result may not be of the expected type.", severity=BugPattern.SeverityLevel.ERROR)
public class ConditionalExpressionNumericPromotion
extends BugChecker
implements BugChecker.ConditionalExpressionTreeMatcher {
    private static final Supplier<Type> JAVA_LANG_NUMBER = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("java.lang.Number"));

    public Description matchConditionalExpression(ConditionalExpressionTree conditionalExpression, VisitorState state) {
        Type expressionType = (Type)Preconditions.checkNotNull((Object)ASTHelpers.getType((Tree)conditionalExpression));
        if (!expressionType.isPrimitive()) {
            return Description.NO_MATCH;
        }
        ExpressionTree trueExpression = conditionalExpression.getTrueExpression();
        ExpressionTree falseExpression = conditionalExpression.getFalseExpression();
        Type trueType = (Type)Preconditions.checkNotNull((Object)ASTHelpers.getType((Tree)trueExpression));
        Type falseType = (Type)Preconditions.checkNotNull((Object)ASTHelpers.getType((Tree)falseExpression));
        if (trueType.isPrimitive() || falseType.isPrimitive()) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isSameType((Type)trueType, (Type)falseType, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        ASTHelpers.TargetType targetType = ASTHelpers.targetType((VisitorState)state);
        if (targetType == null) {
            return Description.NO_MATCH;
        }
        if (targetType.type().isPrimitive()) {
            return Description.NO_MATCH;
        }
        Type numberType = (Type)JAVA_LANG_NUMBER.get(state);
        if (ASTHelpers.isSubtype((Type)targetType.type(), (Type)numberType, (VisitorState)state) && !ASTHelpers.isSameType((Type)targetType.type(), (Type)numberType, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder builder = SuggestedFix.builder();
        String numberName = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)builder, (TypeMirror)numberType);
        String prefix = "((" + numberName + ") ";
        builder.prefixWith((Tree)trueExpression, prefix).postfixWith((Tree)trueExpression, ")");
        builder.prefixWith((Tree)falseExpression, prefix).postfixWith((Tree)falseExpression, ")");
        return this.describeMatch(conditionalExpression, (Fix)builder.build());
    }
}

