/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;
import java.util.regex.Pattern;

final class Matchers {
    static final Matcher<NewClassTree> AUTOVALUE_CONSTRUCTOR = new Matcher<NewClassTree>(){

        public boolean matches(NewClassTree tree, VisitorState state) {
            Symbol.MethodSymbol sym = ASTHelpers.getSymbol((NewClassTree)tree);
            Symbol.ClassSymbol owner = (Symbol.ClassSymbol)sym.owner;
            if (owner == null) {
                return false;
            }
            Type superType = owner.getSuperclass();
            if (superType == null) {
                return false;
            }
            Symbol.TypeSymbol superSymbol = superType.tsym;
            if (superSymbol == null) {
                return false;
            }
            return ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)superSymbol, (String)"AutoValue");
        }
    };
    private static final Matcher<MethodInvocationTree> ARGUMENT_EXTENDS_TRHOWABLE = com.google.errorprone.matchers.Matchers.hasArguments((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)com.google.errorprone.matchers.Matchers.isSubtypeOf(Throwable.class));
    private static final Matcher<MethodInvocationTree> METHOD_ANNOTATED_WITH_BEFORETEMPLATE = com.google.errorprone.matchers.Matchers.enclosingMethod((Matcher)com.google.errorprone.matchers.Matchers.hasAnnotation((String)"com.google.errorprone.refaster.annotation.BeforeTemplate"));
    private static final Matcher<MethodInvocationTree> TWO_PARAMETER_ASSERT = new Matcher<MethodInvocationTree>(){

        public boolean matches(MethodInvocationTree tree, VisitorState state) {
            List parameters = ASTHelpers.getSymbol((MethodInvocationTree)tree).getParameters();
            if (parameters.size() != 2) {
                return false;
            }
            return ASTHelpers.isSameType((Type)((Symbol.VarSymbol)parameters.get(0)).asType(), (Type)((Symbol.VarSymbol)parameters.get(1)).asType(), (VisitorState)state);
        }
    };
    private static final Matcher<MethodInvocationTree> THREE_PARAMETER_ASSERT = new Matcher<MethodInvocationTree>(){

        public boolean matches(MethodInvocationTree tree, VisitorState state) {
            List parameters = ASTHelpers.getSymbol((MethodInvocationTree)tree).getParameters();
            if (parameters.size() != 3) {
                return false;
            }
            return ASTHelpers.isSameType((Type)((Symbol.VarSymbol)parameters.get(0)).asType(), (Type)state.getSymtab().stringType, (VisitorState)state) && ASTHelpers.isSameType((Type)((Symbol.VarSymbol)parameters.get(1)).asType(), (Type)((Symbol.VarSymbol)parameters.get(2)).asType(), (VisitorState)state);
        }
    };
    static final Matcher<MethodInvocationTree> ASSERT_METHOD = com.google.errorprone.matchers.Matchers.allOf((Matcher[])new Matcher[]{com.google.errorprone.matchers.Matchers.staticMethod().onClassAny(new String[]{"org.junit.Assert", "junit.framework.TestCase", "junit.framework.Assert", "ErrorProneTest"}).withNameMatching(Pattern.compile("assert.*")), com.google.errorprone.matchers.Matchers.anyOf((Matcher[])new Matcher[]{TWO_PARAMETER_ASSERT, THREE_PARAMETER_ASSERT}), com.google.errorprone.matchers.Matchers.not(ARGUMENT_EXTENDS_TRHOWABLE), com.google.errorprone.matchers.Matchers.not(METHOD_ANNOTATED_WITH_BEFORETEMPLATE)});

    private Matchers() {
    }
}

