/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.alias.DefaultCollectionLookup;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.InstanceResolver;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class ReflectionConverter
implements Converter {
    private ClassMapper classMapper;
    private String classAttributeIdentifier;
    private String definedInAttributeIdentifier = "defined-in";
    private ReflectionProvider reflectionProvider;
    private DefaultCollectionLookup defaultCollectionLookup;
    private InstanceResolver instanceResolver;

    public ReflectionConverter(ClassMapper classMapper, String string, String string2, ReflectionProvider reflectionProvider, DefaultCollectionLookup defaultCollectionLookup) {
        this.classMapper = classMapper;
        this.classAttributeIdentifier = string;
        this.definedInAttributeIdentifier = string2;
        this.reflectionProvider = reflectionProvider;
        this.defaultCollectionLookup = defaultCollectionLookup;
        this.instanceResolver = new InstanceResolver();
    }

    public boolean canConvert(Class clazz) {
        return true;
    }

    public void marshal(Object object, final HierarchicalStreamWriter hierarchicalStreamWriter, final MarshallingContext marshallingContext) {
        final HashSet hashSet = new HashSet();
        final String string = this.defaultCollectionLookup.getDefaultCollectionField(object.getClass());
        this.reflectionProvider.visitSerializableFields(object, new ReflectionProvider.Visitor(){

            public void visit(String string2, Class clazz, Class clazz2, Object object) {
                if (object != null) {
                    if (string != null && string.equals(string2)) {
                        marshallingContext.convertAnother(object);
                    } else {
                        hierarchicalStreamWriter.startNode(ReflectionConverter.this.classMapper.mapNameToXML(string2));
                        Class<?> clazz3 = object.getClass();
                        Class clazz4 = ReflectionConverter.this.classMapper.lookupDefaultType(clazz);
                        if (!clazz3.equals(clazz4)) {
                            hierarchicalStreamWriter.addAttribute(ReflectionConverter.this.classAttributeIdentifier, ReflectionConverter.this.classMapper.lookupName(clazz3));
                        }
                        if (hashSet.contains(string2)) {
                            hierarchicalStreamWriter.addAttribute(ReflectionConverter.this.definedInAttributeIdentifier, ReflectionConverter.this.classMapper.lookupName(clazz2));
                        }
                        marshallingContext.convertAnother(object);
                        hierarchicalStreamWriter.endNode();
                        hashSet.add(string2);
                    }
                }
            }
        });
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        Object object = unmarshallingContext.currentObject();
        if (object == null) {
            object = this.reflectionProvider.newInstance(unmarshallingContext.getRequiredType());
        }
        Collection collection = this.getDefaultCollection(object);
        HashSet<String> hashSet = new HashSet<String>();
        while (hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            String string = this.classMapper.mapNameFromXML(hierarchicalStreamReader.getNodeName());
            String string2 = hierarchicalStreamReader.getAttribute(this.definedInAttributeIdentifier);
            Class clazz = string2 == null ? null : this.classMapper.lookupType(string2);
            boolean bl = this.reflectionProvider.fieldDefinedInClass(string, object.getClass());
            String string3 = hierarchicalStreamReader.getAttribute(this.classAttributeIdentifier);
            Class clazz2 = string3 != null ? this.classMapper.lookupType(string3) : (!bl ? this.classMapper.lookupType(hierarchicalStreamReader.getNodeName()) : this.classMapper.lookupDefaultType(this.reflectionProvider.getFieldType(object, string, clazz)));
            Object object2 = unmarshallingContext.convertAnother(object, clazz2);
            if (bl) {
                this.reflectionProvider.writeField(object, string, object2, clazz);
                String string4 = string;
                if (clazz != null) {
                    string4 = string4 + " [" + clazz.getName() + "]";
                }
                if (hashSet.contains(string4)) {
                    throw new DuplicateFieldException(string4);
                }
                hashSet.add(string4);
            } else if (collection != null) {
                collection.add(object2);
            }
            hierarchicalStreamReader.moveUp();
        }
        return this.instanceResolver.resolve(object);
    }

    private Collection getDefaultCollection(Object object) {
        String string = this.defaultCollectionLookup.getDefaultCollectionField(object.getClass());
        if (string != null) {
            ArrayList arrayList = new ArrayList();
            this.reflectionProvider.writeField(object, string, arrayList, null);
            return arrayList;
        }
        return null;
    }

    public static class DuplicateFieldException
    extends ConversionException {
        public DuplicateFieldException(String string) {
            super(string);
        }
    }
}

