/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

public final class StringStack {
    private String[] stack;
    private int pointer;

    public StringStack(int n) {
        this.stack = new String[n];
    }

    public void push(String string) {
        if (this.pointer + 1 >= this.stack.length) {
            this.resizeStack(this.stack.length * 2);
        }
        this.stack[this.pointer++] = string;
    }

    public void popSilently() {
        --this.pointer;
    }

    public String pop() {
        return this.stack[--this.pointer];
    }

    public String peek() {
        return this.pointer == 0 ? null : this.stack[this.pointer - 1];
    }

    public int size() {
        return this.pointer;
    }

    public String get(int n) {
        return this.stack[n];
    }

    private void resizeStack(int n) {
        String[] stringArray = new String[n];
        System.arraycopy(this.stack, 0, stringArray, 0, Math.min(this.stack.length, n));
        this.stack = stringArray;
    }
}

