/*
 * Decompiled with CFR 0.152.
 */
package groovy.swing;

import groovy.lang.Closure;
import groovy.model.DefaultTableModel;
import groovy.model.ValueHolder;
import groovy.model.ValueModel;
import groovy.swing.impl.ComponentFacade;
import groovy.swing.impl.ContainerFacade;
import groovy.swing.impl.DefaultAction;
import groovy.swing.impl.Factory;
import groovy.swing.impl.Startable;
import groovy.swing.impl.TableLayout;
import groovy.swing.impl.TableLayoutCell;
import groovy.swing.impl.TableLayoutRow;
import groovy.util.BuilderSupport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.codehaus.groovy.runtime.InvokerHelper;

public class SwingBuilder
extends BuilderSupport {
    private Logger log = Logger.getLogger(this.getClass().getName());
    private Map factories = new HashMap();
    private Object constraints;
    static /* synthetic */ Class class$java$lang$Object;

    public SwingBuilder() {
        this.registerWidgets();
    }

    protected void setParent(Object parent, Object child) {
        if (child instanceof Action) {
            Action action = (Action)child;
            InvokerHelper.setProperty(parent, "action", action);
            Object keyStroke = action.getValue("KeyStroke");
            if (parent instanceof JComponent) {
                JComponent component = (JComponent)parent;
                KeyStroke stroke = null;
                if (keyStroke instanceof String) {
                    stroke = KeyStroke.getKeyStroke((String)keyStroke);
                } else if (keyStroke instanceof KeyStroke) {
                    stroke = (KeyStroke)keyStroke;
                }
                if (stroke != null) {
                    String key = action.toString();
                    component.getInputMap().put(stroke, key);
                    component.getActionMap().put(key, action);
                }
            }
        } else if (child instanceof LayoutManager) {
            if (parent instanceof RootPaneContainer) {
                RootPaneContainer rpc = (RootPaneContainer)parent;
                parent = rpc.getContentPane();
            }
            InvokerHelper.setProperty(parent, "layout", child);
        } else if (parent instanceof JTable && child instanceof TableColumn) {
            JTable table = (JTable)parent;
            TableColumn column = (TableColumn)child;
            table.addColumn(column);
        } else {
            Object facade;
            Component component = null;
            if (child instanceof Component) {
                component = (Component)child;
            } else if (child instanceof ComponentFacade) {
                facade = (ComponentFacade)child;
                component = facade.getComponent();
            }
            if (component != null) {
                if (parent instanceof JFrame && component instanceof JMenuBar) {
                    JFrame frame = (JFrame)parent;
                    frame.setJMenuBar((JMenuBar)component);
                } else if (parent instanceof RootPaneContainer) {
                    RootPaneContainer rpc = (RootPaneContainer)parent;
                    rpc.getContentPane().add(component);
                } else if (parent instanceof JScrollPane) {
                    JScrollPane scrollPane = (JScrollPane)parent;
                    scrollPane.setViewportView(component);
                } else if (parent instanceof JSplitPane) {
                    JSplitPane splitPane = (JSplitPane)parent;
                    if (splitPane.getOrientation() == 1) {
                        if (splitPane.getTopComponent() == null) {
                            splitPane.setTopComponent(component);
                        } else {
                            splitPane.setBottomComponent(component);
                        }
                    } else if (splitPane.getLeftComponent() == null) {
                        splitPane.setLeftComponent(component);
                    } else {
                        splitPane.setRightComponent(component);
                    }
                } else if (parent instanceof JMenuBar && component instanceof JMenu) {
                    JMenuBar menuBar = (JMenuBar)parent;
                    menuBar.add((JMenu)component);
                } else if (parent instanceof Container) {
                    Container container = (Container)parent;
                    if (this.constraints != null) {
                        container.add(component, this.constraints);
                    } else {
                        container.add(component);
                    }
                } else if (parent instanceof ContainerFacade) {
                    facade = (ContainerFacade)parent;
                    facade.addComponent(component);
                }
            }
        }
    }

    protected void nodeCompleted(Object parent, Object node) {
        if (node instanceof TableModel && parent instanceof JTable) {
            JTable table = (JTable)parent;
            TableModel model = (TableModel)node;
            table.setModel(model);
        }
        if (node instanceof Startable) {
            Startable startable = (Startable)node;
            startable.start();
        }
    }

    protected Object createNode(Object name) {
        return this.createNode(name, Collections.EMPTY_MAP);
    }

    protected Object createNode(Object name, Object value) {
        Object widget = this.createNode(name);
        if (widget != null && value instanceof String) {
            InvokerHelper.invokeMethod(widget, "setText", value);
        }
        return widget;
    }

    /*
     * Unable to fully structure code
     */
    protected Object createNode(Object name, Map attributes) {
        block10: {
            this.constraints = attributes.remove("constraints");
            widget = null;
            factory = (Factory)this.factories.get(name);
            if (factory != null) {
                try {
                    widget = factory.newInstance(attributes);
                    if (widget == null) {
                        this.log.log(Level.WARNING, "Factory for name: " + name + " returned null");
                    }
                    if (!this.log.isLoggable(Level.FINE)) ** GOTO lbl16
                    this.log.fine("For name: " + name + " created widget: " + widget);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create component for" + name + " reason: " + e, e);
                }
            } else {
                this.log.log(Level.WARNING, "Could not find match for name: " + name);
            }
lbl16:
            // 4 sources

            if (widget == null) break block10;
            if (widget instanceof Action) {
                action = (Action)widget;
                closure = (Closure)attributes.remove("closure");
                if (closure != null && action instanceof DefaultAction) {
                    defaultAction = (DefaultAction)action;
                    defaultAction.setClosure(closure);
                }
                iter = attributes.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    actionName = (String)entry.getKey();
                    actionName = this.capitalize(actionName);
                    value = entry.getValue();
                    action.putValue(actionName, value);
                }
            } else {
                iter = attributes.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    property = entry.getKey().toString();
                    value = entry.getValue();
                    InvokerHelper.setProperty(widget, property, value);
                }
            }
        }
        return widget;
    }

    protected String capitalize(String text) {
        char ch = text.charAt(0);
        if (Character.isUpperCase(ch)) {
            return text;
        }
        StringBuffer buffer = new StringBuffer(text.length());
        buffer.append(Character.toUpperCase(ch));
        buffer.append(text.substring(1));
        return buffer.toString();
    }

    protected void registerWidgets() {
        this.registerBeanFactory("action", DefaultAction.class);
        this.registerBeanFactory("button", JButton.class);
        this.registerBeanFactory("buttonGroup", ButtonGroup.class);
        this.registerBeanFactory("checkBox", JCheckBox.class);
        this.registerBeanFactory("checkBoxMenuItem", JCheckBoxMenuItem.class);
        this.registerFactory("comboBox", new Factory(){

            public Object newInstance(Map properties) throws InstantiationException, InstantiationException, IllegalAccessException {
                return SwingBuilder.this.createComboBox(properties);
            }
        });
        this.registerBeanFactory("desktopPane", JDesktopPane.class);
        this.registerFactory("dialog", new Factory(){

            public Object newInstance(Map properties) throws InstantiationException, InstantiationException, IllegalAccessException {
                return SwingBuilder.this.createDialog(properties);
            }
        });
        this.registerBeanFactory("editorPane", JEditorPane.class);
        this.registerBeanFactory("fileChooser", JFileChooser.class);
        this.registerBeanFactory("frame", JFrame.class);
        this.registerBeanFactory("internalFrame", JInternalFrame.class);
        this.registerBeanFactory("label", JLabel.class);
        this.registerBeanFactory("list", JList.class);
        this.registerFactory("map", new Factory(){

            public Object newInstance(Map properties) throws InstantiationException, InstantiationException, IllegalAccessException {
                return properties;
            }
        });
        this.registerBeanFactory("menu", JMenu.class);
        this.registerBeanFactory("menuBar", JMenuBar.class);
        this.registerBeanFactory("menuItem", JMenuItem.class);
        this.registerBeanFactory("panel", JPanel.class);
        this.registerBeanFactory("passwordField", JPasswordField.class);
        this.registerBeanFactory("popupMenu", JPopupMenu.class);
        this.registerBeanFactory("progressBar", JProgressBar.class);
        this.registerBeanFactory("radioButton", JRadioButton.class);
        this.registerBeanFactory("radioButtonMenuItem", JRadioButtonMenuItem.class);
        this.registerBeanFactory("optionPane", JOptionPane.class);
        this.registerBeanFactory("scrollPane", JScrollPane.class);
        this.registerBeanFactory("separator", JSeparator.class);
        this.registerFactory("splitPane", new Factory(){

            public Object newInstance(Map properties) {
                JSplitPane answer = new JSplitPane();
                answer.setLeftComponent(null);
                answer.setRightComponent(null);
                answer.setTopComponent(null);
                answer.setBottomComponent(null);
                return answer;
            }
        });
        this.registerFactory("hbox", new Factory(){

            public Object newInstance(Map properties) {
                return Box.createHorizontalBox();
            }
        });
        this.registerFactory("vbox", new Factory(){

            public Object newInstance(Map properties) {
                return Box.createVerticalBox();
            }
        });
        this.registerBeanFactory("tabbedPane", JTabbedPane.class);
        this.registerBeanFactory("table", JTable.class);
        this.registerBeanFactory("textArea", JTextArea.class);
        this.registerBeanFactory("textPane", JTextPane.class);
        this.registerBeanFactory("textField", JTextField.class);
        this.registerBeanFactory("toggleButton", JToggleButton.class);
        this.registerBeanFactory("tree", JTree.class);
        this.registerBeanFactory("toolBar", JToolBar.class);
        this.registerFactory("tableModel", new Factory(){

            public Object newInstance(Map properties) {
                ValueModel model = (ValueModel)properties.remove("model");
                if (model == null) {
                    Object list = properties.remove("list");
                    if (list == null) {
                        list = new ArrayList();
                    }
                    model = new ValueHolder(list);
                }
                return new DefaultTableModel(model);
            }
        });
        this.registerFactory("propertyColumn", new Factory(){

            public Object newInstance(Map properties) {
                Object current = SwingBuilder.this.getCurrent();
                if (current instanceof DefaultTableModel) {
                    String property;
                    DefaultTableModel model = (DefaultTableModel)current;
                    Object header = properties.remove("header");
                    if (header == null) {
                        header = "";
                    }
                    if ((property = (String)properties.remove("propertyName")) == null) {
                        throw new IllegalArgumentException("Must specify a property for a propertyColumn");
                    }
                    Class type = (Class)properties.remove("type");
                    if (type == null) {
                        type = class$java$lang$Object == null ? (class$java$lang$Object = SwingBuilder.class$("java.lang.Object")) : class$java$lang$Object;
                    }
                    return model.addPropertyColumn(header, property, type);
                }
                throw new RuntimeException("propertyColumn must be a child of a tableModel");
            }
        });
        this.registerFactory("closureColumn", new Factory(){

            public Object newInstance(Map properties) {
                Object current = SwingBuilder.this.getCurrent();
                if (current instanceof DefaultTableModel) {
                    Closure readClosure;
                    DefaultTableModel model = (DefaultTableModel)current;
                    Object header = properties.remove("header");
                    if (header == null) {
                        header = "";
                    }
                    if ((readClosure = (Closure)properties.remove("read")) == null) {
                        throw new IllegalArgumentException("Must specify 'read' Closure property for a closureColumn");
                    }
                    Closure writeClosure = (Closure)properties.remove("write");
                    Class type = (Class)properties.remove("type");
                    if (type == null) {
                        type = class$java$lang$Object == null ? (class$java$lang$Object = SwingBuilder.class$("java.lang.Object")) : class$java$lang$Object;
                    }
                    return model.addClosureColumn(header, readClosure, writeClosure, type);
                }
                throw new RuntimeException("propertyColumn must be a child of a tableModel");
            }
        });
        this.registerBeanFactory("tableLayout", TableLayout.class);
        this.registerFactory("tr", new Factory(){

            public Object newInstance(Map properties) {
                Object parent = SwingBuilder.this.getCurrent();
                if (parent instanceof TableLayout) {
                    return new TableLayoutRow((TableLayout)parent);
                }
                throw new RuntimeException("'tr' must be within a 'tableLayout'");
            }
        });
        this.registerFactory("td", new Factory(){

            public Object newInstance(Map properties) {
                Object parent = SwingBuilder.this.getCurrent();
                if (parent instanceof TableLayoutRow) {
                    return new TableLayoutCell((TableLayoutRow)parent);
                }
                throw new RuntimeException("'td' must be within a 'tr'");
            }
        });
    }

    protected Object createDialog(Map properties) {
        Object owner = properties.remove("owner");
        if (owner instanceof Frame) {
            return new JDialog((Frame)owner);
        }
        if (owner instanceof Dialog) {
            return new JDialog((Dialog)owner);
        }
        return new JDialog();
    }

    protected Object createComboBox(Map properties) {
        Object items = properties.remove("items");
        if (items instanceof Vector) {
            return new JComboBox((Vector)items);
        }
        if (items instanceof List) {
            List list = (List)items;
            return new JComboBox<Object>(list.toArray());
        }
        if (items instanceof Object[]) {
            return new JComboBox<Object>((Object[])items);
        }
        return new JComboBox();
    }

    protected void registerBeanFactory(String name, final Class beanClass) {
        this.registerFactory(name, new Factory(){

            public Object newInstance(Map properties) throws InstantiationException, IllegalAccessException {
                return beanClass.newInstance();
            }
        });
    }

    protected void registerFactory(String name, Factory factory) {
        this.factories.put(name, factory);
    }
}

