/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import org.codehaus.groovy.ast.MetadataNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.stmt.Statement;
import org.objectweb.asm.Constants;

public class MethodNode
extends MetadataNode
implements Constants {
    private String name;
    private int modifiers;
    private String returnType;
    private Parameter[] parameters;
    private Statement code;
    private boolean dynamicReturnType;
    private VariableScope variableScope;

    public MethodNode(String name, int modifiers, String returnType, Parameter[] parameters, Statement code) {
        this.name = name;
        this.modifiers = modifiers;
        this.returnType = returnType;
        this.parameters = parameters;
        this.code = code;
        if (returnType == null) {
            this.returnType = "java.lang.Object";
            this.dynamicReturnType = true;
        }
    }

    public boolean isVoidMethod() {
        return "void".equals(this.returnType);
    }

    public Statement getCode() {
        return this.code;
    }

    public void setCode(Statement code) {
        this.code = code;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public String getName() {
        return this.name;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public VariableScope getVariableScope() {
        return this.variableScope;
    }

    public void setVariableScope(VariableScope variableScope) {
        this.variableScope = variableScope;
    }

    public boolean isDynamicReturnType() {
        return this.dynamicReturnType;
    }

    public boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public String toString() {
        return super.toString() + "[name: " + this.name + "]";
    }
}

