/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.bsf;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.BSFFunctions;
import org.codehaus.groovy.bsf.GroovyEngine;
import org.codehaus.groovy.runtime.InvokerHelper;

public class CachingGroovyEngine
extends GroovyEngine {
    private static final String[] EMPTY_ARGS = new String[0];
    private Map evalScripts;
    private Map execScripts;
    private Binding context;
    private ClassLoader parent;
    private GroovyClassLoader loader;

    public Object eval(String source, int lineNo, int columnNo, Object script) throws BSFException {
        try {
            Class scriptClass = (Class)this.evalScripts.get(script);
            if (scriptClass == null) {
                scriptClass = this.loader.parseClass(new ByteArrayInputStream(script.toString().getBytes()), source);
                this.evalScripts.put(script, scriptClass);
            } else {
                System.out.println("eval() - Using cached script...");
            }
            Script s = InvokerHelper.createScript(scriptClass, this.context);
            return s.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "exception from Groovy: " + e, (Throwable)e);
        }
    }

    public void exec(String source, int lineNo, int columnNo, Object script) throws BSFException {
        try {
            Class scriptClass = (Class)this.execScripts.get(script);
            if (scriptClass == null) {
                scriptClass = this.loader.parseClass(new ByteArrayInputStream(script.toString().getBytes()), source);
                this.execScripts.put(script, scriptClass);
            } else {
                System.out.println("exec() - Using cached version of class...");
            }
            InvokerHelper.invokeMethod(scriptClass, "main", EMPTY_ARGS);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "exception from Groovy: " + e, (Throwable)e);
        }
    }

    public void initialize(BSFManager mgr, String lang, Vector declaredBeans) throws BSFException {
        super.initialize(mgr, lang, declaredBeans);
        this.parent = Thread.currentThread().getContextClassLoader();
        if (this.parent == null) {
            this.parent = GroovyShell.class.getClassLoader();
        }
        this.loader = new GroovyClassLoader(this.parent);
        this.execScripts = new HashMap();
        this.evalScripts = new HashMap();
        this.context = this.shell.getContext();
        this.context.setVariable("bsf", new BSFFunctions(mgr, (BSFEngine)this));
        int size = declaredBeans.size();
        for (int i = 0; i < size; ++i) {
            this.declareBean((BSFDeclaredBean)declaredBeans.elementAt(i));
        }
    }
}

