/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import ccl.util.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;

/**
 * Selector which lets more items from one list to another.
 *
 * @version  $Id: ListToListPanel.java,v 1.4 2002/10/06 16:41:41 clemens Exp clemens $
 * @author   <a href="http://www.kclee.com/clemens/">
 *           Chr. Clemens Lee</a>
 *           &lt;<a href="mailto:clemens@kclee.com">
 *           clemens@kclee.com
 *           </a>>
 */
public class ListToListPanel extends JPanel
                             implements ActionListener
{
    private static final int STANDARD_LINES = 15;
    private static final int STANDARD_WIDTH = 200;

    private Vector _vLeftSide;
    private Vector _vRightSide;
    private JList _lstLeft;
    private JList _lstRight;
    private JButton _btnSelect = new JButton("Select ->");
    private JButton _btnDeselect = new JButton("<- Deselect");
    private JButton _btnSelectAll = new JButton("Select All =>");
    private JButton _btnDeselectAll = new JButton("<= Deselect All");

    private void _updateLists() 
{
        SwingUtil.setList( _lstLeft, Util.sort( _vLeftSide ) );
        SwingUtil.setList( _lstRight, Util.sort( _vRightSide ) );
    }

    public ListToListPanel(String sLeftMessage_, String sRightMessage_,
                           int insets_)
    {
        this(sLeftMessage_, sRightMessage_, new Vector(), new Vector(),
             insets_);
    }

    public ListToListPanel(String sLeftMessage_, String sRightMessage_,
                           Vector vLeftSide_, Vector vRightSide_,
                           int insets_)
    {
        super();
        Util.panicIf(vLeftSide_ == null || vRightSide_ == null);
        
        _vLeftSide = (Vector)vLeftSide_.clone() ;
        _vRightSide = (Vector)vRightSide_.clone();
        
        AutoGridBagLayout pAutoGridBagLayout = new AutoGridBagLayout();
        pAutoGridBagLayout.setInsets(insets_);
        setLayout(pAutoGridBagLayout);
        
        _lstLeft = new JList( new DefaultListModel() );
        _lstRight = new JList( new DefaultListModel() );
        _lstLeft.setSelectionMode( ListSelectionModel.MULTIPLE_INTERVAL_SELECTION );
        _lstRight.setSelectionMode( ListSelectionModel.MULTIPLE_INTERVAL_SELECTION );

        // Messages
        pAutoGridBagLayout.setFillNone();
        pAutoGridBagLayout.setAnchor(AutoGridBagLayout.WEST);
        add(new JLabel(sLeftMessage_));
        add(new JLabel(" "));
        add(new JLabel(" "));
        add(new JLabel(" "));
        add(new JLabel(sRightMessage_));
        pAutoGridBagLayout.endLine();
        
        // Left List
        JScrollPane scpLeft = new JScrollPane( _lstLeft );
        scpLeft.setBorder( SwingUtil.createCCLBorder() );
        pAutoGridBagLayout.setExpandBoth();
        pAutoGridBagLayout.setFillBoth();
        pAutoGridBagLayout.setExtend(1, 7);
        add( scpLeft );
        pAutoGridBagLayout.setExtend(1, 1);
        
        // Puffer Spalte
        pAutoGridBagLayout.setFillNone();
        pAutoGridBagLayout.setExpandNone();
        add(new JLabel(" "));
        
        // Knpfe
        pAutoGridBagLayout.setFillHorizontal();
        pAutoGridBagLayout.setExpandVertical();
        add(new JLabel(" "));
        pAutoGridBagLayout.setExpandNone();
        pAutoGridBagLayout.nextLine();
        
        add(_btnSelect);
        pAutoGridBagLayout.nextLine();
        add(_btnDeselect);
        pAutoGridBagLayout.nextLine();
        add(new JLabel(" "));
        pAutoGridBagLayout.nextLine();
        add(_btnSelectAll);
        pAutoGridBagLayout.nextLine();
        add(_btnDeselectAll);
        pAutoGridBagLayout.nextLine();
        
        pAutoGridBagLayout.setFillHorizontal();
        pAutoGridBagLayout.setExpandVertical(2.0);
        add(new JLabel(" "));
        pAutoGridBagLayout.setExpandNone();
        pAutoGridBagLayout.gotoGrid(3, 1);
        
        // Puffer Spalte
        pAutoGridBagLayout.setFillNone();
        pAutoGridBagLayout.setExpandNone();
        add(new JLabel(" "));
        
        // Right List
        JScrollPane scpRight = new JScrollPane( _lstRight );
        scpRight.setBorder( SwingUtil.createCCLBorder() );
        pAutoGridBagLayout.setExpandBoth();
        pAutoGridBagLayout.setFillBoth();
        pAutoGridBagLayout.setExtend(1, 7);
        add( scpRight );
        pAutoGridBagLayout.setExtend(1, 1);

        SwingUtil.setList( _lstLeft, Util.sort( _vLeftSide ) );
        SwingUtil.setList( _lstRight, Util.sort( _vRightSide ) );
        
        _btnSelect.addActionListener(this);
        _btnSelectAll.addActionListener(this);
        _btnDeselect.addActionListener(this);
        _btnDeselectAll.addActionListener(this);
    }

    public void actionPerformed(ActionEvent pActionEvent_) 
{
        Object oSource = pActionEvent_.getSource();
        if (oSource == _btnSelectAll) 
{
            _vRightSide = Util.concat(_vRightSide, _vLeftSide);
            _vLeftSide = new Vector();
            _updateLists();
        }
 else if (oSource == _btnDeselectAll) 
{
            _vLeftSide = Util.concat(_vLeftSide, _vRightSide);
            _vRightSide = new Vector();
            _updateLists();
        }
 else if (oSource == _btnSelect) 
{
            Vector vSelected = Util.objectsToVector
                   ( _lstLeft.getSelectedValues() );
            _vRightSide = Util.concat(_vRightSide, vSelected);
            _vLeftSide = Util.subtract(_vLeftSide, vSelected);
            _updateLists();
        }
 else if (oSource == _btnDeselect) 
{
            Vector vSelected = Util.objectsToVector
                   ( _lstRight.getSelectedValues() );
            _vLeftSide = Util.concat(_vLeftSide, vSelected);
            _vRightSide = Util.subtract(_vRightSide, vSelected);
            _updateLists();
        }
    }
    
    public synchronized void removeAll() 
{
        _vLeftSide = new Vector();
        _vRightSide = new Vector();
        _updateLists();
    }
    
    public synchronized void add(Vector vLeft_, Vector vRight_) 
{
        _vLeftSide = Util.concat(_vLeftSide, vLeft_);
        _vRightSide = Util.concat(_vRightSide, vRight_);
        _updateLists();
    }
    
    public synchronized Vector getLeft() 
{
        return (Vector)_vLeftSide.clone();
    }
    
    public synchronized Vector getRight() 
{
        return (Vector)_vRightSide.clone();
    }
}

