/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import ccl.util.FileUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/**
 * A simple text viewer class.
 *
 * @author  Chr. Clemens Lee
 * @version $Id: TextViewer.java,v 1.3 2002/10/06 16:41:52 clemens Exp clemens $
 */
public class TextViewer extends ExitJDialog 
{
    private static final Font FONT_COURIER = new Font( "Monospaced", Font.PLAIN, 12 );

    private JTextArea _pTextArea = null;
    private JButton   _btnOK     = null;

    /**
     * Constructor to create a text viewer object.
     * You should use a factory class instead.
     */
    public TextViewer( Frame frmParent_ ) 
    {
        super( frmParent_, false );

        setTitle( "Text Viewer" );

        _btnOK = new JButton( "OK" );
        _btnOK.addActionListener( new ActionListener() {
                public void actionPerformed( ActionEvent event_ ) 
                {
                    TextViewer.this.setVisible( false );
                }
            } );

        JPanel pnlMain = (JPanel)getContentPane();

        _pTextArea = new JTextArea();
        _pTextArea.setFont( FONT_COURIER );
        JScrollPane scpText = new JScrollPane( _pTextArea );
        scpText.setBorder( SwingUtil.createCCLBorder() );

        AutoGridBagLayout layout = new AutoGridBagLayout();
        layout.setLayoutOn  ( pnlMain                               );
        layout.setExpandBoth();
        layout.setFillBoth  ();
        layout.add          ( pnlMain, scpText                      );
        layout.setFillNone  ();
        layout.setExpandNone();
        layout.endLine      ();

        layout.add          ( pnlMain, Box.createVerticalStrut( 5 ) );
        layout.endLine      ();

        layout.add          ( pnlMain, _btnOK                       );
        layout.endLine      ();

        layout.add          ( pnlMain, Box.createVerticalStrut( 2 ) );
        layout.endLine      ();

        Dimension dimScreen = SwingUtil.getScreenSize();
        int width  = dimScreen.width  * 3 / 4;
        int height = dimScreen.height * 3 / 4;
        setSize( width, height );
        SwingUtil.centerComponent( this );
    }

    /**
     * Opens a text viewer with the content of a specified file.
     */
    static public void showTextFromFile( Frame frmParent_, String sFile_ ) 
    {
        TextViewer viewer = new TextViewer( frmParent_ );
        try 
        {
            String sFileContent = FileUtil.readFile( sFile_ );
            showText( frmParent_, sFileContent );
        }
        catch( IOException exception ) 
        {
            SwingUtil.showMessage( frmParent_
                                   , "Error while loading file '"
                                   + sFile_
                                   + "'!" );

            return;
        }
    }

    /**
     * Opens a text viewer with the content of a specified file.
     */
    static public void showText( Frame frmParent_, String sContent_ ) 
    {
        TextViewer viewer = new TextViewer( frmParent_ );
        viewer._pTextArea.setText( sContent_ );

        viewer.setVisible( true );
    }
}
