//
//  JCF Java Class File Manipulation Package (package lti.java.jcf)
//  Copyright (c) 1997 Matt T. Yourst. All rights reserved.
//
//  Version:  1.00.171
//  Date:     January through May 1997
//  Author:   Matt Yourst [yourst@laserstars.com]
//  Language: Java 1.1+
//

package lti.java.jcf;

import java.io.*;

/**
 * A simple implementation of JcfClassOutput that extends DataOutputStream.
 */
public class JcfClassOutputStream extends DataOutputStream implements JcfClassOutput
{
  public JcfClassOutputStream (OutputStream fos) throws IOException
    { super(fos); }
  public void writeCPRef (int cpIndex) throws IOException { writeShort(cpIndex); }
  public void writeShortVerbatim (int value) throws IOException
    { writeShort((short)value); }
  public void writeIntVerbatim (int value) throws IOException
    { writeInt(value); }
  public void writeShortMax (int value, int maxValue) throws IOException
    { writeShort((short)value); }
}
