/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import java.io.File;
import java.io.PrintWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class BaseCmd {
    private String cmdLineSyntax;
    private String cmdName;
    private String desc;
    private String onlineHelp;
    protected Map<String, Option> optMap = new HashMap<String, Option>();
    @Opt(opt="h", longOpt="help", hasArg=false, description="Print this help message")
    private boolean printHelp = false;
    protected String[] remainingArgs;

    public BaseCmd() {
    }

    public BaseCmd(String cmdLineSyntax, String header) {
        int i = cmdLineSyntax.indexOf(32);
        if (i > 0) {
            this.cmdName = cmdLineSyntax.substring(0, i);
            this.cmdLineSyntax = cmdLineSyntax.substring(i + 1);
        }
        this.desc = header;
    }

    public BaseCmd(String cmdName, String cmdSyntax, String header) {
        this.cmdName = cmdName;
        this.cmdLineSyntax = cmdSyntax;
        this.desc = header;
    }

    private Set<Option> collectRequriedOptions(Map<String, Option> optMap) {
        HashSet<Option> options = new HashSet<Option>();
        for (Map.Entry<String, Option> e : optMap.entrySet()) {
            Option option = e.getValue();
            if (!option.required) continue;
            options.add(option);
        }
        return options;
    }

    protected Object convert(String value, Class type) {
        if (type.equals(String.class)) {
            return value;
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return Integer.parseInt(value);
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return Long.parseLong(value);
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return Double.parseDouble(value);
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return Boolean.parseBoolean(value);
        }
        if (type.equals(File.class)) {
            return new File(value);
        }
        try {
            type.asSubclass(Enum.class);
            return Enum.valueOf(type, value);
        }
        catch (Exception exception) {
            throw new RuntimeException("can't convert [" + value + "] to type " + type);
        }
    }

    protected abstract void doCommandLine() throws Exception;

    public void doMain(String ... args) {
        try {
            this.initOptions();
            this.parseSetArgs(args);
            this.doCommandLine();
        }
        catch (HelpException helpException) {
            this.usage();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    protected String getVersionString() {
        return this.getClass().getPackage().getImplementationVersion();
    }

    protected void initOptionFromClass(Class<?> clz) {
        Field[] fs;
        if (clz == null) {
            return;
        }
        this.initOptionFromClass(clz.getSuperclass());
        Syntax syntax = clz.getAnnotation(Syntax.class);
        if (syntax != null) {
            this.cmdLineSyntax = syntax.syntax();
            this.cmdName = syntax.cmd();
            this.desc = syntax.desc();
            this.onlineHelp = syntax.onlineHelp();
        }
        Field[] fieldArray = fs = clz.getDeclaredFields();
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            Opt opt = f.getAnnotation(Opt.class);
            if (opt != null) {
                f.setAccessible(true);
                if (!opt.hasArg()) {
                    boolean b;
                    Class<?> type = f.getType();
                    if (!type.equals(Boolean.TYPE)) {
                        throw new RuntimeException("the type of " + f + " must be boolean, as it is declared as no args");
                    }
                    try {
                        b = (Boolean)f.get(this);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    if (b) {
                        throw new RuntimeException("the value of " + f + " must be false, as it is declared as no args");
                    }
                }
                Option option = new Option();
                option.field = f;
                option.opt = opt.opt();
                option.description = opt.description();
                option.hasArg = opt.hasArg();
                option.required = opt.required();
                if (!"".equals(opt.longOpt())) {
                    option.longOpt = opt.longOpt();
                    this.optMap.put("--" + option.longOpt, option);
                }
                if (!"".equals(opt.argName())) {
                    option.argName = opt.argName();
                }
                this.optMap.put("-" + option.opt, option);
            }
            ++n2;
        }
    }

    protected void initOptions() {
        this.initOptionFromClass(this.getClass());
    }

    protected void parseSetArgs(String ... args) throws IllegalArgumentException, IllegalAccessException {
        ArrayList<String> remainsOptions = new ArrayList<String>();
        Set<Option> requiredOpts = this.collectRequriedOptions(this.optMap);
        Option needArgOpt = null;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (needArgOpt != null) {
                needArgOpt.field.set(this, this.convert(s, needArgOpt.field.getType()));
                needArgOpt = null;
            } else if (s.startsWith("-")) {
                Option opt = this.optMap.get(s);
                requiredOpts.remove(opt);
                if (opt == null) {
                    System.err.println("ERROR: Unrecognized option: " + s);
                    throw new HelpException();
                }
                if (opt.hasArg) {
                    needArgOpt = opt;
                } else {
                    opt.field.set(this, true);
                }
            } else {
                remainsOptions.add(s);
            }
            ++n2;
        }
        if (needArgOpt != null) {
            System.err.println("ERROR: Option " + needArgOpt.getOptAndLongOpt() + " need an argument value");
            throw new HelpException();
        }
        this.remainingArgs = remainsOptions.toArray(new String[0]);
        if (this.printHelp) {
            throw new HelpException();
        }
        if (!requiredOpts.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("ERROR: Options: ");
            boolean first = true;
            for (Option option : requiredOpts) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" and ");
                }
                sb.append(option.getOptAndLongOpt());
            }
            sb.append(" is required");
            System.err.println(sb.toString());
            throw new HelpException();
        }
    }

    protected void usage() {
        PrintWriter out = new PrintWriter(System.err, true);
        out.println(String.valueOf(this.cmdName) + " -- " + this.desc);
        out.println("usage: " + this.cmdName + " " + this.cmdLineSyntax);
        if (this.optMap.size() > 0) {
            out.println("options:");
        }
        TreeSet<Option> options = new TreeSet<Option>(this.optMap.values());
        int palength = -1;
        for (Option option : options) {
            int pa = 5 + option.opt.length();
            if (option.longOpt != null) {
                pa += 3 + option.longOpt.length();
            }
            if (option.hasArg) {
                pa += 3 + option.argName.length();
            }
            if (pa >= 40 || pa <= palength) continue;
            palength = pa;
        }
        int pblength = 80 - palength;
        StringBuilder sb = new StringBuilder();
        for (Option option : options) {
            String desc;
            sb.setLength(0);
            sb.append(" -").append(option.opt);
            if (option.longOpt != null) {
                sb.append(",--").append(option.longOpt);
            }
            if (option.hasArg) {
                sb.append(" <").append(option.argName).append(">");
            }
            if ((desc = option.description) == null || desc.length() == 0) {
                out.println(sb);
                continue;
            }
            int i = palength - sb.length();
            while (i > 0) {
                sb.append(' ');
                --i;
            }
            if (sb.length() > 40) {
                out.println(sb);
                sb.setLength(0);
                i = 0;
                while (i < palength) {
                    sb.append(' ');
                    ++i;
                }
            }
            int nextStart = 0;
            while (nextStart < desc.length()) {
                if (desc.length() - nextStart < pblength) {
                    sb.append(desc.substring(nextStart));
                    out.println(sb);
                    nextStart = desc.length();
                    sb.setLength(0);
                    continue;
                }
                sb.append(desc.substring(nextStart, pblength));
                out.println(sb);
                nextStart += pblength;
                sb.setLength(0);
                int i2 = 0;
                while (i2 < palength) {
                    sb.append(' ');
                    ++i2;
                }
            }
            if (sb.length() <= 0) continue;
            out.println(sb);
            sb.setLength(0);
        }
        String ver = this.getVersionString();
        if (ver != null && !"".equals(ver)) {
            out.println("version: " + ver);
        }
        if (this.onlineHelp != null && !"".equals(this.onlineHelp)) {
            if (this.onlineHelp.length() + "online help: ".length() > 80) {
                out.println("online help: ");
                out.println(this.onlineHelp);
            } else {
                out.println("online help: " + this.onlineHelp);
            }
        }
        out.flush();
    }

    protected static class HelpException
    extends RuntimeException {
        protected HelpException() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    protected static @interface Opt {
        public String argName() default "";

        public String description();

        public boolean hasArg() default true;

        public String longOpt() default "";

        public String opt();

        public boolean required() default false;
    }

    protected static class Option
    implements Comparable<Option> {
        public String argName = "arg";
        public String description;
        public Field field;
        public boolean hasArg = true;
        public String longOpt;
        public String opt;
        public boolean required = false;

        protected Option() {
        }

        @Override
        public int compareTo(Option o) {
            return this.opt.compareTo(o.opt);
        }

        public String getOptAndLongOpt() {
            StringBuilder sb = new StringBuilder();
            sb.append("-").append(this.opt);
            if (this.longOpt != null) {
                sb.append(",--").append(this.longOpt);
            }
            return sb.toString();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    protected static @interface Syntax {
        public String cmd();

        public String desc() default "";

        public String onlineHelp() default "";

        public String syntax() default "";
    }
}

