/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.dex2jar.tools.BaseCmd;
import jasmin.ClassFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import p.rn.util.FileOut;
import p.rn.util.FileWalker;

public class Jasmin2Jar
extends BaseCmd {
    @BaseCmd.Opt(opt="g", longOpt="autogenerate-linenumbers", hasArg=false, description="autogenerate-linenumbers")
    boolean autogenLines = false;
    @BaseCmd.Opt(opt="f", longOpt="force", hasArg=false, description="force overwrite")
    private boolean forceOverwrite = false;
    @BaseCmd.Opt(opt="o", longOpt="output", description="output .jar file, default is $current_dir/[jar-name]-jasmin2jar.jar", argName="out-jar-file")
    private File output;
    @BaseCmd.Opt(opt="e", longOpt="encoding", description="encoding for .j files, default is UTF-8", argName="enc")
    private String encoding = "UTF-8";

    public static void main(String[] args) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        new Jasmin2Jar().doMain(args);
    }

    public Jasmin2Jar() {
        super("d2j-jasmin2jar [options] <dir>", "d2j-jasmin2jar - assemble .j files to .class file");
    }

    @Override
    protected void doCommandLine() throws Exception {
        if (this.remainingArgs.length != 1) {
            this.usage();
            return;
        }
        File dir = new File(this.remainingArgs[0]);
        if (!dir.exists()) {
            System.err.println(dir + " is not exists");
            this.usage();
            return;
        }
        if (this.output == null) {
            this.output = dir.isDirectory() ? new File(String.valueOf(dir.getName()) + "-jasmin2jar.jar") : new File(String.valueOf(FilenameUtils.getBaseName((String)dir.getName())) + "-jasmin2jar.jar");
        }
        if (this.output.exists() && !this.forceOverwrite) {
            System.err.println(this.output + " exists, use --force to overwrite");
            this.usage();
            return;
        }
        System.out.println("assemble " + dir + " -> " + this.output);
        final FileOut.OutHandler fo = FileOut.create((File)this.output, (boolean)true);
        try {
            new FileWalker().withStreamHandler(new FileWalker.StreamHandler(){

                public void handle(boolean isDir, String name, FileWalker.StreamOpener current, Object nameObject) throws IOException {
                    if (isDir || !name.endsWith(".j")) {
                        return;
                    }
                    try {
                        ClassFile classFile = new ClassFile();
                        InputStreamReader reader = new InputStreamReader(current.get(), Jasmin2Jar.this.encoding);
                        classFile.readJasmin((Reader)reader, name, Jasmin2Jar.this.autogenLines);
                        int errorcount = classFile.errorCount();
                        if (errorcount > 0) {
                            System.err.println(String.valueOf(name) + ": Found " + errorcount + " errors");
                            return;
                        }
                        String clzName = classFile.getClassName();
                        OutputStream os = fo.openOutput(String.valueOf(clzName.replace('.', '/')) + ".class", nameObject);
                        try {
                            classFile.write(os);
                        }
                        finally {
                            IOUtils.closeQuietly((OutputStream)os);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(System.err);
                    }
                }
            }).walk(dir);
        }
        finally {
            IOUtils.closeQuietly((Closeable)fo);
        }
    }
}

