/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.reader;

enum OpcodeFormat {
    F10t(1),
    F10x(1),
    F11n(1),
    F11x(1),
    F12x(1),
    F20bc(2),
    F20t(2),
    F21c(2),
    F21h(2),
    F21s(2),
    F21t(2),
    F22b(2),
    F22c(2),
    F22cs(2),
    F22s(2),
    F22t(2),
    F22x(2),
    F23x(2),
    F30t(3),
    F31c(3),
    F31i(3),
    F31t(3),
    F32s(3),
    F32x(3),
    F33x(3),
    F35c(3),
    F35mi(3),
    F35ms(3),
    F3rc(3),
    F3rmi(3),
    F3rms(3),
    F40sc(4),
    F41c(4),
    F51l(5),
    F52c(5),
    F5rc(5);

    private int size;

    private OpcodeFormat(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public static OpcodeFormat get(int opcode, int apiLevel) {
        switch (opcode) {
            case 240: {
                if (apiLevel < 14) {
                    return F35c;
                }
                return F3rc;
            }
            case 40: {
                return F10t;
            }
            case 0: 
            case 14: 
            case 241: {
                return F10x;
            }
            case 18: {
                return F11n;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 29: 
            case 30: 
            case 39: {
                return F11x;
            }
            case 1: 
            case 4: 
            case 7: 
            case 33: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                return F12x;
            }
            case 237: {
                return F20bc;
            }
            case 41: {
                return F20t;
            }
            case 26: 
            case 28: 
            case 31: 
            case 34: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 229: 
            case 230: 
            case 234: 
            case 235: 
            case 253: 
            case 254: {
                return F21c;
            }
            case 21: 
            case 25: {
                return F21h;
            }
            case 19: 
            case 22: {
                return F21s;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                return F21t;
            }
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: {
                return F22b;
            }
            case 32: 
            case 35: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 227: 
            case 228: 
            case 231: 
            case 232: 
            case 233: 
            case 252: {
                return F22c;
            }
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: {
                return F22cs;
            }
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: {
                return F22s;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                return F22t;
            }
            case 2: 
            case 5: 
            case 8: {
                return F22x;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: {
                return F23x;
            }
            case 42: {
                return F30t;
            }
            case 27: {
                return F31c;
            }
            case 20: 
            case 23: {
                return F31i;
            }
            case 38: 
            case 43: 
            case 44: {
                return F31t;
            }
            case 3: 
            case 6: 
            case 9: {
                return F32x;
            }
            case 36: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                return F35c;
            }
            case 238: {
                return F35mi;
            }
            case 248: 
            case 250: {
                return F35ms;
            }
            case 37: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                return F3rc;
            }
            case 239: {
                return F3rmi;
            }
            case 249: 
            case 251: {
                return F3rms;
            }
            case 255: 
            case 511: 
            case 1023: 
            case 5375: 
            case 5631: 
            case 5887: 
            case 6143: 
            case 6399: 
            case 6655: 
            case 6911: 
            case 7167: 
            case 7423: 
            case 7679: 
            case 7935: 
            case 8191: 
            case 8447: 
            case 8703: 
            case 63999: 
            case 64255: 
            case 64511: 
            case 64767: 
            case 65023: 
            case 65279: {
                return F41c;
            }
            case 24: {
                return F51l;
            }
            case 767: 
            case 1279: 
            case 1791: 
            case 2047: 
            case 2303: 
            case 2559: 
            case 2815: 
            case 3071: 
            case 3327: 
            case 3583: 
            case 3839: 
            case 4095: 
            case 4351: 
            case 4607: 
            case 4863: 
            case 5119: 
            case 62463: 
            case 62719: 
            case 62975: 
            case 63231: 
            case 63487: 
            case 63743: {
                return F52c;
            }
            case 1535: 
            case 8959: 
            case 9215: 
            case 9471: 
            case 9727: 
            case 9983: 
            case 62207: {
                return F5rc;
            }
        }
        throw new RuntimeException("opcode format for " + opcode + " not found!");
    }
}

