/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.Err;
import fan.sys.Facets;
import fan.sys.Func;
import fan.sys.JavaType;
import fan.sys.List;
import fan.sys.Map;
import fan.sys.Method;
import fan.sys.ReadonlyErr;
import fan.sys.Slot;
import fan.sys.Sys;
import fan.sys.Type;
import java.util.Iterator;
import java.util.Map;

public class Field
extends Slot {
    Type type;
    Method getter;
    Method setter;
    java.lang.reflect.Field reflect;
    Method overload;

    public static Func makeSetFunc(final Map map) {
        return new Func.Indirect1(){

            public Object call(Object object) {
                Iterator iterator = map.pairsIterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    Field field = (Field)entry.getKey();
                    Object v = entry.getValue();
                    field.set(object, v, object != this.inCtor);
                }
                return null;
            }
        };
    }

    public Field(Type type, String string, int n, Facets facets, int n2, Type type2) {
        super(type, string, n, facets, n2);
        this.type = type2;
    }

    public Type typeof() {
        return Sys.FieldType;
    }

    public Type type() {
        return this.type;
    }

    public String signature() {
        return this.type.toStr() + " " + this.name;
    }

    public Object trap(String string, List list) {
        if (string.equals("getter")) {
            return this.getter;
        }
        if (string.equals("setter")) {
            return this.setter;
        }
        return super.trap(string, list);
    }

    public Object get() {
        return this.get(null);
    }

    public Object get(Object object) {
        this.parent.finish();
        if (this.getter != null) {
            return this.getter.invoke(object, Method.noArgs);
        }
        try {
            if (this.parent.isJava()) {
                return JavaType.get(this, object);
            }
            return this.reflect.get(object);
        }
        catch (Exception exception) {
            if (this.reflect == null) {
                throw Err.make("Field not mapped to java.lang.reflect correctly " + this.qname());
            }
            throw Err.make(exception);
        }
    }

    public void set(Object object, Object object2) {
        this.set(object, object2, true);
    }

    public void set(Object object, Object object2, boolean bl) {
        this.parent.finish();
        if ((this.flags & 2) != 0) {
            if (bl) {
                throw ReadonlyErr.make("Cannot set const field " + this.qname());
            }
            if (object2 != null && !Field.isImmutable(object2)) {
                throw ReadonlyErr.make("Cannot set const field " + this.qname() + " with mutable value");
            }
        }
        if ((this.flags & 0x8000) != 0 && !this.parent.isJava()) {
            throw ReadonlyErr.make("Cannot set static field " + this.qname());
        }
        if (this.type.isGenericInstance() && object2 != null && !Field.typeof(object2).is(this.type.toNonNullable())) {
            throw ArgErr.make("Wrong type for field " + this.qname() + ": " + this.type + " != " + Field.typeof(object2));
        }
        if (this.setter != null) {
            this.setter.invoke(object, new Object[]{object2});
            return;
        }
        try {
            if (this.parent.isJava()) {
                JavaType.set(this, object, object2);
                return;
            }
            this.reflect.set(object, object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ArgErr.make(illegalArgumentException);
        }
        catch (Exception exception) {
            if (this.reflect == null) {
                throw Err.make("Field not mapped to java.lang.reflect correctly");
            }
            throw Err.make(exception);
        }
    }
}

