/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.Facet;
import fan.sys.Field;
import fan.sys.Func;
import fan.sys.FuncType;
import fan.sys.List;
import fan.sys.ListType;
import fan.sys.Map;
import fan.sys.Method;
import fan.sys.NullableType;
import fan.sys.Param;
import fan.sys.Pod;
import fan.sys.Slot;
import fan.sys.Sys;
import fan.sys.Type;
import fan.sys.UnknownSlotErr;
import java.util.HashMap;

public abstract class GenericType
extends Type {
    private final Type base;
    private Type nullable;
    private Map params;
    private List fields;
    private List methods;
    private List slots;
    private HashMap slotsByName;

    GenericType(Type type) {
        this.base = type;
    }

    public final Pod pod() {
        return this.base.pod();
    }

    public final String name() {
        return this.base.name();
    }

    public final String qname() {
        return this.base.qname();
    }

    public abstract String signature();

    int flags() {
        return this.base.flags();
    }

    public final Type base() {
        return this.base;
    }

    public final List mixins() {
        return this.base.mixins();
    }

    public final List inheritance() {
        return this.base.inheritance();
    }

    public final boolean isGenericInstance() {
        return true;
    }

    public boolean is(Type type) {
        if (type == this || type == this.base) {
            return true;
        }
        return this.base.is(type);
    }

    public final List fields() {
        return this.reflect().fields.ro();
    }

    public final List methods() {
        return this.reflect().methods.ro();
    }

    public final List slots() {
        return this.reflect().slots.ro();
    }

    public final Slot slot(String string, boolean bl) {
        Slot slot = (Slot)this.reflect().slotsByName.get(string);
        if (slot != null) {
            return slot;
        }
        if (bl) {
            throw UnknownSlotErr.make(this.qname() + "." + string);
        }
        return null;
    }

    public final synchronized Type toNullable() {
        if (this.nullable == null) {
            this.nullable = new NullableType(this);
        }
        return this.nullable;
    }

    public Map params() {
        if (this.params == null) {
            this.params = this.makeParams();
        }
        return this.params;
    }

    abstract Map makeParams();

    public List facets() {
        return this.base.facets();
    }

    public Facet facet(Type type, boolean bl) {
        return this.base.facet(type, bl);
    }

    public String doc() {
        return this.base.doc();
    }

    public final boolean javaRepr() {
        return false;
    }

    protected final synchronized GenericType reflect() {
        if (this.slotsByName != null) {
            return this;
        }
        this.doReflect();
        return this;
    }

    private void doReflect() {
        Type type = this.base;
        type.finish();
        List list = type.slots();
        this.fields = new List(Sys.FieldType, type.fields().sz());
        this.methods = new List(Sys.MethodType, type.methods().sz());
        this.slots = new List(Sys.SlotType, list.sz());
        this.slotsByName = new HashMap(list.sz() * 3);
        for (int i = 0; i < list.sz(); ++i) {
            Slot slot = (Slot)list.get(i);
            if (slot instanceof Method) {
                slot = this.parameterize((Method)slot);
                this.methods.add(slot);
            } else {
                slot = this.parameterize((Field)slot);
                this.fields.add(slot);
            }
            this.slots.add(slot);
            this.slotsByName.put(slot.name, slot);
        }
    }

    Field parameterize(Field field) {
        Type type = field.type();
        if (!type.isGenericParameter()) {
            return field;
        }
        type = this.parameterize(type);
        Field field2 = new Field(this, field.name, field.flags, field.facets, field.lineNum, type);
        field2.reflect = field.reflect;
        return field2;
    }

    Method parameterize(Method method) {
        if (!method.isGenericMethod()) {
            return method;
        }
        Func func = method.func;
        List list = new List(Sys.ParamType, method.params.sz());
        Type type = func.returns().isGenericParameter() ? this.parameterize(func.returns()) : func.returns();
        int n = method.params().sz();
        for (int i = 0; i < n; ++i) {
            Param param = (Param)method.params.get(i);
            if (param.type.isGenericParameter()) {
                list.add(new Param(param.name, this.parameterize(param.type), param.mask));
                continue;
            }
            list.add(param);
        }
        Method method2 = new Method(this, method.name, method.flags, method.facets, method.lineNum, type, method.inheritedReturns, list, method);
        method2.reflect = method.reflect;
        return method2;
    }

    final Type parameterize(Type type) {
        boolean bl = type.isNullable();
        Type type2 = type.toNonNullable();
        type = type2 instanceof ListType ? this.parameterizeListType((ListType)type2) : (type2 instanceof FuncType ? this.parameterizeFuncType((FuncType)type2) : this.doParameterize(type2));
        return bl ? type.toNullable() : type;
    }

    final Type parameterizeListType(ListType listType) {
        return this.doParameterize(listType.v).toListOf();
    }

    final FuncType parameterizeFuncType(FuncType funcType) {
        Type[] typeArray = new Type[funcType.params.length];
        for (int i = 0; i < typeArray.length; ++i) {
            Type type = funcType.params[i];
            if (type.isGenericParameter()) {
                type = this.doParameterize(type);
            }
            typeArray[i] = type;
        }
        Type type = funcType.ret;
        if (type.isGenericParameter()) {
            type = this.doParameterize(type);
        }
        return new FuncType(typeArray, type);
    }

    protected abstract Type doParameterize(Type var1);
}

