/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.Buf;
import fan.sys.Charset;
import fan.sys.Endian;
import fan.sys.FanInt;
import fan.sys.FanObj;
import fan.sys.IOErr;
import fan.sys.List;
import fan.sys.Map;
import fan.sys.Sys;
import fan.sys.Type;
import fan.sys.UnsupportedErr;
import fanx.serial.ObjEncoder;
import java.math.BigDecimal;

public class OutStream
extends FanObj {
    public static final long xmlEscNewlines = 1L;
    public static final long xmlEscQuotes = 2L;
    public static final long xmlEscUnicode = 4L;
    OutStream out;
    boolean bigEndian = true;
    Charset charset = Charset.utf8();
    Charset.Encoder charsetEncoder = this.charset.newEncoder();

    public static OutStream make(OutStream outStream) {
        OutStream outStream2 = new OutStream();
        OutStream.make$(outStream2, outStream);
        return outStream2;
    }

    public static void make$(OutStream outStream, OutStream outStream2) {
        outStream.out = outStream2;
    }

    public Type typeof() {
        return Sys.OutStreamType;
    }

    public OutStream w(int n) {
        return this.write(n);
    }

    public OutStream write(long l) {
        try {
            this.out.write(l);
            return this;
        }
        catch (NullPointerException nullPointerException) {
            if (this.out == null) {
                throw UnsupportedErr.make(this.typeof().qname() + " wraps null OutStream");
            }
            throw nullPointerException;
        }
    }

    public OutStream writeBuf(Buf buf) {
        return this.writeBuf(buf, buf.remaining());
    }

    public OutStream writeBuf(Buf buf, long l) {
        try {
            this.out.writeBuf(buf, l);
            return this;
        }
        catch (NullPointerException nullPointerException) {
            if (this.out == null) {
                throw UnsupportedErr.make(this.typeof().qname() + " wraps null OutStream");
            }
            throw nullPointerException;
        }
    }

    public Endian endian() {
        return this.bigEndian ? Endian.big : Endian.little;
    }

    public void endian(Endian endian) {
        this.bigEndian = endian == Endian.big;
    }

    public OutStream writeI2(long l) {
        int n = (int)l;
        if (this.bigEndian) {
            return this.w(n >>> 8 & 0xFF).w(n >>> 0 & 0xFF);
        }
        return this.w(n >>> 0 & 0xFF).w(n >>> 8 & 0xFF);
    }

    public OutStream writeI4(long l) {
        int n = (int)l;
        if (this.bigEndian) {
            return this.w(n >>> 24 & 0xFF).w(n >>> 16 & 0xFF).w(n >>> 8 & 0xFF).w(n >>> 0 & 0xFF);
        }
        return this.w(n >>> 0 & 0xFF).w(n >>> 8 & 0xFF).w(n >>> 16 & 0xFF).w(n >>> 24 & 0xFF);
    }

    public OutStream writeI8(long l) {
        if (this.bigEndian) {
            return this.w((int)(l >>> 56) & 0xFF).w((int)(l >>> 48) & 0xFF).w((int)(l >>> 40) & 0xFF).w((int)(l >>> 32) & 0xFF).w((int)(l >>> 24) & 0xFF).w((int)(l >>> 16) & 0xFF).w((int)(l >>> 8) & 0xFF).w((int)(l >>> 0) & 0xFF);
        }
        return this.w((int)(l >>> 0) & 0xFF).w((int)(l >>> 8) & 0xFF).w((int)(l >>> 16) & 0xFF).w((int)(l >>> 24) & 0xFF).w((int)(l >>> 32) & 0xFF).w((int)(l >>> 40) & 0xFF).w((int)(l >>> 48) & 0xFF).w((int)(l >>> 56) & 0xFF);
    }

    public OutStream writeF4(double d) {
        return this.writeI4(Float.floatToIntBits((float)d));
    }

    public OutStream writeF8(double d) {
        return this.writeI8(Double.doubleToLongBits(d));
    }

    public OutStream writeDecimal(BigDecimal bigDecimal) {
        return this.writeUtf(bigDecimal.toString());
    }

    public OutStream writeBool(boolean bl) {
        return this.w(bl ? 1 : 0);
    }

    public OutStream writeUtf(String string) {
        char c;
        int n;
        int n2 = string.length();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            if (c <= '\u007f') {
                ++n3;
                continue;
            }
            if (c > '\u07ff') {
                n3 += 3;
                continue;
            }
            n3 += 2;
        }
        if (n3 > 65536) {
            throw IOErr.make("String too big");
        }
        this.w(n3 >>> 8 & 0xFF);
        this.w(n3 >>> 0 & 0xFF);
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            if (c <= '\u007f') {
                this.w(c);
                continue;
            }
            if (c > '\u07ff') {
                this.w(0xE0 | c >> 12 & 0xF);
                this.w(0x80 | c >> 6 & 0x3F);
                this.w(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.w(0xC0 | c >> 6 & 0x1F);
            this.w(0x80 | c >> 0 & 0x3F);
        }
        return this;
    }

    public Charset charset() {
        return this.charset;
    }

    public void charset(Charset charset) {
        this.charsetEncoder = charset.newEncoder();
        this.charset = charset;
    }

    public OutStream writeChar(long l) {
        return this.writeChar((char)l);
    }

    public OutStream writeChar(char c) {
        if (this.out != null) {
            this.out.writeChar(c);
        } else {
            this.charsetEncoder.encode(c, this);
        }
        return this;
    }

    public OutStream writeChars(String string) {
        return this.writeChars(string, 0, string.length());
    }

    public OutStream writeChars(String string, long l) {
        return this.writeChars(string, (int)l, string.length() - (int)l);
    }

    public OutStream writeChars(String string, long l, long l2) {
        return this.writeChars(string, (int)l, (int)l2);
    }

    public OutStream writeChars(String string, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.writeChar(string.charAt(i));
        }
        return this;
    }

    public OutStream print(Object object) {
        String string = object == null ? "null" : OutStream.toStr(object);
        return this.writeChars(string, 0, string.length());
    }

    public OutStream printLine() {
        return this.printLine("");
    }

    public OutStream printLine(Object object) {
        String string = object == null ? "null" : OutStream.toStr(object);
        this.writeChars(string, 0, string.length());
        return this.writeChar('\n');
    }

    public OutStream writeObj(Object object) {
        return this.writeObj(object, null);
    }

    public OutStream writeObj(Object object, Map map) {
        new ObjEncoder(this, map).writeObj(object);
        return this;
    }

    public OutStream writeProps(Map map) {
        return this.writeProps(map, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutStream writeProps(Map map, boolean bl) {
        Charset charset = this.charset();
        this.charset(Charset.utf8());
        try {
            List list = map.keys();
            int n = list.sz();
            for (int i = 0; i < n; ++i) {
                String string = (String)list.get(i);
                String string2 = (String)map.get(string);
                this.writePropStr(string);
                this.writeChar('=');
                this.writePropStr(string2);
                this.writeChar('\n');
            }
            OutStream outStream = this;
            return outStream;
        }
        finally {
            try {
                if (bl) {
                    this.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.charset(charset);
        }
    }

    private void writePropStr(String string) {
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            int n2 = i + 1 < n ? (int)string.charAt(i + 1) : -1;
            switch (c) {
                case '\n': {
                    this.writeChar('\\').writeChar('n');
                    continue block6;
                }
                case '\r': {
                    this.writeChar('\\').writeChar('r');
                    continue block6;
                }
                case '\t': {
                    this.writeChar('\\').writeChar('t');
                    continue block6;
                }
                case '\\': {
                    this.writeChar('\\').writeChar('\\');
                    continue block6;
                }
                default: {
                    if (c < ' ' || c == '/' && (n2 == 47 || n2 == 42) || c == '=') {
                        long l = FanInt.toDigit(c >> 4 & 0xF, 16L);
                        long l2 = FanInt.toDigit(c >> 0 & 0xF, 16L);
                        this.writeChar('\\').writeChar('u').writeChar('0').writeChar('0').writeChar(l).writeChar(l2);
                        continue block6;
                    }
                    this.writeChar((long)c);
                }
            }
        }
    }

    public OutStream writeXml(String string) {
        return this.writeXml(string, 0L);
    }

    public OutStream writeXml(String string, long l) {
        boolean bl = (l & 1L) != 0L;
        boolean bl2 = (l & 2L) != 0L;
        boolean bl3 = (l & 4L) != 0L;
        int n = string.length();
        String string2 = "0123456789abcdef";
        block11: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000b': 
                case '\f': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    this.writeXmlEsc(c);
                    continue block11;
                }
                case '\n': 
                case '\r': {
                    if (!bl) {
                        this.writeChar(c);
                        continue block11;
                    }
                    this.writeXmlEsc(c);
                    continue block11;
                }
                case ' ': {
                    this.writeChar(' ');
                    continue block11;
                }
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '_': 
                case '`': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    this.writeChar(c);
                    continue block11;
                }
                case '<': {
                    this.writeChar('&').writeChar('l').writeChar('t').writeChar(';');
                    continue block11;
                }
                case '>': {
                    if (i > 0 && string.charAt(i - 1) != ']') {
                        this.writeChar('>');
                        continue block11;
                    }
                    this.writeChar('&').writeChar('g').writeChar('t').writeChar(';');
                    continue block11;
                }
                case '&': {
                    this.writeChar('&').writeChar('a').writeChar('m').writeChar('p').writeChar(';');
                    continue block11;
                }
                case '\"': {
                    if (!bl2) {
                        this.writeChar(c);
                        continue block11;
                    }
                    this.writeChar('&').writeChar('q').writeChar('u').writeChar('o').writeChar('t').writeChar(';');
                    continue block11;
                }
                case '\'': {
                    if (!bl2) {
                        this.writeChar(c);
                        continue block11;
                    }
                    this.writeChar('&').writeChar('#').writeChar('3').writeChar('9').writeChar(';');
                    continue block11;
                }
                default: {
                    if (c <= '\u00f7' || !bl3) {
                        this.writeChar(c);
                        continue block11;
                    }
                    this.writeXmlEsc(c);
                }
            }
        }
        return this;
    }

    private void writeXmlEsc(int n) {
        Charset.Encoder encoder = this.charsetEncoder;
        String string = "0123456789abcdef";
        encoder.encode('&', this);
        encoder.encode('#', this);
        encoder.encode('x', this);
        if (n > 255) {
            encoder.encode(string.charAt(n >> 12 & 0xF), this);
            encoder.encode(string.charAt(n >> 8 & 0xF), this);
        }
        encoder.encode(string.charAt(n >> 4 & 0xF), this);
        encoder.encode(string.charAt(n >> 0 & 0xF), this);
        encoder.encode(';', this);
    }

    public OutStream flush() {
        if (this.out != null) {
            this.out.flush();
        }
        return this;
    }

    public OutStream sync() {
        if (this.out != null) {
            this.out.sync();
        }
        return this;
    }

    public boolean close() {
        if (this.out != null) {
            return this.out.close();
        }
        return true;
    }

    public OutStream indent(int n) {
        for (int i = 0; i < n; ++i) {
            this.charsetEncoder.encode(' ', this);
        }
        return this;
    }
}

