/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.Env;
import fan.sys.Err;
import fan.sys.FanObj;
import fan.sys.File;
import fan.sys.InStream;
import fan.sys.List;
import fan.sys.LocalFile;
import fan.sys.Map;
import fan.sys.OutStream;
import fan.sys.Sys;
import fan.sys.SysInStream;
import fan.sys.SysOutStream;
import fan.sys.Type;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;

public class Process
extends FanObj {
    private List command;
    private File dir;
    private Map env;
    private boolean mergeErr = true;
    private OutStream out = Env.cur().out();
    private OutStream err = Env.cur().err();
    private InStream in = null;
    private volatile java.lang.Process proc;

    public static Process make() {
        return new Process(new List(Sys.StrType), null);
    }

    public static Process make(List list) {
        return new Process(list, null);
    }

    public static Process make(List list, File file) {
        return new Process(list, file);
    }

    private Process(List list, File file) {
        this.command(list);
        this.dir(file);
    }

    public Type typeof() {
        return Sys.ProcessType;
    }

    public List command() {
        return this.command;
    }

    public void command(List list) {
        this.command = list;
    }

    public File dir() {
        return this.dir;
    }

    public void dir(File file) {
        this.checkRun();
        if (!(file == null || file.exists() && file.isDir())) {
            throw ArgErr.make("Invalid working directory: " + file);
        }
        this.dir = file;
    }

    public Map env() {
        if (this.env == null) {
            this.env = new Map(Sys.StrType, Sys.StrType);
            for (Map.Entry<String, String> entry : new ProcessBuilder(new String[0]).environment().entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                this.env.set(string, string2);
            }
        }
        return this.env;
    }

    public boolean mergeErr() {
        return this.mergeErr;
    }

    public void mergeErr(boolean bl) {
        this.checkRun();
        this.mergeErr = bl;
    }

    public OutStream out() {
        return this.out;
    }

    public void out(OutStream outStream) {
        this.checkRun();
        this.out = outStream;
    }

    public OutStream err() {
        return this.err;
    }

    public void err(OutStream outStream) {
        this.checkRun();
        this.err = outStream;
    }

    public InStream in() {
        return this.in;
    }

    public void in(InStream inStream) {
        this.checkRun();
        this.in = inStream;
    }

    public final Process run() {
        this.checkRun();
        try {
            String[] stringArray = new String[this.command.sz()];
            for (int i = 0; i < this.command.sz(); ++i) {
                stringArray[i] = (String)this.command.get(i);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            if (this.env != null) {
                Iterator iterator = this.env.pairsIterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    String string = (String)entry.getKey();
                    String string2 = (String)entry.getValue();
                    processBuilder.environment().put(string, string2);
                }
            }
            if (this.dir != null) {
                processBuilder.directory(((LocalFile)this.dir).file);
            }
            if (this.mergeErr) {
                processBuilder.redirectErrorStream(true);
            }
            this.proc = processBuilder.start();
            new PipeInToOut(this, "out", this.proc.getInputStream(), this.out).start();
            if (!this.mergeErr) {
                new PipeInToOut(this, "err", this.proc.getErrorStream(), this.err).start();
            }
            if (this.in != null) {
                new PipeOutToIn(this, this.proc.getOutputStream(), this.in).start();
            }
            return this;
        }
        catch (Throwable throwable) {
            this.proc = null;
            throw Err.make(throwable);
        }
    }

    public final long join() {
        if (this.proc == null) {
            throw Err.make("Process not running");
        }
        try {
            return this.proc.waitFor();
        }
        catch (Throwable throwable) {
            throw Err.make(throwable);
        }
    }

    public final Process kill() {
        if (this.proc == null) {
            throw Err.make("Process not running");
        }
        this.proc.destroy();
        return this;
    }

    private void checkRun() {
        if (this.proc != null) {
            throw Err.make("Process already run");
        }
    }

    boolean isAlive() {
        try {
            this.proc.exitValue();
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
    }

    static class PipeOutToIn
    extends Thread {
        final Process proc;
        final OutputStream out;
        final InputStream in;

        PipeOutToIn(Process process, OutputStream outputStream, InStream inStream) {
            super("Process.in");
            this.proc = process;
            this.out = outputStream;
            this.in = SysInStream.java(inStream);
        }

        public void run() {
            byte[] byArray = new byte[256];
            while (true) {
                try {
                    int n;
                    while ((n = this.in.read(byArray, 0, byArray.length)) >= 0) {
                        this.out.write(byArray, 0, n);
                        this.out.flush();
                    }
                }
                catch (Throwable throwable) {
                    if (!this.proc.isAlive()) continue;
                    throwable.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    static class PipeInToOut
    extends Thread {
        final Process proc;
        final InputStream in;
        final OutputStream out;

        PipeInToOut(Process process, String string, InputStream inputStream, OutStream outStream) {
            super("Process." + string);
            this.proc = process;
            this.in = inputStream;
            this.out = outStream == null ? null : SysOutStream.java(outStream);
        }

        public void run() {
            byte[] byArray = new byte[256];
            block2: while (true) {
                try {
                    while (true) {
                        int n;
                        if ((n = this.in.read(byArray, 0, byArray.length)) < 0) {
                            if (this.out == null) break block2;
                            this.out.flush();
                            break block2;
                        }
                        if (this.out == null) continue;
                        this.out.write(byArray, 0, n);
                    }
                }
                catch (Throwable throwable) {
                    if (!this.proc.isAlive()) continue;
                    throwable.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

