/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.FanInt;
import fan.sys.FanObj;
import fan.sys.Func;
import fan.sys.IndexErr;
import fan.sys.List;
import fan.sys.ParseErr;
import fan.sys.Sys;
import fan.sys.Type;

public final class Range
extends FanObj {
    private final long start;
    private final long end;
    private final boolean exclusive;

    public static Range makeInclusive(long l, long l2) {
        return new Range(l, l2, false);
    }

    public static Range makeExclusive(long l, long l2) {
        return new Range(l, l2, true);
    }

    public static Range make(long l, long l2, boolean bl) {
        return new Range(l, l2, bl);
    }

    public static Range fromStr(String string) {
        return Range.fromStr(string, true);
    }

    public static Range fromStr(String string, boolean bl) {
        try {
            int n = string.indexOf(46);
            if (string.charAt(n + 1) != '.') {
                throw new Exception();
            }
            boolean bl2 = string.charAt(n + 2) == '<';
            long l = Long.parseLong(string.substring(0, n));
            long l2 = Long.parseLong(string.substring(n + (bl2 ? 3 : 2)));
            return new Range(l, l2, bl2);
        }
        catch (Exception exception) {
            if (!bl) {
                return null;
            }
            throw ParseErr.make("Range", string);
        }
    }

    private Range(long l, long l2, boolean bl) {
        this.start = l;
        this.end = l2;
        this.exclusive = bl;
    }

    public final long start() {
        return this.start;
    }

    public final long end() {
        return this.end;
    }

    public final boolean inclusive() {
        return !this.exclusive;
    }

    public final boolean exclusive() {
        return this.exclusive;
    }

    public final boolean isEmpty() {
        return this.exclusive && this.start == this.end;
    }

    public final Long min() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.end < this.start) {
            return this.exclusive ? this.end + 1L : this.end;
        }
        return this.start;
    }

    public final Long max() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.end < this.start) {
            return this.start;
        }
        return this.exclusive ? this.end - 1L : this.end;
    }

    public final Long first() {
        if (this.isEmpty()) {
            return null;
        }
        return this.start;
    }

    public final Long last() {
        if (this.isEmpty()) {
            return null;
        }
        if (!this.exclusive) {
            return this.end;
        }
        if (this.start < this.end) {
            return this.end - 1L;
        }
        return this.end + 1L;
    }

    public final boolean contains(long l) {
        if (this.start < this.end) {
            if (this.exclusive) {
                return this.start <= l && l < this.end;
            }
            return this.start <= l && l <= this.end;
        }
        if (this.exclusive) {
            return this.end < l && l <= this.start;
        }
        return this.end <= l && l <= this.start;
    }

    public final Range offset(long l) {
        if (l == 0L) {
            return this;
        }
        return new Range(this.start + l, this.end + l, this.exclusive);
    }

    public final void each(Func func) {
        long l = this.start;
        long l2 = this.end;
        if (l < l2) {
            if (this.exclusive) {
                --l2;
            }
            for (long i = l; i <= l2; ++i) {
                func.call(i);
            }
        } else {
            if (this.exclusive) {
                ++l2;
            }
            for (long i = l; i >= l2; --i) {
                func.call(i);
            }
        }
    }

    public final List map(Func func) {
        long l = this.start;
        long l2 = this.end;
        Type type = func.returns();
        if (type == Sys.VoidType) {
            type = Sys.ObjType.toNullable();
        }
        List list = new List(type);
        if (l < l2) {
            if (this.exclusive) {
                --l2;
            }
            for (long i = l; i <= l2; ++i) {
                list.add(func.call(i));
            }
        } else {
            if (this.exclusive) {
                ++l2;
            }
            for (long i = l; i >= l2; --i) {
                list.add(func.call(i));
            }
        }
        return list;
    }

    public final List toList() {
        long l = this.start;
        long l2 = this.end;
        List list = new List(Sys.IntType);
        if (l < l2) {
            if (this.exclusive) {
                --l2;
            }
            list.capacity(l2 - l + 1L);
            for (long i = l; i <= l2; ++i) {
                list.add(i);
            }
        } else {
            if (this.exclusive) {
                ++l2;
            }
            list.capacity(l - l2 + 1L);
            for (long i = l; i >= l2; --i) {
                list.add(i);
            }
        }
        return list;
    }

    public final long random() {
        return FanInt.random(this);
    }

    public final boolean equals(Object object) {
        if (object instanceof Range) {
            Range range = (Range)object;
            return this.start == range.start && this.end == range.end && this.exclusive == range.exclusive;
        }
        return false;
    }

    public final long hash() {
        return this.start << 24 ^ this.end;
    }

    public String toStr() {
        if (this.exclusive) {
            return this.start + "..<" + this.end;
        }
        return this.start + ".." + this.end;
    }

    public Type typeof() {
        return Sys.RangeType;
    }

    public final int start(int n) {
        int n2 = (int)this.start;
        if (n2 < 0) {
            n2 = n + n2;
        }
        if (n2 > n) {
            throw IndexErr.make(this);
        }
        return n2;
    }

    public final long start(long l) {
        long l2 = this.start;
        if (l2 < 0L) {
            l2 = l + l2;
        }
        if (l2 > l) {
            throw IndexErr.make(this);
        }
        return l2;
    }

    public final int end(int n) {
        int n2 = (int)this.end;
        if (n2 < 0) {
            n2 = n + n2;
        }
        if (this.exclusive) {
            --n2;
        }
        if (n2 >= n) {
            throw IndexErr.make(this);
        }
        return n2;
    }

    public final long end(long l) {
        long l2 = this.end;
        if (l2 < 0L) {
            l2 = l + l2;
        }
        if (this.exclusive) {
            --l2;
        }
        if (l2 >= l) {
            throw IndexErr.make(this);
        }
        return l2;
    }
}

