/*
 * Decompiled with CFR 0.152.
 */
package fanx.emit;

import fan.sys.Env;
import fan.sys.List;
import fan.sys.Map;
import fan.sys.Type;
import fanx.emit.AttrEmit;
import fanx.emit.Emitter;
import fanx.emit.FieldEmit;
import fanx.emit.MethodEmit;
import fanx.fcode.FAttrs;
import fanx.fcode.FConst;
import fanx.fcode.FPod;
import fanx.fcode.FTypeRef;
import fanx.serial.ObjDecoder;
import fanx.util.Box;
import fanx.util.FanUtil;
import java.util.Iterator;
import java.util.Map;

class FFacetEmit
implements FConst {
    static final Elem[] noElems = new Elem[0];
    private final Emitter emit;
    private final FPod pod;
    private final FAttrs.FFacet[] facets;
    private final int num;
    private FTypeRef curType;
    private Class curClass;

    static void emitType(Emitter emitter, FPod fPod, FAttrs fAttrs) {
        FFacetEmit fFacetEmit = new FFacetEmit(emitter, fPod, fAttrs);
        if (fFacetEmit.num == 0) {
            return;
        }
        AttrEmit attrEmit = emitter.emitAttr("RuntimeVisibleAnnotations");
        fFacetEmit.doEmit(attrEmit.info);
    }

    static void emitField(FieldEmit fieldEmit, FPod fPod, FAttrs fAttrs) {
        FFacetEmit fFacetEmit = new FFacetEmit(fieldEmit.emit, fPod, fAttrs);
        if (fFacetEmit.num == 0) {
            return;
        }
        AttrEmit attrEmit = fieldEmit.emitAttr("RuntimeVisibleAnnotations");
        fFacetEmit.doEmit(attrEmit.info);
    }

    static void emitMethod(MethodEmit methodEmit, FPod fPod, FAttrs fAttrs) {
        FFacetEmit fFacetEmit = new FFacetEmit(methodEmit.emit, fPod, fAttrs);
        if (fFacetEmit.num == 0) {
            return;
        }
        AttrEmit attrEmit = methodEmit.emitAttr("RuntimeVisibleAnnotations");
        fFacetEmit.doEmit(attrEmit.info);
    }

    private FFacetEmit(Emitter emitter, FPod fPod, FAttrs fAttrs) {
        this.emit = emitter;
        this.pod = fPod;
        this.facets = fAttrs.facets;
        this.num = this.computeNumJavaFacets();
    }

    private int computeNumJavaFacets() {
        if (this.facets == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.facets.length; ++i) {
            if (!this.pod.typeRef(this.facets[i].type).isFFI()) continue;
            ++n;
        }
        return n;
    }

    private void doEmit(Box box) {
        box.u2(this.num);
        try {
            for (int i = 0; i < this.facets.length; ++i) {
                FAttrs.FFacet fFacet = this.facets[i];
                FTypeRef fTypeRef = this.pod.typeRef(fFacet.type);
                if (!fTypeRef.isFFI()) continue;
                this.encode(box, fTypeRef, fFacet.val);
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR: Cannot emit annotations for " + this.emit.className);
            System.out.println("  Facet type: " + this.curType);
            exception.printStackTrace();
            box.len = 0;
            box.u2(0);
        }
    }

    private void encode(Box box, FTypeRef fTypeRef, String string) throws Exception {
        this.curType = fTypeRef;
        this.curClass = null;
        Elem[] elemArray = this.parseElems(string);
        int n = this.emit.cls(fTypeRef.jname());
        box.u2(n);
        box.u2(elemArray.length);
        for (int i = 0; i < elemArray.length; ++i) {
            Elem elem = elemArray[i];
            box.u2(this.emit.utf(elem.name));
            this.encodeVal(box, elem);
        }
    }

    private void encodeVal(Box box, Elem elem) throws Exception {
        Object object = elem.val;
        if (object instanceof String) {
            this.encodeStr(box, elem);
            return;
        }
        if (object instanceof Boolean) {
            this.encodeBool(box, elem);
            return;
        }
        if (object instanceof Long) {
            this.encodeInt(box, elem);
            return;
        }
        if (object instanceof Double) {
            this.encodeFloat(box, elem);
            return;
        }
        if (object instanceof Enum) {
            this.encodeEnum(box, elem);
            return;
        }
        if (object instanceof Type) {
            this.encodeType(box, elem);
            return;
        }
        if (object instanceof List) {
            this.encodeList(box, elem);
            return;
        }
        throw new RuntimeException("Unsupported annotation element type '" + this.curType + "." + elem.name + "': " + elem.val.getClass().getName());
    }

    private void encodeStr(Box box, Elem elem) {
        String string = (String)elem.val;
        box.u1(115);
        box.u2(this.emit.utf(string));
    }

    private void encodeBool(Box box, Elem elem) {
        Boolean bl = (Boolean)elem.val;
        box.u1(90);
        box.u2(this.emit.intConst(bl != false ? 1 : 0));
    }

    private void encodeInt(Box box, Elem elem) throws Exception {
        Long l = (Long)elem.val;
        Class clazz = elem.type();
        if (clazz == Integer.TYPE) {
            box.u1(73);
            box.u2(this.emit.intConst(l.intValue()));
        } else if (clazz == Short.TYPE) {
            box.u1(83);
            box.u2(this.emit.intConst(l.intValue()));
        } else if (clazz == Byte.TYPE) {
            box.u1(66);
            box.u2(this.emit.intConst(l.intValue()));
        } else {
            box.u1(74);
            box.u2(this.emit.longConst(l));
        }
    }

    private void encodeFloat(Box box, Elem elem) throws Exception {
        Double d = (Double)elem.val;
        Class clazz = elem.type();
        if (clazz == Float.TYPE) {
            box.u1(70);
            box.u2(this.emit.floatConst(Float.valueOf(d.floatValue())));
        } else {
            box.u1(68);
            box.u2(this.emit.doubleConst(d));
        }
    }

    private void encodeEnum(Box box, Elem elem) throws Exception {
        Enum enum_ = (Enum)elem.val;
        box.u1(101);
        box.u2(this.emit.utf(enum_.getClass().getName()));
        box.u2(this.emit.utf(enum_.toString()));
    }

    private void encodeType(Box box, Elem elem) throws Exception {
        Type type = (Type)elem.val;
        box.u1(99);
        box.u2(this.emit.utf(FanUtil.toJavaMemberSig(type)));
    }

    private void encodeList(Box box, Elem elem) throws Exception {
        List list = (List)elem.val;
        Class<?> clazz = elem.type().getComponentType();
        box.u1(91);
        box.u2(list.sz());
        for (int i = 0; i < list.sz(); ++i) {
            this.encodeVal(box, new Elem(elem.name, list.get(i), clazz));
        }
    }

    private Elem[] parseElems(String string) throws Exception {
        if (string.length() == 0) {
            return noElems;
        }
        Map map = (Map)ObjDecoder.decode(string);
        Elem[] elemArray = new Elem[map.sz()];
        int n = 0;
        Iterator iterator = map.pairsIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string2 = (String)entry.getKey();
            Object v = entry.getValue();
            elemArray[n++] = new Elem(string2, v);
        }
        return elemArray;
    }

    private Object parseElemVal(String string, String string2) throws Exception {
        try {
            return ObjDecoder.decode(string2);
        }
        catch (Exception exception) {
            throw new Exception("Cannot parse " + this.curType + "." + string + " = " + string2 + "\n  " + exception, exception);
        }
    }

    Class curClass() throws Exception {
        if (this.curClass == null) {
            this.curClass = Env.cur().loadJavaClass(this.curType.jname().replace("/", "."));
        }
        return this.curClass;
    }

    class Elem {
        String name;
        Object val;
        Class type;

        Elem(String string, Object object) {
            this.name = string;
            this.val = object;
        }

        Elem(String string, Object object, Class clazz) {
            this.name = string;
            this.val = object;
            this.type = clazz;
        }

        Class type() throws Exception {
            if (this.type == null) {
                this.type = FFacetEmit.this.curClass().getMethod(this.name, new Class[0]).getReturnType();
            }
            return this.type;
        }
    }
}

