/*
 * Decompiled with CFR 0.152.
 */
package fanx.fcode;

import fanx.fcode.FAttrs;
import fanx.fcode.FConst;
import fanx.fcode.FField;
import fanx.fcode.FMethod;
import fanx.fcode.FPod;
import fanx.fcode.FStore;
import java.io.IOException;

public class FType
implements FConst {
    public boolean hollow = true;
    public FPod pod;
    public int self;
    public int flags;
    public int base;
    public int[] mixins;
    public FField[] fields;
    public FMethod[] methods;
    public FAttrs attrs;

    public FType(FPod fPod) {
        this.pod = fPod;
    }

    public FType readMeta(FStore.Input input) throws IOException {
        this.self = input.u2();
        this.base = input.u2();
        this.mixins = new int[input.u2()];
        for (int i = 0; i < this.mixins.length; ++i) {
            this.mixins[i] = input.u2();
        }
        this.flags = input.u4();
        return this;
    }

    public String filename() {
        return "fcode/" + this.pod.typeRef((int)this.self).typeName + ".fcode";
    }

    public void read() throws IOException {
        this.read(this.pod.store.read(this.filename()));
    }

    public void read(FStore.Input input) throws IOException {
        int n;
        if (input == null) {
            throw new IOException("Cannot read fcode: " + this.pod.typeRef((int)this.self).signature);
        }
        if (input.fpod.fcodeVersion == null) {
            throw new IOException("FStore.Input.fcodeVersion == null");
        }
        this.fields = new FField[input.u2()];
        for (n = 0; n < this.fields.length; ++n) {
            this.fields[n] = new FField().read(input);
        }
        this.methods = new FMethod[input.u2()];
        for (n = 0; n < this.methods.length; ++n) {
            this.methods[n] = new FMethod().read(input);
        }
        this.attrs = FAttrs.read(input);
        this.hollow = false;
        input.close();
    }
}

