/*
 * Decompiled with CFR 0.152.
 */
package fanx.serial;

import fan.sys.FanStr;
import fan.sys.Field;
import fan.sys.IOErr;
import fan.sys.InStream;
import fan.sys.JavaType;
import fan.sys.List;
import fan.sys.ListType;
import fan.sys.Map;
import fan.sys.MapType;
import fan.sys.Method;
import fan.sys.Param;
import fan.sys.ParseErr;
import fan.sys.Pod;
import fan.sys.Sys;
import fan.sys.Type;
import fanx.serial.Token;
import fanx.serial.Tokenizer;
import fanx.util.OpUtil;
import java.util.HashMap;
import java.util.Map;

public class ObjDecoder {
    private static MapType defaultMapType;
    Tokenizer tokenizer;
    int curt;
    Map options;
    Using[] usings;
    int numUsings = 0;

    public static Object decode(String string) {
        return new ObjDecoder(FanStr.in(string), null).readObj();
    }

    public ObjDecoder(InStream inStream, Map map) {
        this.tokenizer = new Tokenizer(inStream);
        this.options = map;
        this.consume();
    }

    public final Object readObj() {
        this.readHeader();
        return this.readObj(null, null, true);
    }

    private void readHeader() {
        while (this.curt == 27) {
            Using using = this.readUsing();
            if (this.usings == null) {
                this.usings = new Using[8];
            }
            if (this.numUsings >= this.usings.length) {
                Using[] usingArray = new Using[this.usings.length * 2];
                System.arraycopy(this.usings, 0, usingArray, 0, this.numUsings);
                this.usings = usingArray;
            }
            this.usings[this.numUsings++] = using;
        }
    }

    private Using readUsing() {
        int n = this.tokenizer.line;
        this.consume();
        String string = this.consumeId("Expecting pod name");
        Pod pod = Pod.find(string, false);
        if (pod == null) {
            throw this.err("Unknown pod: " + string);
        }
        if (this.curt != 13) {
            this.endOfStmt(n);
            return new UsingPod(pod);
        }
        this.consume();
        String string2 = this.consumeId("Expecting type name");
        Type type = pod.type(string2, false);
        if (type == null) {
            throw this.err("Unknown type: " + string + "::" + string2);
        }
        if (this.curt == 26) {
            this.consume();
            string2 = this.consumeId("Expecting using as name");
        }
        this.endOfStmt(n);
        return new UsingType(type, string2);
    }

    private Object readObj(Field field, Type type, boolean bl) {
        Type type2;
        if (Token.isLiteral(this.curt)) {
            Object object = this.tokenizer.val;
            this.consume();
            return object;
        }
        if (this.curt == 18) {
            return this.readCollection(field, type);
        }
        int n = this.tokenizer.line;
        Type type3 = type2 = type != null ? type : this.readType();
        if (this.curt == 16) {
            return this.readSimple(n, type2);
        }
        if (this.curt == 22) {
            return this.readTypeOrSlotLiteral(n, type2);
        }
        if (this.curt == 18) {
            return this.readCollection(field, type2);
        }
        return this.readComplex(n, type2, bl);
    }

    private Object readTypeOrSlotLiteral(int n, Type type) {
        this.consume(22, "Expected '#' for type literal");
        if (this.curt == 0 && !this.isEndOfStmt(n)) {
            String string = this.consumeId("slot literal name");
            return type.slot(string);
        }
        return type;
    }

    private Object readSimple(int n, Type type) {
        this.consume(16, "Expected ( in simple");
        String string = this.consumeStr("Expected string literal for simple");
        this.consume(17, "Expected ) in simple");
        type.finish();
        Method method = type.method("fromStr", false);
        if (method == null) {
            if (type instanceof JavaType) {
                method = type.method("valueOf", false);
            }
            if (method == null) {
                throw ObjDecoder.err("Missing method: " + type.qname() + ".fromStr", n);
            }
        }
        try {
            return method.invoke(null, new Object[]{string});
        }
        catch (ParseErr parseErr) {
            throw ParseErr.make(parseErr.msg() + " [Line " + n + "]");
        }
        catch (Throwable throwable) {
            throw ParseErr.make(throwable.toString() + " [Line " + n + "]", throwable);
        }
    }

    private Object readComplex(int n, Type type, boolean bl) {
        Object object;
        Map map = new Map(Sys.FieldType, Sys.ObjType.toNullable());
        List list = new List(Sys.ObjType.toNullable());
        this.readComplexFields(type, map, list);
        Method method = type.method("make", false);
        if (method == null || !method.isPublic()) {
            throw ObjDecoder.err("Missing public constructor " + type.qname() + ".make", n);
        }
        List list2 = null;
        if (bl && this.options != null) {
            list2 = (List)this.options.get("makeArgs");
        }
        Object object2 = null;
        boolean bl2 = true;
        try {
            object = (Param)method.params().first();
            if (list2 == null && object != null && ((Param)object).type().fits(Sys.FuncType)) {
                list2 = new List(Sys.ObjType).add(Field.makeSetFunc(map));
                bl2 = false;
            }
            object2 = method.callList(list2);
        }
        catch (Throwable throwable) {
            throw ObjDecoder.err("Cannot make " + type + ": " + throwable, n, throwable);
        }
        if (bl2 && map.size() > 0L) {
            object = map.pairsIterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                this.complexSet(object2, (Field)entry.getKey(), entry.getValue(), n);
            }
        }
        if (list.size() > 0L) {
            object = type.method("add", false);
            if (object == null) {
                throw ObjDecoder.err("Method not found: " + type.qname() + ".add", n);
            }
            for (int i = 0; i < list.sz(); ++i) {
                this.complexAdd(type, object2, (Method)object, list.get(i), n);
            }
        }
        return object2;
    }

    private void readComplexFields(Type type, Map map, List list) {
        if (this.curt != 14) {
            return;
        }
        this.consume();
        while (this.curt != 15) {
            int n = this.tokenizer.line;
            boolean bl = false;
            if (this.curt == 0) {
                String string = this.consumeId("Expected field name");
                if (this.curt == 21) {
                    this.consume();
                    this.readComplexSet(type, n, string, map);
                    bl = true;
                } else {
                    this.tokenizer.undo(this.tokenizer.type, this.tokenizer.val, this.tokenizer.line);
                    this.curt = this.tokenizer.reset(0, string, n);
                }
            }
            if (!bl) {
                this.readComplexAdd(type, n, list);
            }
            if (this.curt == 11) {
                this.consume();
                continue;
            }
            this.endOfStmt(n);
        }
        this.consume(15, "Expected '}'");
    }

    void readComplexSet(Type type, int n, String string, Map map) {
        Field field = type.field(string, false);
        if (field == null) {
            throw ObjDecoder.err("Field not found: " + type.qname() + "." + string, n);
        }
        Object object = this.readObj(field, null, false);
        try {
            if (field.isConst()) {
                object = OpUtil.toImmutable(object);
            }
        }
        catch (Throwable throwable) {
            throw ObjDecoder.err("Cannot make object const for " + field.qname() + ": " + throwable, n, throwable);
        }
        map.set(field, object);
    }

    void complexSet(Object object, Field field, Object object2, int n) {
        try {
            if (field.isConst()) {
                field.set(object, OpUtil.toImmutable(object2), false);
            } else {
                field.set(object, object2);
            }
        }
        catch (Throwable throwable) {
            throw ObjDecoder.err("Cannot set field " + field.qname() + ": " + throwable, n, throwable);
        }
    }

    void readComplexAdd(Type type, int n, List list) {
        Object object = this.readObj(null, null, false);
        list.add(object);
    }

    void complexAdd(Type type, Object object, Method method, Object object2, int n) {
        try {
            method.invoke(object, new Object[]{object2});
        }
        catch (Throwable throwable) {
            throw ObjDecoder.err("Cannot call " + type.qname() + ".add: " + throwable, n, throwable);
        }
    }

    private Object readCollection(Field field, Type type) {
        this.consume(18, "Expecting '['");
        Type type2 = null;
        if (this.curt == 0 && type == null) {
            type2 = this.readType(true);
            if (this.curt == 19 && type2 instanceof MapType) {
                type = type2;
                type2 = null;
                this.consume();
                while (this.curt == 20) {
                    this.consume();
                    type = type.toListOf();
                }
                if (this.curt == 23) {
                    this.consume();
                    type = type.toNullable();
                }
                if (this.curt == 22) {
                    this.consume();
                    return type;
                }
                this.consume(18, "Expecting '['");
            }
            if (type2 != null && type2.isJava()) {
                return this.readObj(field, type2, false);
            }
        }
        if (this.curt == 11 && type2 == null) {
            this.consume();
            this.consume(19, "Expecting ']'");
            return new List(this.toListOfType(type, field, false));
        }
        if (this.curt == 12 && type2 == null) {
            this.consume();
            this.consume(19, "Expecting ']'");
            return new Map(this.toMapType(type, field, false));
        }
        Object object = this.readObj(null, type2, false);
        if (this.curt == 12) {
            return this.readMap(this.toMapType(type, field, true), object);
        }
        return this.readList(this.toListOfType(type, field, true), object);
    }

    private Object readList(Type type, Object object) {
        Object[] objectArray = new Object[8];
        int n = 0;
        objectArray[n++] = object;
        while (this.curt != 19) {
            this.consume(11, "Expected ','");
            if (this.curt == 19) break;
            if (n >= objectArray.length) {
                Object[] objectArray2 = new Object[n * 2];
                System.arraycopy(objectArray, 0, objectArray2, 0, n);
                objectArray = objectArray2;
            }
            objectArray[n++] = this.readObj(null, null, false);
        }
        this.consume(19, "Expected ']'");
        if (type == null) {
            type = Type.common(objectArray, n);
        }
        return new List(type, objectArray, n);
    }

    private Object readMap(MapType mapType, Object object) {
        Object object2;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        this.consume(12, "Expected ':'");
        hashMap.put(object, this.readObj(null, null, false));
        while (this.curt != 19) {
            this.consume(11, "Expected ','");
            if (this.curt == 19) break;
            Object object3 = this.readObj(null, null, false);
            this.consume(12, "Expected ':'");
            object2 = this.readObj(null, null, false);
            hashMap.put(object3, object2);
        }
        this.consume(19, "Expected ']'");
        if (mapType == null) {
            int n = hashMap.size();
            object2 = Type.common(hashMap.keySet().toArray(new Object[n]), n);
            Type type = Type.common(hashMap.values().toArray(new Object[n]), n);
            mapType = new MapType((Type)object2, type);
        }
        return new Map(mapType, hashMap);
    }

    private Type toListOfType(Type type, Field field, boolean bl) {
        Type type2;
        if (type != null) {
            return type;
        }
        if (field != null && (type2 = field.type().toNonNullable()) instanceof ListType) {
            return ((ListType)type2).v;
        }
        if (bl) {
            return null;
        }
        return Sys.ObjType.toNullable();
    }

    private MapType toMapType(Type type, Field field, boolean bl) {
        Type type2;
        if (type != null) {
            try {
                return (MapType)type;
            }
            catch (ClassCastException classCastException) {
                throw this.err("Invalid map type: " + type);
            }
        }
        if (field != null && (type2 = field.type().toNonNullable()) instanceof MapType) {
            return (MapType)type2;
        }
        if (bl) {
            return null;
        }
        if (defaultMapType == null) {
            defaultMapType = new MapType(Sys.ObjType, Sys.ObjType.toNullable());
        }
        return defaultMapType;
    }

    private Type readType() {
        return this.readType(false);
    }

    private Type readType(boolean bl) {
        Type type = this.readSimpleType(bl);
        if (this.curt == 23) {
            this.consume();
            type = type.toNullable();
        }
        if (this.curt == 12) {
            this.consume();
            type = new MapType(type, this.readType());
        }
        while (this.curt == 20) {
            this.consume();
            type = type.toListOf();
        }
        if (this.curt == 23) {
            this.consume();
            type = type.toNullable();
        }
        return type;
    }

    private Type readSimpleType(boolean bl) {
        Object object;
        String string;
        int n = this.tokenizer.line;
        String string2 = this.consumeId("Expected type signature");
        boolean bl2 = false;
        if (string2.equals("java") && bl) {
            bl2 = true;
            this.consume(19, "Expected ] in Java FFI [java]");
            string2 = "[java]" + this.consumeId("Expected Java FFI type name");
            while (this.curt == 9 || this.curt == 25) {
                string = Token.toString(this.curt);
                this.consume();
                string2 = string2 + string + this.consumeId("Expected Java FFI type name");
            }
        }
        if (this.curt != 13) {
            for (int i = 0; i < this.numUsings; ++i) {
                Type type = this.usings[i].resolve(string2);
                if (type == null) continue;
                return type;
            }
            throw this.err("Unresolved type name: " + string2);
        }
        this.consume(13, "Expected ::");
        string = this.consumeId("Expected type name");
        if (this.curt == 25) {
            object = Token.toString(this.curt);
            this.consume();
            string = string + (String)object + this.consumeId("Expected Java FFI type name");
        }
        if (bl2) {
            return Type.find(string2 + "::" + string);
        }
        object = Pod.find(string2, false);
        if (object == null) {
            throw ObjDecoder.err("Pod not found: " + string2, n);
        }
        Type type = ((Pod)object).type(string, false);
        if (type == null) {
            throw ObjDecoder.err("Type not found: " + string2 + "::" + string, n);
        }
        return type;
    }

    static RuntimeException err(String string, int n) {
        return ObjDecoder.err(string, n, null);
    }

    static RuntimeException err(String string, int n, Throwable throwable) {
        return IOErr.make(string + " [Line " + n + "]", throwable);
    }

    private RuntimeException err(String string) {
        return ObjDecoder.err(string, this.tokenizer.line);
    }

    private String consumeId(String string) {
        this.verify(0, string);
        String string2 = (String)this.tokenizer.val;
        this.consume();
        return string2;
    }

    private String consumeStr(String string) {
        this.verify(2, string);
        String string2 = (String)this.tokenizer.val;
        this.consume();
        return string2;
    }

    private void consume(int n, String string) {
        this.verify(n, string);
        this.consume();
    }

    private void verify(int n, String string) {
        if (this.curt != n) {
            throw this.err(string + ", not '" + Token.toString(this.curt) + "'");
        }
    }

    private void consume() {
        this.curt = this.tokenizer.next();
    }

    private boolean isEndOfStmt(int n) {
        if (this.curt == -1) {
            return true;
        }
        if (this.curt == 10) {
            return true;
        }
        return n < this.tokenizer.line;
    }

    private void endOfStmt(int n) {
        if (this.curt == -1) {
            return;
        }
        if (this.curt == 10) {
            this.consume();
            return;
        }
        if (n < this.tokenizer.line) {
            return;
        }
        if (this.curt == 15) {
            return;
        }
        throw this.err("Expected end of statement: semicolon, newline, or end of block; not '" + Token.toString(this.curt) + "'");
    }

    static class UsingType
    extends Using {
        final String name;
        final Type type;

        UsingType(Type type, String string) {
            this.type = type;
            this.name = string;
        }

        Type resolve(String string) {
            return this.name.equals(string) ? this.type : null;
        }
    }

    static class UsingPod
    extends Using {
        final Pod pod;

        UsingPod(Pod pod) {
            this.pod = pod;
        }

        Type resolve(String string) {
            return this.pod.type(string, false);
        }
    }

    static abstract class Using {
        Using() {
        }

        abstract Type resolve(String var1);
    }
}

