/*
 * Decompiled with CFR 0.152.
 */
package fanx.serial;

public class Token {
    public static final int EOF = -1;
    public static final int ID = 0;
    public static final int BOOL_LITERAL = 1;
    public static final int STR_LITERAL = 2;
    public static final int INT_LITERAL = 3;
    public static final int FLOAT_LITERAL = 4;
    public static final int DECIMAL_LITERAL = 5;
    public static final int DURATION_LITERAL = 6;
    public static final int URI_LITERAL = 7;
    public static final int NULL_LITERAL = 8;
    public static final int DOT = 9;
    public static final int SEMICOLON = 10;
    public static final int COMMA = 11;
    public static final int COLON = 12;
    public static final int DOUBLE_COLON = 13;
    public static final int LBRACE = 14;
    public static final int RBRACE = 15;
    public static final int LPAREN = 16;
    public static final int RPAREN = 17;
    public static final int LBRACKET = 18;
    public static final int RBRACKET = 19;
    public static final int LRBRACKET = 20;
    public static final int EQ = 21;
    public static final int POUND = 22;
    public static final int QUESTION = 23;
    public static final int AT = 24;
    public static final int DOLLAR = 25;
    public static final int AS = 26;
    public static final int USING = 27;
    public static final int JAVA_FFI = 28;

    public static boolean isLiteral(int n) {
        return 1 <= n && n <= 8;
    }

    public static String keyword(int n) {
        if (26 <= n && n <= 27) {
            return Token.toString(n);
        }
        return null;
    }

    public static String toString(int n) {
        switch (n) {
            case -1: {
                return "end of file";
            }
            case 0: {
                return "identifier";
            }
            case 1: {
                return "Bool literal";
            }
            case 2: {
                return "String literal";
            }
            case 3: {
                return "Int literal";
            }
            case 4: {
                return "Float literal";
            }
            case 5: {
                return "Decimal literal";
            }
            case 6: {
                return "Duration literal";
            }
            case 7: {
                return "Uri literal";
            }
            case 8: {
                return "null";
            }
            case 9: {
                return ".";
            }
            case 10: {
                return ";";
            }
            case 11: {
                return ",";
            }
            case 12: {
                return ":";
            }
            case 13: {
                return "::";
            }
            case 14: {
                return "{";
            }
            case 15: {
                return "}";
            }
            case 16: {
                return "(";
            }
            case 17: {
                return ")";
            }
            case 18: {
                return "[";
            }
            case 19: {
                return "]";
            }
            case 20: {
                return "[]";
            }
            case 21: {
                return "=";
            }
            case 22: {
                return "#";
            }
            case 23: {
                return "?";
            }
            case 24: {
                return "@";
            }
            case 25: {
                return "$";
            }
            case 26: {
                return "as";
            }
            case 27: {
                return "using";
            }
        }
        return "Token[" + n + "]";
    }
}

