/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import org.glassfish.internal.api.DelegatingClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReflectiveClassFinder
implements DelegatingClassLoader.ClassFinder {
    ClassLoader delegate;
    Method findClass;
    Method findLoadedClass;
    Method findResource;
    Method findResources;

    ReflectiveClassFinder(ClassLoader delegate) {
        this.delegate = delegate;
        Class<ClassLoader> clazz = ClassLoader.class;
        try {
            this.findClass = clazz.getDeclaredMethod("findClass", String.class);
            this.findLoadedClass = clazz.getDeclaredMethod("findLoadedClass", String.class);
            this.findResource = clazz.getDeclaredMethod("findResource", String.class);
            this.findResources = clazz.getDeclaredMethod("findResources", String.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public ClassLoader getParent() {
        return this.delegate.getParent();
    }

    public Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            Object result = this.findClass.invoke((Object)this.delegate, name);
            return (Class)result;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(e);
        }
    }

    public Class<?> findExistingClass(String name) {
        try {
            Object result = this.findLoadedClass.invoke((Object)this.delegate, name);
            return (Class)result;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(e);
        }
    }

    public URL findResource(String name) {
        try {
            Object result = this.findResource.invoke((Object)this.delegate, name);
            return (URL)result;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(e);
        }
    }

    public Enumeration<URL> findResources(String name) throws IOException {
        try {
            Object result = this.findResources.invoke((Object)this.delegate, name);
            return (Enumeration)result;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(e);
        }
    }
}

