/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.StringUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.lists.WeakValueHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DestinationUID
extends StringUID {
    static final long serialVersionUID = 3047167637056417589L;
    private static Map topics = Collections.synchronizedMap(new WeakValueHashMap("DestinationUID_topics"));
    private static Map queues = Collections.synchronizedMap(new WeakValueHashMap("DestinationUID_queues"));
    private boolean isQueue = false;
    private String name = null;
    private transient Pattern regExPattern = null;
    private static String localQueue = Globals.getBrokerResources().getString("B0043");
    private static String localTopic = Globals.getBrokerResources().getString("B0044");

    public static void clearCache() {
        queues.clear();
        topics.clear();
    }

    protected DestinationUID(String string, boolean bl) throws BrokerException {
        super(DestinationUID.getUniqueString(string, bl));
        this.name = string;
        this.isQueue = bl;
        if (DestinationUID.isWildcard(this.name)) {
            if (this.isQueue) {
                throw new BrokerException("Wildcards are not supported for queues", 415);
            }
            String string2 = DestinationUID.createRegExString(string);
            this.regExPattern = Pattern.compile(string2);
        }
    }

    public DestinationUID(String string) throws BrokerException {
        super(string);
        this.name = this.getName(string);
        this.isQueue = this.getIsQueue(string);
        if (DestinationUID.isWildcard(this.name)) {
            if (this.isQueue) {
                throw new BrokerException("Wildcards are not supported for queues", 415);
            }
            String string2 = DestinationUID.createRegExString(this.name);
            this.regExPattern = Pattern.compile(string2);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (DestinationUID.isWildcard(this.name)) {
            try {
                if (this.isQueue) {
                    throw new BrokerException("Wildcards are not supported for queues", 415);
                }
                String string = DestinationUID.createRegExString(this.name);
                this.regExPattern = Pattern.compile(string);
            }
            catch (BrokerException brokerException) {
                Globals.getLogger().log(32, "Internal Error: " + brokerException);
            }
        }
    }

    public String getDestType() {
        if (this.isQueue) {
            return localQueue;
        }
        return localTopic;
    }

    public String getLocalizedName() {
        return Globals.getBrokerResources().getString("B0045", this.name, this.getDestType());
    }

    private String getName(String string) {
        return string.substring(2);
    }

    private boolean getIsQueue(String string) {
        return string.charAt(0) == 'Q';
    }

    public static boolean isWildcard(String string) {
        return string.contains("*") || string.contains(">");
    }

    public static String createRegExString(String string) throws BrokerException {
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        stringBuffer.append('^');
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '*': {
                    boolean bl3 = false;
                    if (i != 0 && !bl) {
                        throw new BrokerException(string + "-Wildcard should be surrounded by .", 406);
                    }
                    if (i != string.length() - 1) {
                        if (string.charAt(i + 1) == '*') {
                            bl3 = true;
                            ++i;
                        }
                        if (i != string.length() - 1 && string.charAt(i + 1) != '.' && string.charAt(i + 1) != '>') {
                            throw new BrokerException(string + "-Wildcard should be surrounded by .", 406);
                        }
                    }
                    if (bl3) {
                        stringBuffer.append("[\\S]+");
                    } else {
                        stringBuffer.append("[\\p{L}\\p{Lu}\\x24\\x5f\\p{Digit}]+");
                    }
                    bl = false;
                    continue block6;
                }
                case '$': {
                    stringBuffer.append("\\x24");
                    continue block6;
                }
                case '>': {
                    if (bl) {
                        throw new BrokerException(string + "-Wildcard should never be preceded by .", 406);
                    }
                    bl2 = true;
                    if (i > 0 && string.charAt(i - 1) == '*') {
                        stringBuffer.append("\\.[\\S]*");
                    } else {
                        stringBuffer.append("(\\.|$|^)[\\S]*");
                    }
                    bl = false;
                    continue block6;
                }
                case '.': {
                    if (i == 0) {
                        throw new BrokerException(string + "-Bad wildcard, name starts with .", 406);
                    }
                    if (i == string.length() - 1) {
                        throw new BrokerException(string + "-Bad wildcard, name ends with .", 406);
                    }
                    if (bl) {
                        throw new BrokerException(string + "-Bad wildcard, name was ..", 406);
                    }
                    bl = true;
                    stringBuffer.append("\\.");
                    continue block6;
                }
                default: {
                    bl = false;
                    stringBuffer.append(c);
                }
            }
        }
        if (!bl2) {
            stringBuffer.append('$');
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public boolean isQueue() {
        return this.isQueue;
    }

    public static DestinationUID getUID(String string, int n) throws BrokerException {
        return DestinationUID.getUID(string, DestType.isQueue((int)n));
    }

    public boolean isWildcard() {
        return this.regExPattern != null;
    }

    public static boolean match(DestinationUID destinationUID, DestinationUID destinationUID2) throws IllegalArgumentException {
        if (destinationUID.regExPattern != null && destinationUID2.regExPattern != null) {
            throw new IllegalArgumentException("Can not compare two wildcards: " + destinationUID + " -> " + destinationUID2);
        }
        if (destinationUID.regExPattern == null && destinationUID2.regExPattern == null) {
            return destinationUID.equals(destinationUID2);
        }
        if (destinationUID.isQueue() != destinationUID2.isQueue()) {
            return false;
        }
        Pattern pattern = destinationUID.regExPattern;
        String string = destinationUID2.getName();
        if (pattern == null) {
            string = destinationUID.getName();
            pattern = destinationUID2.regExPattern;
        }
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public static DestinationUID getUID(String string, boolean bl) throws BrokerException {
        DestinationUID destinationUID = null;
        if (bl) {
            destinationUID = (DestinationUID)queues.get(string);
            if (destinationUID == null) {
                destinationUID = new DestinationUID(string, bl);
                queues.put(string, destinationUID);
            }
        } else {
            destinationUID = (DestinationUID)topics.get(string);
            if (destinationUID == null) {
                destinationUID = new DestinationUID(string, bl);
                topics.put(string, destinationUID);
            }
        }
        return destinationUID;
    }

    public static void clearUID(DestinationUID destinationUID) {
        if (destinationUID.isQueue()) {
            queues.remove(destinationUID.getName());
        } else {
            topics.remove(destinationUID.getName());
        }
    }

    public String toString() {
        return super.toString();
    }

    public String getLongString() {
        if (this.isQueue) {
            return "queue:" + this.name;
        }
        return "topic:" + this.name;
    }

    public static final String getUniqueString(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("Q:");
        } else {
            stringBuffer.append("T:");
        }
        stringBuffer.append(string);
        if (stringBuffer.indexOf("/") != -1) {
            for (int i = 0; i < stringBuffer.length(); ++i) {
                char c = stringBuffer.charAt(i);
                if (c != '/') continue;
                stringBuffer.setCharAt(i, '_');
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            Matcher matcher;
            Pattern pattern;
            String string;
            try {
                string = DestinationUID.createRegExString("stock.*");
                System.out.println("Checking: stock.* : " + string);
                pattern = Pattern.compile(string);
                matcher = pattern.matcher("stock.my$bank");
                if (matcher.matches()) {
                    System.out.println("Matched(1) : stock.my$bank");
                } else {
                    System.out.println("Bummer(1) : stock.my$bank");
                }
                string = DestinationUID.createRegExString("*.my$bank");
                System.out.println("Checking: *.my$bank : " + string);
                pattern = Pattern.compile(string);
                matcher = pattern.matcher("stock.my$bank");
                if (matcher.matches()) {
                    System.out.println("Matched(2) : stock.my$bank");
                } else {
                    System.out.println("Bummer(2) : stock.my$bank");
                }
                System.exit(0);
            }
            catch (BrokerException brokerException) {
                brokerException.printStackTrace();
                System.exit(-1);
            }
            try {
                System.out.println("Checking: sun.*.com :" + DestinationUID.createRegExString("sun.*.com"));
            }
            catch (BrokerException brokerException) {
                brokerException.printStackTrace();
                System.exit(-1);
            }
            try {
                System.out.println("Checking: sun.*.com>:" + DestinationUID.createRegExString("sun.*.com>"));
            }
            catch (BrokerException brokerException) {
                brokerException.printStackTrace();
                System.exit(-1);
            }
            try {
                System.out.println("Checking: sun>:" + DestinationUID.createRegExString("sun>"));
            }
            catch (BrokerException brokerException) {
                brokerException.printStackTrace();
                System.exit(-1);
            }
            try {
                System.out.println("Checking:  sun.**.bar:" + DestinationUID.createRegExString("sun.**.bar"));
            }
            catch (BrokerException brokerException) {
                brokerException.printStackTrace();
                System.exit(-1);
            }
            try {
                System.out.println("Checking: sun..*:" + DestinationUID.createRegExString("sun..*"));
                System.out.println("Match sun..* was valid");
                System.exit(-1);
            }
            catch (BrokerException brokerException) {
                System.out.println(brokerException);
            }
            try {
                System.out.println("Checking: sun.>.com:" + DestinationUID.createRegExString("sun.>.com"));
                System.out.println("Match sun.>.com was valid");
                System.exit(-1);
            }
            catch (BrokerException brokerException) {
                System.out.println(brokerException);
            }
            try {
                System.out.println("Checking: sun.>:" + DestinationUID.createRegExString("sun.>"));
                System.out.println("Match sun.> was valid");
                System.exit(-1);
            }
            catch (BrokerException brokerException) {
                System.out.println(brokerException);
            }
            try {
                System.out.println("Checking: sun.*.com.:" + DestinationUID.createRegExString("sun.*.com."));
                System.out.println("Match sun.*.com. was valid");
                System.exit(-1);
            }
            catch (BrokerException brokerException) {
                System.out.println(brokerException);
            }
            System.out.println("Testing sun> format");
            string = DestinationUID.createRegExString("sun>");
            pattern = Pattern.compile(string);
            matcher = pattern.matcher("sun");
            boolean bl = matcher.matches();
            if (!bl) {
                System.out.println("bummer: " + string + " : sun");
            } else {
                System.out.println("Cool " + string + " matches sun");
            }
            matcher = pattern.matcher("sun.com");
            bl = matcher.matches();
            if (!bl) {
                System.out.println("bummer: " + string + " : sun.com");
            } else {
                System.out.println("Cool " + string + " matches sun.com");
            }
            matcher = pattern.matcher("suncom");
            bl = matcher.matches();
            if (bl) {
                System.out.println("bummer: " + string + " : suncom");
            } else {
                System.out.println("Cool " + string + " doesnt match suncom");
            }
            string = DestinationUID.createRegExString("sun.*.com>");
            pattern = Pattern.compile(string);
            matcher = pattern.matcher("sun.ibm.com");
            bl = matcher.matches();
            if (!bl) {
                System.out.println("bummer: " + string + " : sun.ibm.com");
            } else {
                System.out.println("Cool " + string + " matches sun.ibm.com");
            }
            string = DestinationUID.createRegExString(">");
            pattern = Pattern.compile(string);
            matcher = pattern.matcher("sun");
            bl = matcher.matches();
            if (!bl) {
                System.out.println("bummer: " + string + " : sun");
            } else {
                System.out.println("Cool " + string + " matches sun");
            }
            string = DestinationUID.createRegExString("**>");
            pattern = Pattern.compile(string);
            matcher = pattern.matcher("sun");
            bl = matcher.matches();
            if (bl) {
                System.out.println("bummer: " + string + " : sun");
            } else {
                System.out.println("Cool " + string + " does not match sun");
            }
            string = DestinationUID.createRegExString("**>");
            pattern = Pattern.compile(string);
            matcher = pattern.matcher("sun.com");
            bl = matcher.matches();
            if (!bl) {
                System.out.println("bummer: " + string + " : sun.com");
            } else {
                System.out.println("Cool " + string + " matches sun.com");
            }
            string = DestinationUID.createRegExString("finance>stock");
            pattern = Pattern.compile(string);
            matcher = pattern.matcher("finance.stock");
            bl = matcher.matches();
            if (!bl) {
                System.out.println("bummer: " + string + " : finance.stock");
            } else {
                System.out.println("Cool " + string + " matches finance.stock");
            }
        }
        catch (BrokerException brokerException) {
            brokerException.printStackTrace();
        }
    }
}

