/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.net.IPAddress;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class GetConnectionsHandler
extends AdminCmdHandler {
    private static boolean DEBUG = GetConnectionsHandler.getDEBUG();

    public GetConnectionsHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        Packet packet2;
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + "GetConnections: " + hashtable);
        }
        ConnectionManager connectionManager = Globals.getConnectionManager();
        String string = (String)hashtable.get("JMQServiceName");
        Long l = (Long)hashtable.get("JMQConnectionID");
        int n = 200;
        String string2 = null;
        Vector<Hashtable> vector = new Vector<Hashtable>();
        Service service = null;
        if (string != null && (service = Globals.getServiceManager().getService(string)) == null) {
            n = 404;
            string2 = this.rb.getString("B4057", string);
        }
        if (n == 200) {
            packet2 = null;
            IMQConnection iMQConnection22 = null;
            if (l != null) {
                iMQConnection22 = (IMQConnection)connectionManager.getConnection(new ConnectionUID(l));
                if (iMQConnection22 != null) {
                    if (DEBUG) {
                        iMQConnection22.dump();
                    }
                    packet2 = iMQConnection22.getConnectionInfo();
                    vector.add(GetConnectionsHandler.getConnectionInfoHashtable((ConnectionInfo)packet2));
                } else {
                    n = 404;
                    string2 = this.rb.getString("B3130", String.valueOf(l));
                }
            } else {
                List list = connectionManager.getConnectionList(service);
                for (IMQConnection iMQConnection22 : list) {
                    packet2 = iMQConnection22.getConnectionInfo();
                    vector.add(GetConnectionsHandler.getConnectionInfoHashtable((ConnectionInfo)packet2));
                }
            }
        }
        packet2 = new Packet(iMQConnection.useDirectBuffers());
        packet2.setPacketType(5);
        GetConnectionsHandler.setProperties(packet2, 17, n, string2);
        this.setBodyObject(packet2, vector);
        this.parent.sendReply(iMQConnection, packet, packet2);
        return true;
    }

    public static Hashtable getConnectionInfoHashtable(ConnectionInfo connectionInfo) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("cxnid", new Long(connectionInfo.uuid));
        if (connectionInfo.clientID == null) {
            connectionInfo.clientID = "";
        }
        hashtable.put("clientid", connectionInfo.clientID);
        if (connectionInfo.remoteIP != null) {
            hashtable.put("host", String.valueOf(IPAddress.rawIPToString((byte[])connectionInfo.remoteIP, (boolean)true, (boolean)true)));
        }
        hashtable.put("port", new Integer(connectionInfo.remPort));
        hashtable.put("user", connectionInfo.user);
        hashtable.put("nproducers", new Integer(connectionInfo.nproducers));
        hashtable.put("nconsumers", new Integer(connectionInfo.nconsumers));
        hashtable.put("clientplatform", connectionInfo.userAgent);
        hashtable.put("service", connectionInfo.service);
        return hashtable;
    }
}

