/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class MessageManagerMonitor
extends MQMBeanReadOnly {
    private static MBeanParameterInfo[] getMessageInfoSignature;
    private static MBeanOperationInfo[] ops;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector getMessageInfo(String string, String string2, String string3, Long l, Long l2, Boolean bl) throws MBeanException {
        Vector<HashMap> vector = new Vector<HashMap>();
        try {
            HashMap hashMap = new HashMap();
            if (string2 == null || string == null) {
                throw new BrokerException("Destination name and type not specified");
            }
            Destination destination = Destination.getDestination(string2, string.equals("q"));
            if (destination == null) {
                throw new BrokerException(rb.getString("B4017", string2));
            }
            if (bl == null) {
                bl = Boolean.FALSE;
            }
            if (string3 != null) {
                destination.load();
                SysMessageID sysMessageID = SysMessageID.get((String)string3);
                PacketReference packetReference = this.getPacketReference(sysMessageID);
                if (packetReference == null) throw new BrokerException("Could not locate message " + string3 + " in destination " + string2);
                HashMap hashMap2 = this.constructMessageInfo(sysMessageID, bl, hashMap);
                vector.add(hashMap2);
                return vector;
            } else {
                SysMessageID[] sysMessageIDArray = destination.getSysMessageIDs(l, l2);
                for (int i = 0; i < sysMessageIDArray.length; ++i) {
                    HashMap hashMap3 = this.constructMessageInfo(sysMessageIDArray[i], bl, hashMap);
                    vector.add(hashMap3);
                }
            }
            return vector;
        }
        catch (Exception exception) {
            this.handleOperationException("getMessageInfo", exception);
        }
        return vector;
    }

    public String getMBeanName() {
        return "MessageManagerMonitor";
    }

    public String getMBeanDescription() {
        return "Monitoring MBean for Message Manager";
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return null;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return null;
    }

    private HashMap constructMessageInfo(SysMessageID sysMessageID, boolean bl, HashMap hashMap) throws BrokerException {
        Hashtable hashtable;
        Object object;
        Object object2;
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        PacketReference packetReference = this.getPacketReference(sysMessageID);
        Packet packet = packetReference.getPacket();
        HashMap hashMap3 = packetReference.getHeaders();
        Destination destination = packetReference.getDestination();
        String string = packet.getCorrelationID();
        String string2 = "q";
        byte[] byArray = null;
        hashMap2.put("CorrelationID", string);
        if (string != null) {
            try {
                byArray = string.getBytes("UTF8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        hashMap2.put("CorrelationIDAsBytes", byArray);
        hashMap2.put("DeliveryMode", packet.getPersistent() ? new Integer(2) : new Integer(1));
        hashMap2.put("DestinationName", packet.getDestination());
        string2 = packet.getIsQueue() ? "q" : "t";
        hashMap2.put("DestinationType", string2);
        hashMap2.put("Expiration", new Long(packet.getExpiration()));
        hashMap2.put("MessageID", hashMap3.get("JMSMessageID"));
        hashMap2.put("Priority", new Integer(packet.getPriority()));
        hashMap2.put("Redelivered", new Boolean(packet.getRedelivered()));
        String string3 = packet.getReplyTo();
        if (string3 != null) {
            boolean bl2 = false;
            boolean bl3 = true;
            if (hashMap != null && (object2 = (Boolean)hashMap.get(string3)) != null) {
                bl3 = (Boolean)object2;
                bl2 = true;
            }
            if (!bl2) {
                try {
                    object = Destination.findDestination(string3, true);
                    object2 = Destination.findDestination(string3, false);
                    if (object != null && object2 != null) {
                        String string4 = "Cannot determine type of ReplyTo destination. There is a topic and queue with the name: " + string3;
                        throw new BrokerException(string4);
                    }
                    if (object != null) {
                        bl2 = true;
                        bl3 = true;
                    } else if (object2 != null) {
                        bl2 = true;
                        bl3 = false;
                    }
                    if (bl2) {
                        hashMap.put(string3, new Boolean(bl3));
                    }
                }
                catch (Exception exception) {
                    String string5 = "Caught exception while determining ReplyTo destination type";
                    throw new BrokerException(string5);
                }
            }
            hashMap2.put("ReplyToDestinationName", string3);
            if (bl2) {
                string2 = bl3 ? "q" : "t";
                hashMap2.put("ReplyToDestinationType", string2);
            }
        }
        hashMap2.put("Timestamp", new Long(packet.getTimestamp()));
        hashMap2.put("Type", packet.getMessageType());
        try {
            hashtable = packetReference.getProperties();
        }
        catch (Exception exception) {
            hashtable = null;
        }
        hashMap2.put("MessageProperties", hashtable);
        int n = packetReference.getPacket().getPacketType();
        hashMap2.put("MessageBodyType", new Integer(n));
        if (bl) {
            object2 = packetReference.getPacket().getMessageBodyByteBuffer();
            object = null;
            if (((ByteBuffer)object2).hasArray()) {
                object = ((ByteBuffer)object2).array();
            }
            switch (n) {
                case 1: {
                    try {
                        String string6 = new String((byte[])object, "UTF8");
                        hashMap2.put("MessageBody", string6);
                        break;
                    }
                    catch (Exception exception) {
                        String string7 = "Caught exception while creating text message body";
                        throw new BrokerException(string7);
                    }
                }
                case 2: {
                    hashMap2.put("MessageBody", object);
                    break;
                }
                case 3: {
                    try {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                        HashMap hashMap4 = (HashMap)objectInputStream.readObject();
                        hashMap2.put("MessageBody", hashMap4);
                        break;
                    }
                    catch (Exception exception) {
                        String string8 = "Caught exception while creating map message body";
                        throw new BrokerException(string8);
                    }
                }
                case 4: {
                    hashMap2.put("MessageBody", object);
                    break;
                }
                case 5: {
                    try {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                        Serializable serializable = (Serializable)objectInputStream.readObject();
                        hashMap2.put("MessageBody", serializable);
                        break;
                    }
                    catch (Exception exception) {
                        String string9 = "Caught exception while creating object message body";
                        throw new BrokerException(string9);
                    }
                }
                default: {
                    String string10 = "Unsupported message type for GET_MESSAGES handler: " + n;
                    throw new BrokerException(string10);
                }
            }
        }
        return hashMap2;
    }

    private PacketReference getPacketReference(SysMessageID sysMessageID) {
        return Destination.get(sysMessageID);
    }

    static {
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[6];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("destinationType", String.class.getName(), mbr.getString("MB1187"));
        mBeanParameterInfoArray[1] = new MBeanParameterInfo("destinationName", String.class.getName(), mbr.getString("MB1188"));
        mBeanParameterInfoArray[2] = new MBeanParameterInfo("messageID", String.class.getName(), "Message ID");
        mBeanParameterInfoArray[3] = new MBeanParameterInfo("startMsgIndex", Long.class.getName(), "Start Message Index");
        mBeanParameterInfoArray[4] = new MBeanParameterInfo("maxNumMsgsRetrieved", Long.class.getName(), "Maximum Number of Messages Retrieved");
        mBeanParameterInfoArray[5] = new MBeanParameterInfo("getBody", Boolean.class.getName(), "Get Body");
        getMessageInfoSignature = mBeanParameterInfoArray;
        ops = new MBeanOperationInfo[]{new MBeanOperationInfo("getMessageInfo", "Get information on messages from a destination", getMessageInfoSignature, Vector.class.getName(), 0)};
    }
}

