/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.io.MetricCounters;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.util.ConnectionUtil;
import com.sun.messaging.jmq.jmsserver.management.util.ServiceUtil;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import com.sun.messaging.jms.management.server.ConnectionNotification;
import com.sun.messaging.jms.management.server.MQObjectName;
import com.sun.messaging.jms.management.server.ServiceNotification;
import com.sun.messaging.jms.management.server.ServiceState;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;

public class ServiceMonitor
extends MQMBeanReadOnly {
    private String service;
    private static MBeanAttributeInfo[] attrs;
    private static MBeanOperationInfo[] ops;
    private static String[] cxnNotificationTypes;
    private static String[] svcNotificationTypes;
    private static MBeanNotificationInfo[] notifs;
    private long numConnectionsOpened = 0L;
    private long numConnectionsRejected = 0L;

    public ServiceMonitor(String string) {
        this.service = string;
    }

    public String getName() {
        return this.service;
    }

    public Integer getState() {
        ServiceInfo serviceInfo = ServiceUtil.getServiceInfo(this.service);
        return new Integer(ServiceUtil.toExternalServiceState(serviceInfo.state));
    }

    public String getStateLabel() {
        ServiceInfo serviceInfo = ServiceUtil.getServiceInfo(this.service);
        return ServiceState.toString(ServiceUtil.toExternalServiceState(serviceInfo.state));
    }

    public Integer getPort() {
        ServiceInfo serviceInfo = ServiceUtil.getServiceInfo(this.service);
        return new Integer(serviceInfo.port);
    }

    public Integer getNumActiveThreads() {
        ServiceInfo serviceInfo = ServiceUtil.getServiceInfo(this.service);
        MetricCounters metricCounters = serviceInfo.metrics;
        if (metricCounters != null) {
            return new Integer(metricCounters.threadsActive);
        }
        return new Integer(-1);
    }

    public Integer getNumConnections() {
        ServiceInfo serviceInfo = ServiceUtil.getServiceInfo(this.service);
        return new Integer(serviceInfo.nConnections);
    }

    public long getNumConnectionsOpened() {
        return this.numConnectionsOpened;
    }

    public long getNumConnectionsRejected() {
        return this.numConnectionsRejected;
    }

    public Long getNumMsgsIn() {
        ServiceInfo serviceInfo = ServiceUtil.getServiceInfo(this.service);
        MetricCounters metricCounters = serviceInfo.metrics;
        if (metricCounters != null) {
            return new Long(metricCounters.messagesIn);
        }
        return new Long(-1L);
    }

    public Long getNumMsgsOut() {
        ServiceInfo serviceInfo = ServiceUtil.getServiceInfo(this.service);
        MetricCounters metricCounters = serviceInfo.metrics;
        if (metricCounters != null) {
            return new Long(metricCounters.messagesOut);
        }
        return new Long(-1L);
    }

    public Long getMsgBytesIn() {
        ServiceInfo serviceInfo = ServiceUtil.getServiceInfo(this.service);
        MetricCounters metricCounters = serviceInfo.metrics;
        if (metricCounters != null) {
            return new Long(metricCounters.messageBytesIn);
        }
        return new Long(-1L);
    }

    public Long getMsgBytesOut() {
        ServiceInfo serviceInfo = ServiceUtil.getServiceInfo(this.service);
        MetricCounters metricCounters = serviceInfo.metrics;
        if (metricCounters != null) {
            return new Long(metricCounters.messageBytesOut);
        }
        return new Long(-1L);
    }

    public Long getNumPktsIn() {
        ServiceInfo serviceInfo = ServiceUtil.getServiceInfo(this.service);
        MetricCounters metricCounters = serviceInfo.metrics;
        if (metricCounters != null) {
            return new Long(metricCounters.packetsIn);
        }
        return new Long(-1L);
    }

    public Long getNumPktsOut() {
        ServiceInfo serviceInfo = ServiceUtil.getServiceInfo(this.service);
        MetricCounters metricCounters = serviceInfo.metrics;
        if (metricCounters != null) {
            return new Long(metricCounters.packetsOut);
        }
        return new Long(-1L);
    }

    public Long getPktBytesIn() {
        ServiceInfo serviceInfo = ServiceUtil.getServiceInfo(this.service);
        MetricCounters metricCounters = serviceInfo.metrics;
        if (metricCounters != null) {
            return new Long(metricCounters.packetBytesIn);
        }
        return new Long(-1L);
    }

    public Long getPktBytesOut() {
        ServiceInfo serviceInfo = ServiceUtil.getServiceInfo(this.service);
        MetricCounters metricCounters = serviceInfo.metrics;
        if (metricCounters != null) {
            return new Long(metricCounters.packetBytesOut);
        }
        return new Long(-1L);
    }

    public Integer getNumConsumers() {
        List list = ServiceUtil.getConsumerIDs(this.service);
        if (list == null) {
            return new Integer(0);
        }
        return new Integer(list.size());
    }

    public String[] getConsumerIDs() throws MBeanException {
        List list = ServiceUtil.getConsumerIDs(this.service);
        if (list == null || list.size() == 0) {
            return null;
        }
        String[] stringArray = new String[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ConsumerUID consumerUID = (ConsumerUID)iterator.next();
            long l = consumerUID.longValue();
            try {
                String string;
                stringArray[n] = string = Long.toString(l);
            }
            catch (Exception exception) {
                this.handleOperationException("getConsumerIDs", exception);
            }
            ++n;
        }
        return stringArray;
    }

    public Integer getNumProducers() {
        List list = ServiceUtil.getProducerIDs(this.service);
        if (list == null) {
            return new Integer(0);
        }
        return new Integer(list.size());
    }

    public String[] getProducerIDs() throws MBeanException {
        List list = ServiceUtil.getProducerIDs(this.service);
        if (list == null || list.size() == 0) {
            return null;
        }
        String[] stringArray = new String[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ProducerUID producerUID = (ProducerUID)((Object)iterator.next());
            long l = producerUID.longValue();
            try {
                String string;
                stringArray[n] = string = Long.toString(l);
            }
            catch (Exception exception) {
                this.handleOperationException("getProducerIDs", exception);
            }
            ++n;
        }
        return stringArray;
    }

    public ObjectName[] getConnections() throws MBeanException {
        List list = ConnectionUtil.getConnectionInfoList(this.service);
        if (list.size() == 0) {
            return null;
        }
        ObjectName[] objectNameArray = new ObjectName[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ConnectionInfo connectionInfo = (ConnectionInfo)iterator.next();
            try {
                ObjectName objectName = MQObjectName.createConnectionMonitor(Long.toString(connectionInfo.uuid));
                objectNameArray[n++] = objectName;
            }
            catch (Exception exception) {
                this.handleOperationException("getConnections", exception);
            }
        }
        return objectNameArray;
    }

    public void resetMetrics() {
        this.numConnectionsOpened = 0L;
        this.numConnectionsRejected = 0L;
    }

    public String getMBeanName() {
        return "ServiceMonitor";
    }

    public String getMBeanDescription() {
        return mbr.getString("MB1219");
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    public void notifyConnectionClose(long l) {
        ConnectionNotification connectionNotification = new ConnectionNotification("mq.connection.close", this, this.sequenceNumber++);
        connectionNotification.setConnectionID(Long.toString(l));
        this.sendNotification(connectionNotification);
    }

    public void notifyConnectionOpen(long l) {
        ConnectionNotification connectionNotification = new ConnectionNotification("mq.connection.open", this, this.sequenceNumber++);
        connectionNotification.setConnectionID(Long.toString(l));
        this.sendNotification(connectionNotification);
        ++this.numConnectionsOpened;
    }

    public void notifyConnectionReject(String string, String string2, String string3) {
        ConnectionNotification connectionNotification = new ConnectionNotification("mq.connection.reject", this, this.sequenceNumber++);
        connectionNotification.setServiceName(string);
        connectionNotification.setUserName(string2);
        connectionNotification.setRemoteHost(string3);
        this.sendNotification(connectionNotification);
        ++this.numConnectionsRejected;
    }

    public void notifyServicePause() {
        ServiceNotification serviceNotification = new ServiceNotification("mq.service.pause", this, this.sequenceNumber++);
        serviceNotification.setServiceName(this.getName());
        this.sendNotification(serviceNotification);
    }

    public void notifyServiceResume() {
        ServiceNotification serviceNotification = new ServiceNotification("mq.service.resume", this, this.sequenceNumber++);
        serviceNotification.setServiceName(this.getName());
        this.sendNotification(serviceNotification);
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[18];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("MsgBytesIn", Long.class.getName(), mbr.getString("MB1198"), true, false, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("MsgBytesOut", Long.class.getName(), mbr.getString("MB1199"), true, false, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("Name", String.class.getName(), mbr.getString("MB1195"), true, false, false);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("NumActiveThreads", Integer.class.getName(), mbr.getString("MB1200"), true, false, false);
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("NumConnections", Integer.class.getName(), mbr.getString("MB1201"), true, false, false);
        mBeanAttributeInfoArray[5] = new MBeanAttributeInfo("NumConnectionsOpened", Long.class.getName(), mbr.getString("MB1202"), true, false, false);
        mBeanAttributeInfoArray[6] = new MBeanAttributeInfo("NumConnectionsRejected", Long.class.getName(), mbr.getString("MB1203"), true, false, false);
        mBeanAttributeInfoArray[7] = new MBeanAttributeInfo("NumConsumers", Integer.class.getName(), mbr.getString("MB1204"), true, false, false);
        mBeanAttributeInfoArray[8] = new MBeanAttributeInfo("NumMsgsIn", Long.class.getName(), mbr.getString("MB1205"), true, false, false);
        mBeanAttributeInfoArray[9] = new MBeanAttributeInfo("NumMsgsOut", Long.class.getName(), mbr.getString("MB1206"), true, false, false);
        mBeanAttributeInfoArray[10] = new MBeanAttributeInfo("NumPktsIn", Long.class.getName(), mbr.getString("MB1207"), true, false, false);
        mBeanAttributeInfoArray[11] = new MBeanAttributeInfo("NumPktsOut", Long.class.getName(), mbr.getString("MB1208"), true, false, false);
        mBeanAttributeInfoArray[12] = new MBeanAttributeInfo("NumProducers", Integer.class.getName(), mbr.getString("MB1209"), true, false, false);
        mBeanAttributeInfoArray[13] = new MBeanAttributeInfo("Port", Integer.class.getName(), mbr.getString("MB1221"), true, false, false);
        mBeanAttributeInfoArray[14] = new MBeanAttributeInfo("PktBytesIn", Long.class.getName(), mbr.getString("MB1210"), true, false, false);
        mBeanAttributeInfoArray[15] = new MBeanAttributeInfo("PktBytesOut", Long.class.getName(), mbr.getString("MB1211"), true, false, false);
        mBeanAttributeInfoArray[16] = new MBeanAttributeInfo("State", Integer.class.getName(), mbr.getString("MB1212"), true, false, false);
        mBeanAttributeInfoArray[17] = new MBeanAttributeInfo("StateLabel", String.class.getName(), mbr.getString("MB1213"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[3];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getConnections", mbr.getString("MB1216"), null, ObjectName[].class.getName(), 0);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("getConsumerIDs", mbr.getString("MB1217"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("getProducerIDs", mbr.getString("MB1218"), null, String[].class.getName(), 0);
        ops = mBeanOperationInfoArray;
        cxnNotificationTypes = new String[]{"mq.connection.open", "mq.connection.close", "mq.connection.reject"};
        svcNotificationTypes = new String[]{"mq.service.pause", "mq.service.resume"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[2];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(cxnNotificationTypes, ConnectionNotification.class.getName(), mbr.getString("MB1067"));
        mBeanNotificationInfoArray[1] = new MBeanNotificationInfo(svcNotificationTypes, ServiceNotification.class.getName(), mbr.getString("MB1220"));
        notifs = mBeanNotificationInfoArray;
    }
}

