/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.MsgRemovalEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.MsgStore;
import com.sun.messaging.jmq.jmsserver.persist.file.NonTransactedMsgAckEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.NonTransactedMsgEvent;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionLogReplayer {
    public static final Logger logger = Globals.getLogger();
    MsgStore msgStore;

    public TransactionLogReplayer(MsgStore msgStore) {
        this.msgStore = msgStore;
    }

    String getPrefix() {
        return "TransactionLogReplayer: " + Thread.currentThread().getName();
    }

    void replayTransactionWork(TransactionWork transactionWork, TransactionUID transactionUID, Set set) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " replayTransactionWork for tid " + transactionUID + " txnWork=" + transactionWork;
            logger.log(4, string);
        }
        this.replaySentMessages(transactionWork.getSentMessages(), set);
        this.replayAcknowledgedMessages(transactionWork.getMessageAcknowledgments(), set);
    }

    private void replaySentMessages(List<TransactionWorkMessage> list, Set set) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, this.getPrefix() + " replaySentMessages");
        }
        for (int i = 0; i < list.size(); ++i) {
            TransactionWorkMessage transactionWorkMessage = list.get(i);
            this.replaySentMessage(transactionWorkMessage, set);
        }
    }

    private void replaySentMessage(TransactionWorkMessage transactionWorkMessage, Set set) throws IOException, BrokerException {
        boolean bl;
        Object object;
        Packet packet = transactionWorkMessage.getMessage();
        SysMessageID sysMessageID = packet.getSysMessageID();
        if (Store.getDEBUG()) {
            object = this.getPrefix() + " replaying sent message: " + transactionWorkMessage + " dest= " + packet.getDestination();
            logger.log(4, (String)object);
        }
        object = Destination.getDestination(packet.getDestination(), packet.getIsQueue() ? 1 : 2, true, true);
        DestinationUID destinationUID = ((Destination)object).getDestinationUID();
        if (!set.contains(object)) {
            ((Destination)object).load();
            set.add(object);
        }
        if (bl = this.msgStore.containsMessage(destinationUID, sysMessageID)) {
            Object object2;
            if (Store.getDEBUG()) {
                object2 = this.getPrefix() + " stored message exists " + sysMessageID;
                logger.log(4, (String)object2);
            }
            object2 = this.msgStore.getInterestStates(destinationUID, sysMessageID);
            boolean bl2 = this.compareStoredConsumers(sysMessageID, transactionWorkMessage.getStoredInterests(), (HashMap)object2);
            if (!bl2) {
                logger.log(64, "B1276", (Object)sysMessageID);
                this.msgStore.removeMessage(destinationUID, sysMessageID, false);
                this.rerouteMessage(packet, transactionWorkMessage.getStoredInterests(), sysMessageID, (Destination)object);
            }
        } else {
            if (Store.getDEBUG()) {
                String string = this.getPrefix() + " stored message does not exist " + sysMessageID;
                logger.log(4, string);
            }
            this.rerouteMessage(packet, transactionWorkMessage.getStoredInterests(), sysMessageID, (Destination)object);
        }
    }

    private void rerouteMessage(Packet packet, ConsumerUID[] consumerUIDArray, SysMessageID sysMessageID, Destination destination) throws BrokerException {
        logger.log(64, "B1277", (Object)sysMessageID);
        PacketReference packetReference = PacketReference.createReference(packet, destination.getDestinationUID(), null);
        if (packetReference.isExpired()) {
            String string = "not routing expired message on transaction log replay " + sysMessageID;
            logger.log(8, string);
            return;
        }
        try {
            destination.queueMessage(packetReference, false);
            destination.routeNewMessage(packetReference);
        }
        catch (SelectorFormatException selectorFormatException) {
            throw new BrokerException(Globals.getBrokerResources().getString("B3227", sysMessageID), selectorFormatException);
        }
    }

    private boolean compareStoredConsumers(SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, HashMap hashMap) {
        Object object2;
        boolean bl = true;
        int n = 0;
        if (consumerUIDArray != null) {
            n = consumerUIDArray.length;
        }
        if (n < hashMap.size()) {
            bl = false;
            logger.log(32, "Mismatch in number of logged and stored consumers for " + sysMessageID + " logged=" + n + " stored=" + hashMap.size());
        }
        if (n > hashMap.size()) {
            bl = false;
            logger.log(16, "Mismatch in number of logged and stored consumers for " + sysMessageID + " logged=" + n + " stored=" + hashMap.size());
        }
        HashSet<ConsumerUID> hashSet = new HashSet<ConsumerUID>(n);
        for (int i = 0; i < n; ++i) {
            object2 = consumerUIDArray[i];
            hashSet.add((ConsumerUID)object2);
            if (hashMap.containsKey(object2)) continue;
            logger.log(16, "stored interest does not contain logged interest. sysid= " + sysMessageID + " ConsumerUID=" + object2);
            bl = false;
        }
        for (Object object2 : hashMap.keySet()) {
            if (hashSet.contains(object2)) continue;
            logger.log(32, "logged interests does not contain stored interst. sysid= " + sysMessageID + " consumerid=" + object2);
            bl = false;
        }
        if (bl && Store.getDEBUG()) {
            object2 = this.getPrefix() + " stored consumers match. numConsumers= " + n;
            logger.log(4, (String)object2);
        }
        return bl;
    }

    public void replayNonTxnMsgAck(NonTransactedMsgAckEvent nonTransactedMsgAckEvent, Set set) throws IOException, BrokerException {
        this.replayAcknowledgedMessage(nonTransactedMsgAckEvent.messageAck, set);
    }

    public void replayNonTxnMsg(NonTransactedMsgEvent nonTransactedMsgEvent, Set set) throws IOException, BrokerException {
        this.replaySentMessage(nonTransactedMsgEvent.message, set);
    }

    private void replayAcknowledgedMessages(List<TransactionWorkMessageAck> list, Set set) throws IOException, BrokerException {
        for (int i = 0; i < list.size(); ++i) {
            TransactionWorkMessageAck transactionWorkMessageAck = list.get(i);
            this.replayAcknowledgedMessage(transactionWorkMessageAck, set);
        }
    }

    private void replayAcknowledgedMessage(TransactionWorkMessageAck transactionWorkMessageAck, Set set) throws IOException, BrokerException {
        Object object;
        DestinationUID destinationUID = transactionWorkMessageAck.getDestUID();
        SysMessageID sysMessageID = transactionWorkMessageAck.getSysMessageID();
        ConsumerUID consumerUID = transactionWorkMessageAck.getConsumerID();
        if (Store.getDEBUG()) {
            object = this.getPrefix() + " replaying acknowledged message " + transactionWorkMessageAck;
            logger.log(4, (String)object);
        }
        if (!set.contains(object = Destination.getDestination(destinationUID.getName(), destinationUID.isQueue() ? 1 : 2, true, true))) {
            ((Destination)object).load();
            set.add(object);
        }
        if (this.msgStore.containsMessage(destinationUID, sysMessageID)) {
            logger.log(64, "B1278", (Object)consumerUID, (Object)sysMessageID);
            if (((Destination)object).isQueue() && consumerUID.longValue() != 0L) {
                this.msgStore.updateInterestState(destinationUID, sysMessageID, PacketReference.getQueueUID(), 2, false);
            } else {
                this.msgStore.updateInterestState(destinationUID, sysMessageID, consumerUID, 2, false);
            }
            this.acknowledgeOnReplay((Destination)object, sysMessageID, consumerUID);
        } else {
            logger.log(64, "B1279", (Object)consumerUID, (Object)sysMessageID);
        }
    }

    public void replayMessageRemoval(MsgRemovalEvent msgRemovalEvent, Set set) throws IOException, BrokerException {
        DestinationUID destinationUID = msgRemovalEvent.destUID;
        SysMessageID sysMessageID = msgRemovalEvent.sysMessageID;
        Destination destination = Destination.getDestination(destinationUID.getName(), destinationUID.isQueue() ? 1 : 2, true, true);
        if (!set.contains(destination)) {
            destination.load();
            set.add(destination);
        }
        logger.log(64, "Removing message " + sysMessageID);
        if (this.msgStore.containsMessage(destinationUID, sysMessageID)) {
            this.msgStore.removeMessage(destinationUID, sysMessageID, false);
        }
    }

    public void acknowledgeOnReplay(Destination destination, SysMessageID sysMessageID, ConsumerUID consumerUID) throws IOException, BrokerException {
        String string;
        PacketReference packetReference = destination.getMessage(sysMessageID);
        boolean bl = false;
        if (packetReference != null) {
            bl = packetReference.acknowledgedOnReplay(consumerUID, consumerUID);
            if (Store.getDEBUG()) {
                string = this.getPrefix() + " acknowledgedOnReplay  " + sysMessageID + " allAcked =" + bl;
                logger.log(4, string);
            }
        } else if (Store.getDEBUG()) {
            string = this.getPrefix() + " did not find packet in destination " + sysMessageID;
            logger.log(4, string);
        }
        if (bl) {
            destination.removeMessage(sysMessageID, RemoveReason.ACKNOWLEDGED);
            if (Store.getDEBUG()) {
                string = this.getPrefix() + " removed message from destination " + sysMessageID;
                logger.log(4, string);
            }
        }
    }

    public void replayRemoteAcks(TransactionAcknowledgement[] transactionAcknowledgementArray, DestinationUID[] destinationUIDArray, TransactionUID transactionUID, HashSet hashSet) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " replayRemoteAcks ";
            logger.log(4, string);
        }
        for (int i = 0; i < transactionAcknowledgementArray.length; ++i) {
            TransactionAcknowledgement transactionAcknowledgement = transactionAcknowledgementArray[i];
            DestinationUID destinationUID = destinationUIDArray[i];
            SysMessageID sysMessageID = transactionAcknowledgement.getSysMessageID();
            ConsumerUID consumerUID = transactionAcknowledgement.getStoredConsumerUID();
            int n = destinationUID.isQueue() ? 1 : 2;
            Destination destination = Destination.getDestination(destinationUID.getName(), n, true, true);
            destination.load();
            PacketReference packetReference = destination.getMessage(sysMessageID);
            if (packetReference == null) {
                String string = " could not find packet for replayed message ack " + transactionAcknowledgement + " dest " + destinationUID + " in transaction " + transactionUID;
                logger.log(16, string);
                continue;
            }
            if (this.msgStore.containsMessage(destinationUID, sysMessageID)) {
                logger.log(64, "B1278", (Object)consumerUID, (Object)sysMessageID);
                if (destination.isQueue() && consumerUID.longValue() != 0L) {
                    this.msgStore.updateInterestState(destinationUID, sysMessageID, PacketReference.getQueueUID(), 2, false);
                } else {
                    this.msgStore.updateInterestState(destinationUID, sysMessageID, consumerUID, 2, false);
                }
                this.acknowledgeOnReplay(destination, sysMessageID, consumerUID);
                continue;
            }
            logger.log(64, "B1279", (Object)consumerUID, (Object)sysMessageID);
        }
    }
}

