/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.group;

import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPServiceFactory;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.service.imq.group.GroupService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import java.io.IOException;

public class GroupServiceFactory
extends IMQIPServiceFactory {
    private static boolean SHARED_ALLOWED = false;

    public Service createService(String string, int n) throws BrokerException {
        if (!SHARED_ALLOWED) {
            Globals.getLogger().log(32, "B3123", (Object)Globals.getBrokerResources().getString("B0035"));
            Broker.getBroker().exit(1, Globals.getBrokerResources().getKString("B3123", Globals.getBrokerResources().getString("B0035")), BrokerEvent.Type.FATAL_ERROR);
        }
        if (!Globals.getConfig().getBooleanProperty("imq." + string + ".override")) {
            Globals.getConfig().put("imq." + string + ".tcp.blocking", "false");
            Globals.getConfig().put("imq." + string + ".tcp.useChannels", "true");
        } else {
            Globals.getLogger().log(4, "Overriding shared properties for instance " + string);
        }
        return super.createService(string, n);
    }

    protected IMQService createService(String string, Protocol protocol, PacketRouter packetRouter, int n, int n2, int n3) throws IOException {
        protocol.configureBlocking(false);
        return new GroupService(string, protocol, n, packetRouter, n2, n3);
    }

    static {
        try {
            LicenseBase licenseBase = Globals.getCurrentLicense(null);
            SHARED_ALLOWED = licenseBase.getBooleanProperty("imq.enable_sharedpool", false);
        }
        catch (BrokerException brokerException) {
            SHARED_ALLOWED = false;
        }
    }
}

