/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.activation;

import com.sun.corba.ee.impl.activation.CommandHandler;
import com.sun.corba.ee.impl.activation.ListServers;
import com.sun.corba.ee.impl.orbutil.CorbaResourceUtil;
import com.sun.corba.ee.spi.activation.Activator;
import com.sun.corba.ee.spi.activation.ActivatorHelper;
import com.sun.corba.ee.spi.activation.Repository;
import com.sun.corba.ee.spi.activation.RepositoryHelper;
import com.sun.corba.ee.spi.activation.RepositoryPackage.ServerDef;
import com.sun.corba.ee.spi.activation.ServerNotRegistered;
import java.io.PrintStream;
import org.omg.CORBA.ORB;

class ListActiveServers
implements CommandHandler {
    ListActiveServers() {
    }

    @Override
    public String getCommandName() {
        return "listactive";
    }

    @Override
    public void printCommandHelp(PrintStream out, boolean helpType) {
        if (!helpType) {
            out.println(CorbaResourceUtil.getText("servertool.listactive"));
        } else {
            out.println(CorbaResourceUtil.getText("servertool.listactive1"));
        }
    }

    @Override
    public boolean processCommand(String[] cmdArgs, ORB orb, PrintStream out) {
        try {
            Repository repository = RepositoryHelper.narrow(orb.resolve_initial_references("ServerRepository"));
            Activator activator = ActivatorHelper.narrow(orb.resolve_initial_references("ServerActivator"));
            int[] servers = activator.getActiveServers();
            out.println(CorbaResourceUtil.getText("servertool.list2"));
            ListServers.sortServers(servers);
            for (int i = 0; i < servers.length; ++i) {
                try {
                    ServerDef serverDef = repository.getServer(servers[i]);
                    out.println("\t   " + servers[i] + "\t\t" + serverDef.serverName + "\t\t" + serverDef.applicationName);
                    continue;
                }
                catch (ServerNotRegistered e) {
                    // empty catch block
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }
}

