/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.corba.TypeCodeImpl;
import com.sun.corba.ee.impl.encoding.BufferManagerWrite;
import com.sun.corba.ee.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.encoding.CDROutputStreamBase;
import com.sun.corba.ee.impl.encoding.CodeSetConversion;
import com.sun.corba.ee.impl.javax.rmi.CORBA.EnumDesc;
import com.sun.corba.ee.impl.javax.rmi.CORBA.ProxyDesc;
import com.sun.corba.ee.impl.javax.rmi.CORBA.Util;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.CacheTable;
import com.sun.corba.ee.impl.orbutil.ClassInfoCache;
import com.sun.corba.ee.impl.orbutil.DprintUtil;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.orbutil.RepositoryIdFactory;
import com.sun.corba.ee.impl.orbutil.RepositoryIdStrings;
import com.sun.corba.ee.impl.orbutil.RepositoryIdUtility;
import com.sun.corba.ee.impl.orbutil.newtimer.generated.TimingPoints;
import com.sun.corba.ee.impl.util.Utility;
import com.sun.corba.ee.spi.btrace.CDR;
import com.sun.corba.ee.spi.btrace.CDRWrite;
import com.sun.corba.ee.spi.btrace.PrimitiveWrite;
import com.sun.corba.ee.spi.btrace.Traceable;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.IORFactories;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.orb.ClassCodeBaseHandler;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBVersionFactory;
import com.sun.corba.ee.spi.protocol.CorbaMessageMediator;
import com.sun.corba.ee.spi.transport.ByteBufferPool;
import com.sun.org.omg.CORBA.portable.ValueHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.rmi.CORBA.ValueHandler;
import javax.rmi.CORBA.ValueHandlerMultiFormat;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.CustomMarshal;
import org.omg.CORBA.DataOutputStream;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;

@Traceable
public class CDROutputStream_1_0
extends CDROutputStreamBase {
    private static final int INDIRECTION_TAG = -1;
    protected final DprintUtil dputil = new DprintUtil(this);
    protected boolean littleEndian;
    protected BufferManagerWrite bufferManagerWrite;
    ByteBufferWithInfo bbwi;
    protected ORB orb;
    protected TimingPoints tp;
    protected ORBUtilSystemException wrapper;
    protected int blockSizeIndex = -1;
    protected int blockSizePosition = 0;
    protected byte streamFormatVersion;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final String kWriteMethod = "write";
    Map<String, Map<String, EnumDesc>> enumCache = null;
    private Map<String, Integer> codebaseCache = null;
    private CacheTable<java.lang.Object> valueCache = null;
    private CacheTable<String> repositoryIdCache = null;
    private int end_flag = 0;
    private int chunkedValueNestingLevel = 0;
    private boolean mustChunk = false;
    protected boolean inBlock = false;
    private int end_flag_position = 0;
    private int end_flag_index = 0;
    private ValueHandler valueHandler = null;
    private RepositoryIdUtility repIdUtil;
    private RepositoryIdStrings repIdStrs;
    private CodeSetConversion.CTBConverter charConverter;
    private CodeSetConversion.CTBConverter wcharConverter;
    private static final String _id = "IDL:omg.org/CORBA/DataOutputStream:1.0";
    private static final String[] _ids = new String[]{"IDL:omg.org/CORBA/DataOutputStream:1.0"};

    @Override
    public void init(org.omg.CORBA.ORB orb, boolean littleEndian, BufferManagerWrite bufferManager, byte streamFormatVersion, boolean usePooledByteBuffers) {
        this.orb = (ORB)orb;
        this.tp = (TimingPoints)this.orb.getTimerManager().points();
        this.wrapper = this.orb.getLogWrapperTable().get_RPC_ENCODING_ORBUtil();
        this.littleEndian = littleEndian;
        this.bufferManagerWrite = bufferManager;
        this.bbwi = new ByteBufferWithInfo(orb, bufferManager, usePooledByteBuffers);
        this.streamFormatVersion = streamFormatVersion;
        this.createRepositoryIdHandlers();
    }

    public void init(org.omg.CORBA.ORB orb, boolean littleEndian, BufferManagerWrite bufferManager, byte streamFormatVersion) {
        this.init(orb, littleEndian, bufferManager, streamFormatVersion, true);
    }

    private final void createRepositoryIdHandlers() {
        this.repIdUtil = RepositoryIdFactory.getRepIdUtility();
        this.repIdStrs = RepositoryIdFactory.getRepIdStringsFactory();
    }

    @Override
    public BufferManagerWrite getBufferManager() {
        return this.bufferManagerWrite;
    }

    @Override
    public byte[] toByteArray() {
        byte[] it = new byte[this.bbwi.position()];
        this.bbwi.getByteBuffer().position(0);
        this.bbwi.getByteBuffer().get(it);
        return it;
    }

    @Override
    public GIOPVersion getGIOPVersion() {
        return GIOPVersion.V1_0;
    }

    @Override
    void setHeaderPadding(boolean headerPadding) {
        throw this.wrapper.giopVersionError();
    }

    @CDR
    protected void handleSpecialChunkBegin(int requiredSize) {
    }

    @CDR
    protected void handleSpecialChunkEnd() {
    }

    protected final int computeAlignment4() {
        int incr = this.bbwi.position() & 3;
        if (incr != 0) {
            return 4 - incr;
        }
        return 0;
    }

    protected final int computeAlignment(int align) {
        int incr;
        if (align > 1 && (incr = this.bbwi.position() & align - 1) != 0) {
            return align - incr;
        }
        return 0;
    }

    protected void alignAndReserve44() {
        this.bbwi.position(this.bbwi.position() + this.computeAlignment4());
        if (this.bbwi.position() + 4 > this.bbwi.getLength()) {
            this.grow44();
        }
    }

    protected void alignAndReserve(int align, int n) {
        this.bbwi.position(this.bbwi.position() + this.computeAlignment(align));
        if (this.bbwi.position() + n > this.bbwi.getLength()) {
            this.grow(align, n);
        }
    }

    protected void grow44() {
        this.bbwi.setNumberOfBytesNeeded(4);
        this.bufferManagerWrite.overflow(this.bbwi);
    }

    protected void grow(int align, int n) {
        this.bbwi.setNumberOfBytesNeeded(n);
        this.bufferManagerWrite.overflow(this.bbwi);
    }

    @Override
    public final void putEndian() throws SystemException {
        this.write_boolean(this.littleEndian);
    }

    public final boolean littleEndian() {
        return this.littleEndian;
    }

    @Override
    void freeInternalCaches() {
        if (this.codebaseCache != null) {
            this.codebaseCache.clear();
        }
        this.freeValueCache();
        if (this.repositoryIdCache != null) {
            this.repositoryIdCache.done();
        }
    }

    public final void write_longdouble(double x) {
        throw this.wrapper.longDoubleNotImplemented(CompletionStatus.COMPLETED_MAYBE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PrimitiveWrite
    public void write_octet(byte x) {
        if (this.orb.cdrDebugFlag) {
            this.dputil.enter("write_octet", x);
        }
        try {
            this.alignAndReserve(1, 1);
            this.bbwi.getByteBuffer().put(x);
        }
        finally {
            if (this.orb.cdrDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    @Override
    public final void write_boolean(boolean x) {
        this.write_octet(x ? (byte)1 : 0);
    }

    @Override
    public void write_char(char x) {
        CodeSetConversion.CTBConverter converter = this.getCharConverter();
        converter.convert(x);
        if (converter.getNumBytes() > 1) {
            throw this.wrapper.invalidSingleCharCtb(CompletionStatus.COMPLETED_MAYBE);
        }
        this.write_octet(converter.getBytes()[0]);
    }

    private final void writeLittleEndianWchar(char x) {
        this.bbwi.getByteBuffer().put((byte)(x & 0xFF));
        this.bbwi.getByteBuffer().put((byte)(x >>> 8 & 0xFF));
    }

    private final void writeBigEndianWchar(char x) {
        this.bbwi.getByteBuffer().put((byte)(x >>> 8 & 0xFF));
        this.bbwi.getByteBuffer().put((byte)(x & 0xFF));
    }

    private final void writeLittleEndianShort(short x) {
        this.bbwi.getByteBuffer().put((byte)(x & 0xFF));
        this.bbwi.getByteBuffer().put((byte)(x >>> 8 & 0xFF));
    }

    private final void writeBigEndianShort(short x) {
        this.bbwi.getByteBuffer().put((byte)(x >>> 8 & 0xFF));
        this.bbwi.getByteBuffer().put((byte)(x & 0xFF));
    }

    private final void writeLittleEndianLong(int x) {
        this.bbwi.getByteBuffer().put((byte)(x & 0xFF));
        this.bbwi.getByteBuffer().put((byte)(x >>> 8 & 0xFF));
        this.bbwi.getByteBuffer().put((byte)(x >>> 16 & 0xFF));
        this.bbwi.getByteBuffer().put((byte)(x >>> 24 & 0xFF));
    }

    private final void writeBigEndianLong(int x) {
        this.bbwi.getByteBuffer().put((byte)(x >>> 24 & 0xFF));
        this.bbwi.getByteBuffer().put((byte)(x >>> 16 & 0xFF));
        this.bbwi.getByteBuffer().put((byte)(x >>> 8 & 0xFF));
        this.bbwi.getByteBuffer().put((byte)(x & 0xFF));
    }

    private final void writeLittleEndianLongLong(long x) {
        this.bbwi.getByteBuffer().put((byte)(x & 0xFFL));
        this.bbwi.getByteBuffer().put((byte)(x >>> 8 & 0xFFL));
        this.bbwi.getByteBuffer().put((byte)(x >>> 16 & 0xFFL));
        this.bbwi.getByteBuffer().put((byte)(x >>> 24 & 0xFFL));
        this.bbwi.getByteBuffer().put((byte)(x >>> 32 & 0xFFL));
        this.bbwi.getByteBuffer().put((byte)(x >>> 40 & 0xFFL));
        this.bbwi.getByteBuffer().put((byte)(x >>> 48 & 0xFFL));
        this.bbwi.getByteBuffer().put((byte)(x >>> 56 & 0xFFL));
    }

    private final void writeBigEndianLongLong(long x) {
        this.bbwi.getByteBuffer().put((byte)(x >>> 56 & 0xFFL));
        this.bbwi.getByteBuffer().put((byte)(x >>> 48 & 0xFFL));
        this.bbwi.getByteBuffer().put((byte)(x >>> 40 & 0xFFL));
        this.bbwi.getByteBuffer().put((byte)(x >>> 32 & 0xFFL));
        this.bbwi.getByteBuffer().put((byte)(x >>> 24 & 0xFFL));
        this.bbwi.getByteBuffer().put((byte)(x >>> 16 & 0xFFL));
        this.bbwi.getByteBuffer().put((byte)(x >>> 8 & 0xFFL));
        this.bbwi.getByteBuffer().put((byte)(x & 0xFFL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PrimitiveWrite
    public void write_wchar(char x) {
        if (this.orb.cdrDebugFlag) {
            this.dputil.enter("write_wchar", Character.valueOf(x));
        }
        try {
            if (ORBUtility.isForeignORB(this.orb)) {
                throw this.wrapper.wcharDataInGiop10(CompletionStatus.COMPLETED_MAYBE);
            }
            this.alignAndReserve(2, 2);
            if (this.littleEndian) {
                this.writeLittleEndianWchar(x);
            } else {
                this.writeBigEndianWchar(x);
            }
        }
        finally {
            if (this.orb.cdrDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PrimitiveWrite
    public void write_short(short x) {
        if (this.orb.cdrDebugFlag) {
            this.dputil.enter("write_short", x);
        }
        try {
            this.alignAndReserve(2, 2);
            if (this.littleEndian) {
                this.writeLittleEndianShort(x);
            } else {
                this.writeBigEndianShort(x);
            }
        }
        finally {
            if (this.orb.cdrDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    @Override
    public final void write_ushort(short x) {
        this.write_short(x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PrimitiveWrite
    public void write_long(int x) {
        if (this.orb.cdrDebugFlag) {
            this.dputil.enter("write_long", x);
        }
        try {
            this.alignAndReserve44();
            if (this.littleEndian) {
                this.writeLittleEndianLong(x);
            } else {
                this.writeBigEndianLong(x);
            }
        }
        finally {
            if (this.orb.cdrDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    @Override
    public final void write_ulong(int x) {
        this.write_long(x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PrimitiveWrite
    public void write_longlong(long x) {
        if (this.orb.cdrDebugFlag) {
            this.dputil.enter("write_longlong", x);
        }
        try {
            this.alignAndReserve(8, 8);
            if (this.littleEndian) {
                this.writeLittleEndianLongLong(x);
            } else {
                this.writeBigEndianLongLong(x);
            }
        }
        finally {
            if (this.orb.cdrDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    @Override
    public final void write_ulonglong(long x) {
        this.write_longlong(x);
    }

    @Override
    public final void write_float(float x) {
        this.write_long(Float.floatToIntBits(x));
    }

    @Override
    public final void write_double(double x) {
        this.write_longlong(Double.doubleToLongBits(x));
    }

    @Override
    public void write_string(String value) {
        this.writeString(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PrimitiveWrite
    protected int writeString(String value) {
        if (this.orb.cdrDebugFlag) {
            this.dputil.enter("writeString", value);
        }
        try {
            if (value == null) {
                throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
            }
            CodeSetConversion.CTBConverter converter = this.getCharConverter();
            converter.convert(value);
            int len = converter.getNumBytes() + 1;
            this.handleSpecialChunkBegin(this.computeAlignment(4) + 4 + len);
            this.write_long(len);
            int indirection = this.get_offset() - 4;
            this.internalWriteOctetArray(converter.getBytes(), 0, converter.getNumBytes());
            this.write_octet((byte)0);
            this.handleSpecialChunkEnd();
            int n = indirection;
            return n;
        }
        finally {
            if (this.orb.cdrDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    @Override
    public void write_wstring(String value) {
        if (value == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        if (ORBUtility.isForeignORB(this.orb)) {
            throw this.wrapper.wcharDataInGiop10(CompletionStatus.COMPLETED_MAYBE);
        }
        int len = value.length() + 1;
        this.handleSpecialChunkBegin(4 + len * 2 + this.computeAlignment(4));
        this.write_long(len);
        for (int i = 0; i < len - 1; ++i) {
            this.write_wchar(value.charAt(i));
        }
        this.write_short((short)0);
        this.handleSpecialChunkEnd();
    }

    void internalWriteOctetArray(byte[] value, int offset, int length) {
        int bytes;
        boolean align = true;
        for (int n = offset; n < length + offset; n += bytes) {
            int avail;
            int wanted;
            if (this.bbwi.position() + 1 > this.bbwi.getLength() || align) {
                align = false;
                this.alignAndReserve(1, 1);
            }
            bytes = (wanted = length + offset - n) < (avail = this.bbwi.getLength() - this.bbwi.position()) ? wanted : avail;
            this.bbwi.getByteBuffer().put(value, n, bytes);
            this.bbwi.position(this.bbwi.getByteBuffer().position());
        }
    }

    @Override
    public final void write_octet_array(byte[] b, int offset, int length) {
        if (b == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(length);
        this.internalWriteOctetArray(b, offset, length);
        this.handleSpecialChunkEnd();
    }

    @Override
    public void write_Principal(Principal p) {
        this.write_long(p.name().length);
        this.write_octet_array(p.name(), 0, p.name().length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CDR
    @CDRWrite
    public void write_any(Any any) {
        this.tp.enter_writeAny();
        if (this.orb.cdrDebugFlag) {
            this.dputil.enter("write_Any", "any", any);
        }
        try {
            if (any == null) {
                throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
            }
            this.write_TypeCode(any.type());
            any.write_value((org.omg.CORBA.portable.OutputStream)this.parent);
        }
        finally {
            this.tp.exit_writeAny();
            if (this.orb.cdrDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CDR
    @CDRWrite
    public void write_TypeCode(TypeCode tc) {
        if (this.orb.cdrDebugFlag) {
            this.dputil.enter("write_TypeCode", "tc", tc);
        }
        try {
            if (tc == null) {
                throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
            }
            TypeCodeImpl tci = tc instanceof TypeCodeImpl ? (TypeCodeImpl)tc : new TypeCodeImpl(this.orb, tc);
            tci.write_value(this.parent);
        }
        finally {
            if (this.orb.cdrDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    @Override
    @CDR
    @CDRWrite
    public void write_Object(Object ref) {
        if (ref == null) {
            IOR nullIOR = IORFactories.makeIOR(this.orb);
            nullIOR.write(this.parent);
            return;
        }
        if (ref instanceof LocalObject) {
            throw this.wrapper.writeLocalObject(CompletionStatus.COMPLETED_MAYBE);
        }
        IOR ior = this.orb.getIOR(ref, true);
        ior.write(this.parent);
    }

    @Override
    @CDR
    @CDRWrite
    public void write_abstract_interface(java.lang.Object obj) {
        boolean corbaObject = false;
        Object theObject = null;
        if (obj != null && obj instanceof Object) {
            theObject = (Object)obj;
            corbaObject = true;
        }
        this.write_boolean(corbaObject);
        if (corbaObject) {
            this.write_Object(theObject);
        } else {
            try {
                this.write_value((Serializable)obj);
            }
            catch (ClassCastException cce) {
                if (obj instanceof Serializable) {
                    throw cce;
                }
                ORBUtility.throwNotSerializableForCorba(obj.getClass().getName());
            }
        }
    }

    @Override
    @CDR
    @CDRWrite
    public void write_value(Serializable object, Class clz) {
        this.write_value(object);
    }

    @CDR
    @CDRWrite
    private void startValueChunk(boolean useChunking) {
        if (useChunking) {
            this.start_block();
            --this.chunkedValueNestingLevel;
        }
        --this.end_flag;
    }

    @CDR
    @CDRWrite
    private void endValueChunk(boolean useChunking) {
        if (useChunking) {
            this.end_block();
        }
        this.writeEndTag(useChunking);
    }

    private void writeWStringValue(String string) {
        int indirection = this.writeValueTag(this.mustChunk, true, null);
        this.write_repositoryId(this.repIdStrs.getWStringValueRepId());
        this.updateIndirectionTable(indirection, string);
        this.startValueChunk(this.mustChunk);
        this.write_wstring(string);
        this.endValueChunk(this.mustChunk);
    }

    private String getCodebase(Class cls) {
        String result;
        ClassCodeBaseHandler ccbh = this.orb.classCodeBaseHandler();
        if (ccbh != null && (result = ccbh.getCodeBase(cls)) != null) {
            return result;
        }
        return Util.getInstance().getCodebase(cls);
    }

    @CDR
    @CDRWrite
    private void writeArray(Serializable array, Class clazz) {
        if (this.valueHandler == null) {
            this.valueHandler = ORBUtility.createValueHandler(this.orb);
        }
        int indirection = this.writeValueTag(this.mustChunk, true, this.getCodebase(clazz));
        this.write_repositoryId(this.repIdStrs.createSequenceRepID(clazz));
        this.updateIndirectionTable(indirection, array);
        this.callWriteValue((org.omg.CORBA.portable.OutputStream)this.parent, array, this.streamFormatVersion);
    }

    @CDR
    @CDRWrite
    private void writeValueBase(ValueBase object, Class clazz) {
        this.mustChunk = true;
        int indirection = this.writeValueTag(true, true, this.getCodebase(clazz));
        String repId = object._truncatable_ids()[0];
        this.write_repositoryId(repId);
        this.updateIndirectionTable(indirection, object);
        this.startValueChunk(true);
        this.writeIDLValue((Serializable)object, repId);
        this.endValueChunk(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CDR
    @CDRWrite
    private void writeRMIIIOPValueType(Serializable object, Class clazz, ClassInfoCache.ClassInfo cinfo) {
        if (this.valueHandler == null) {
            this.valueHandler = ORBUtility.createValueHandler(this.orb);
        }
        Serializable key = object;
        this.tp.enter_callValueHandlerWriteReplaceFromCDRStream();
        try {
            object = this.valueHandler.writeReplace(key);
        }
        finally {
            this.tp.exit_callValueHandlerWriteReplaceFromCDRStream();
        }
        if (object != key) {
            if (object == null) {
                this.write_long(0);
                return;
            }
            if (this.writeIndirectionIfPossible(object)) {
                return;
            }
            clazz = object.getClass();
        }
        this.tp.enter_callValueHandlerIsCustomMarshaledFromCDRStream();
        try {
            this.mustChunk = this.valueHandler.isCustomMarshaled(clazz);
        }
        finally {
            this.tp.exit_callValueHandlerIsCustomMarshaledFromCDRStream();
        }
        int indirection = this.writeValueTag(this.mustChunk, true, this.getCodebase(clazz));
        this.write_repositoryId(this.repIdStrs.createForJavaType(clazz, cinfo));
        this.updateIndirectionTable(indirection, key);
        if (object != key) {
            this.updateIndirectionTable(indirection, object);
        }
        this.callWriteValue((org.omg.CORBA.portable.OutputStream)this.parent, object, this.streamFormatVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CDR
    @CDRWrite
    private void callWriteValue(org.omg.CORBA.portable.OutputStream parent, Serializable object, byte streamFormatVersion) {
        boolean currentMustChunk = this.mustChunk;
        this.startValueChunk(currentMustChunk);
        this.tp.enter_callValueHandlerWriteValueFromCDRStream();
        try {
            if (this.valueHandler instanceof ValueHandlerMultiFormat) {
                ValueHandlerMultiFormat vh = (ValueHandlerMultiFormat)this.valueHandler;
                vh.writeValue(parent, object, streamFormatVersion);
            } else {
                this.valueHandler.writeValue(parent, object);
            }
        }
        finally {
            this.tp.exit_callValueHandlerWriteValueFromCDRStream();
        }
        this.endValueChunk(currentMustChunk);
    }

    private EnumDesc getEnumDesc(String className, String enumValue) {
        EnumDesc result = null;
        Map<String, EnumDesc> map = null;
        if (this.enumCache == null) {
            this.enumCache = new HashMap<String, Map<String, EnumDesc>>();
        } else {
            map = this.enumCache.get(className);
        }
        if (map == null) {
            map = new HashMap<String, EnumDesc>();
            this.enumCache.put(className, map);
        } else {
            result = map.get(enumValue);
        }
        if (result == null) {
            result = new EnumDesc();
            result.className = className;
            result.value = enumValue;
            map.put(enumValue, result);
        }
        return result;
    }

    @Override
    @CDR
    @CDRWrite
    public void write_value(Serializable object, String repository_id) {
        if (object == null) {
            this.write_long(0);
            return;
        }
        Class<?> clazz = object.getClass();
        ClassInfoCache.ClassInfo cinfo = ClassInfoCache.get(clazz);
        if (cinfo.isEnum()) {
            String enumValue = ((Enum)((java.lang.Object)object)).name();
            if (this.orb.getORBData().useEnumDesc()) {
                EnumDesc desc = this.getEnumDesc(clazz.getName(), enumValue);
                this.write_value((Serializable)desc, (String)null);
                return;
            }
            int indirection = this.writeValueTag(false, true, this.getCodebase(clazz));
            this.updateIndirectionTable(indirection, object);
            this.write_repositoryId(this.repIdStrs.createForJavaType(clazz, cinfo));
            this.write_value((Serializable)((java.lang.Object)enumValue));
        }
        if (cinfo.isProxyClass()) {
            Class<?>[] ifaces = clazz.getInterfaces();
            ProxyDesc pd = new ProxyDesc();
            pd.interfaces = new String[ifaces.length];
            for (int i = 0; i < ifaces.length; ++i) {
                pd.interfaces[i] = ifaces[i].getName();
            }
            pd.handler = Proxy.getInvocationHandler(object);
            pd.codebase = this.getCodebase(object.getClass());
            this.write_value((Serializable)pd, (String)null);
            return;
        }
        if (this.writeIndirectionIfPossible(object)) {
            return;
        }
        boolean oldMustChunk = this.mustChunk;
        if (this.inBlock) {
            this.end_block();
        }
        if (cinfo.isArray()) {
            this.writeArray(object, clazz);
        } else if (cinfo.isAValueBase(clazz)) {
            this.writeValueBase((ValueBase)object, clazz);
        } else if (cinfo.isAIDLEntity(clazz) && !cinfo.isACORBAObject(clazz)) {
            this.writeIDLEntity((IDLEntity)object);
        } else if (cinfo.isAString(clazz)) {
            this.writeWStringValue((String)((java.lang.Object)object));
        } else if (cinfo.isAClass(clazz)) {
            ClassInfoCache.ClassInfo lcinfo = ClassInfoCache.get((Class)object);
            this.writeClass(repository_id, (Class)object, lcinfo);
        } else {
            this.writeRMIIIOPValueType(object, clazz, cinfo);
        }
        this.mustChunk = oldMustChunk;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    @Override
    public void write_value(Serializable object) {
        this.write_value(object, (String)null);
    }

    @Override
    @CDR
    @CDRWrite
    public void write_value(Serializable object, BoxedValueHelper factory) {
        if (object == null) {
            this.write_long(0);
            return;
        }
        if (this.writeIndirectionIfPossible(object)) {
            return;
        }
        boolean oldMustChunk = this.mustChunk;
        boolean isCustom = false;
        if (factory instanceof ValueHelper) {
            short modifier;
            try {
                modifier = ((ValueHelper)factory).get_type().type_modifier();
            }
            catch (BadKind ex) {
                modifier = 0;
            }
            if (object instanceof CustomMarshal && modifier == 1) {
                isCustom = true;
                this.mustChunk = true;
            }
            if (modifier == 3) {
                this.mustChunk = true;
            }
        }
        if (this.mustChunk && this.inBlock) {
            this.end_block();
        }
        int indirection = this.writeValueTag(this.mustChunk, this.orb.getORBData().useRepId(), this.getCodebase(object.getClass()));
        if (this.orb.getORBData().useRepId()) {
            this.write_repositoryId(factory.get_id());
        }
        this.updateIndirectionTable(indirection, object);
        boolean currentMustChunk = this.mustChunk;
        this.startValueChunk(currentMustChunk);
        if (this.mustChunk && isCustom) {
            ((CustomMarshal)object).marshal((DataOutputStream)this.parent);
        } else {
            factory.write_value((org.omg.CORBA.portable.OutputStream)this.parent, object);
        }
        this.endValueChunk(currentMustChunk);
        this.mustChunk = oldMustChunk;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    public int get_offset() {
        return this.bbwi.position();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @CDR
    @CDRWrite
    public void start_block() {
        if (this.orb.cdrDebugFlag) {
            this.dputil.enter("start_block", "position", this.bbwi.position());
        }
        try {
            this.write_long(0);
            this.inBlock = true;
            this.blockSizePosition = this.get_offset();
            this.blockSizeIndex = this.bbwi.position();
            if (!this.orb.cdrDebugFlag) return;
        }
        catch (Throwable throwable) {
            if (!this.orb.cdrDebugFlag) throw throwable;
            this.dputil.info("blockSizeIndex", this.blockSizeIndex);
            this.dputil.exit();
            throw throwable;
        }
        this.dputil.info("blockSizeIndex", this.blockSizeIndex);
        this.dputil.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeLongWithoutAlign(int x) {
        if (this.orb.cdrDebugFlag) {
            this.dputil.enter("writeLongWithoutAlign", x);
        }
        try {
            if (this.littleEndian) {
                this.writeLittleEndianLong(x);
            } else {
                this.writeBigEndianLong(x);
            }
        }
        finally {
            if (this.orb.cdrDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CDR
    @CDRWrite
    public void end_block() {
        if (this.orb.cdrDebugFlag) {
            this.dputil.enter("end_block", new java.lang.Object[0]);
        }
        try {
            if (!this.inBlock) {
                return;
            }
            if (this.orb.cdrDebugFlag) {
                this.dputil.info("in a block");
            }
            this.inBlock = false;
            if (this.orb.cdrDebugFlag) {
                this.dputil.info("blockSizePosition=" + this.blockSizePosition);
            }
            if (this.get_offset() == this.blockSizePosition) {
                if (this.orb.cdrDebugFlag) {
                    this.dputil.info("removing 0 length block");
                }
                this.bbwi.position(this.bbwi.position() - 4);
                this.blockSizeIndex = -1;
                this.blockSizePosition = -1;
                return;
            }
            int oldSize = this.bbwi.position();
            this.bbwi.position(this.blockSizeIndex - 4);
            this.writeLongWithoutAlign(oldSize - this.blockSizeIndex);
            this.bbwi.position(oldSize);
            this.blockSizeIndex = -1;
            this.blockSizePosition = -1;
        }
        finally {
            if (this.orb.cdrDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    @Override
    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    @Override
    public final void write_boolean_array(boolean[] value, int offset, int length) {
        if (value == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(length);
        for (int i = 0; i < length; ++i) {
            this.write_boolean(value[offset + i]);
        }
        this.handleSpecialChunkEnd();
    }

    @Override
    public final void write_char_array(char[] value, int offset, int length) {
        if (value == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(length);
        for (int i = 0; i < length; ++i) {
            this.write_char(value[offset + i]);
        }
        this.handleSpecialChunkEnd();
    }

    @Override
    public void write_wchar_array(char[] value, int offset, int length) {
        if (value == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(2) + length * 2);
        for (int i = 0; i < length; ++i) {
            this.write_wchar(value[offset + i]);
        }
        this.handleSpecialChunkEnd();
    }

    @Override
    public final void write_short_array(short[] value, int offset, int length) {
        if (value == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(2) + length * 2);
        for (int i = 0; i < length; ++i) {
            this.write_short(value[offset + i]);
        }
        this.handleSpecialChunkEnd();
    }

    @Override
    public final void write_ushort_array(short[] value, int offset, int length) {
        this.write_short_array(value, offset, length);
    }

    @Override
    public final void write_long_array(int[] value, int offset, int length) {
        if (value == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(4) + length * 4);
        for (int i = 0; i < length; ++i) {
            this.write_long(value[offset + i]);
        }
        this.handleSpecialChunkEnd();
    }

    @Override
    public final void write_ulong_array(int[] value, int offset, int length) {
        this.write_long_array(value, offset, length);
    }

    @Override
    public final void write_longlong_array(long[] value, int offset, int length) {
        if (value == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(8) + length * 8);
        for (int i = 0; i < length; ++i) {
            this.write_longlong(value[offset + i]);
        }
        this.handleSpecialChunkEnd();
    }

    @Override
    public final void write_ulonglong_array(long[] value, int offset, int length) {
        this.write_longlong_array(value, offset, length);
    }

    @Override
    public final void write_float_array(float[] value, int offset, int length) {
        if (value == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(4) + length * 4);
        for (int i = 0; i < length; ++i) {
            this.write_float(value[offset + i]);
        }
        this.handleSpecialChunkEnd();
    }

    @Override
    public final void write_double_array(double[] value, int offset, int length) {
        if (value == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(8) + length * 8);
        for (int i = 0; i < length; ++i) {
            this.write_double(value[offset + i]);
        }
        this.handleSpecialChunkEnd();
    }

    public void write_string_array(String[] value, int offset, int length) {
        if (value == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        for (int i = 0; i < length; ++i) {
            this.write_string(value[offset + i]);
        }
    }

    public void write_wstring_array(String[] value, int offset, int length) {
        if (value == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        for (int i = 0; i < length; ++i) {
            this.write_wstring(value[offset + i]);
        }
    }

    @Override
    public final void write_any_array(Any[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.write_any(value[offset + i]);
        }
    }

    @Override
    public void writeTo(OutputStream s) throws IOException {
        byte[] tmpBuf = ORBUtility.getByteBufferArray(this.bbwi.getByteBuffer());
        s.write(tmpBuf, 0, this.bbwi.position());
    }

    @Override
    public void writeOctetSequenceTo(org.omg.CORBA.portable.OutputStream s) {
        byte[] buf = ORBUtility.getByteBufferArray(this.bbwi.getByteBuffer());
        s.write_long(this.bbwi.position());
        s.write_octet_array(buf, 0, this.bbwi.position());
    }

    @Override
    public final int getSize() {
        return this.bbwi.position();
    }

    @Override
    public int getIndex() {
        return this.bbwi.position();
    }

    @Override
    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    @Override
    public void setIndex(int value) {
        this.bbwi.position(value);
    }

    @Override
    public ByteBufferWithInfo getByteBufferWithInfo() {
        return this.bbwi;
    }

    @Override
    public void setByteBufferWithInfo(ByteBufferWithInfo bbwi) {
        this.bbwi = bbwi;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        ByteBuffer result = null;
        if (this.bbwi != null) {
            result = this.bbwi.getByteBuffer();
        }
        return result;
    }

    @Override
    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.bbwi.setByteBuffer(byteBuffer);
    }

    private final void freeValueCache() {
        if (this.valueCache != null) {
            this.valueCache.done();
        }
    }

    private final void updateIndirectionTable(int indirection, java.lang.Object key) {
        if (this.valueCache == null) {
            this.valueCache = new CacheTable("Output valueCache", this.orb, true);
        }
        this.valueCache.put(key, indirection);
    }

    private final boolean writeIndirectionIfPossible(Serializable object) {
        int indir;
        if (this.valueCache != null && (indir = this.valueCache.getVal(object)) != -1) {
            this.writeIndirection(-1, indir);
            return true;
        }
        return false;
    }

    @CDR
    @CDRWrite
    private final void write_repositoryId(String id) {
        int indir;
        if (this.repositoryIdCache != null && (indir = this.repositoryIdCache.getVal(id)) != -1) {
            this.writeIndirection(-1, indir);
            return;
        }
        int indirection = this.writeString(id);
        if (this.repositoryIdCache == null) {
            this.repositoryIdCache = new CacheTable("Output repositoryIdCache", this.orb, true);
        }
        this.repositoryIdCache.put(id, indirection);
    }

    @CDR
    @CDRWrite
    private void write_codebase(String str, int pos) {
        Integer value = null;
        if (this.codebaseCache != null) {
            value = this.codebaseCache.get(str);
        }
        if (value != null) {
            this.writeIndirection(-1, value);
        } else {
            this.write_string(str);
            if (this.codebaseCache == null) {
                this.codebaseCache = new HashMap<String, Integer>();
            }
            this.codebaseCache.put(str, pos);
        }
    }

    @CDR
    @CDRWrite
    private final int writeValueTag(boolean chunkIt, boolean useRepId, String codebase) {
        int indirection = 0;
        if (chunkIt && !useRepId) {
            if (codebase == null) {
                this.write_long(this.repIdUtil.getStandardRMIChunkedNoRepStrId());
                indirection = this.get_offset() - 4;
            } else {
                this.write_long(this.repIdUtil.getCodeBaseRMIChunkedNoRepStrId());
                indirection = this.get_offset() - 4;
                this.write_codebase(codebase, this.get_offset());
            }
        } else if (chunkIt && useRepId) {
            if (codebase == null) {
                this.write_long(this.repIdUtil.getStandardRMIChunkedId());
                indirection = this.get_offset() - 4;
            } else {
                this.write_long(this.repIdUtil.getCodeBaseRMIChunkedId());
                indirection = this.get_offset() - 4;
                this.write_codebase(codebase, this.get_offset());
            }
        } else if (!chunkIt && !useRepId) {
            if (codebase == null) {
                this.write_long(this.repIdUtil.getStandardRMIUnchunkedNoRepStrId());
                indirection = this.get_offset() - 4;
            } else {
                this.write_long(this.repIdUtil.getCodeBaseRMIUnchunkedNoRepStrId());
                indirection = this.get_offset() - 4;
                this.write_codebase(codebase, this.get_offset());
            }
        } else if (!chunkIt && useRepId) {
            if (codebase == null) {
                this.write_long(this.repIdUtil.getStandardRMIUnchunkedId());
                indirection = this.get_offset() - 4;
            } else {
                this.write_long(this.repIdUtil.getCodeBaseRMIUnchunkedId());
                indirection = this.get_offset() - 4;
                this.write_codebase(codebase, this.get_offset());
            }
        }
        return indirection;
    }

    @CDR
    @CDRWrite
    private void writeIDLValue(Serializable object, String repID) {
        if (object instanceof StreamableValue) {
            ((StreamableValue)object)._write((org.omg.CORBA.portable.OutputStream)this.parent);
        } else if (object instanceof CustomValue) {
            ((CustomValue)object).marshal((DataOutputStream)this.parent);
        } else {
            BoxedValueHelper helper = Utility.getHelper(object.getClass(), null, repID);
            boolean isCustom = false;
            if (helper instanceof ValueHelper && object instanceof CustomMarshal) {
                try {
                    if (((ValueHelper)helper).get_type().type_modifier() == 1) {
                        isCustom = true;
                    }
                }
                catch (BadKind ex) {
                    throw this.wrapper.badTypecodeForCustomValue(CompletionStatus.COMPLETED_MAYBE, ex);
                }
            }
            if (isCustom) {
                ((CustomMarshal)object).marshal((DataOutputStream)this.parent);
            } else {
                helper.write_value((org.omg.CORBA.portable.OutputStream)this.parent, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CDR
    @CDRWrite
    private void writeEndTag(boolean chunked) {
        if (this.orb.cdrDebugFlag) {
            this.dputil.enter("writeEndTag", "chunked", chunked);
        }
        try {
            if (chunked) {
                if (this.get_offset() == this.end_flag_position && this.bbwi.position() == this.end_flag_index) {
                    this.bbwi.position(this.bbwi.position() - 4);
                }
                this.writeNestingLevel();
                this.end_flag_index = this.bbwi.position();
                this.end_flag_position = this.get_offset();
                ++this.chunkedValueNestingLevel;
            }
            ++this.end_flag;
        }
        finally {
            if (this.orb.cdrDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    @CDR
    private void writeNestingLevel() {
        if (this.orb == null || ORBVersionFactory.getFOREIGN().equals(this.orb.getORBVersion()) || ORBVersionFactory.getNEWER().compareTo(this.orb.getORBVersion()) <= 0) {
            this.write_long(this.chunkedValueNestingLevel);
        } else {
            this.write_long(this.end_flag);
        }
    }

    @CDR
    @CDRWrite
    private void writeClass(String repository_id, Class clz, ClassInfoCache.ClassInfo cinfo) {
        if (repository_id == null) {
            repository_id = this.repIdStrs.getClassDescValueRepId();
        }
        int indirection = this.writeValueTag(this.mustChunk, true, null);
        this.updateIndirectionTable(indirection, clz);
        this.write_repositoryId(repository_id);
        this.startValueChunk(this.mustChunk);
        this.writeClassBody(clz, cinfo);
        this.endValueChunk(this.mustChunk);
    }

    @CDR
    @CDRWrite
    private void writeClassBody(Class clz, ClassInfoCache.ClassInfo cinfo) {
        if (this.orb == null || ORBVersionFactory.getFOREIGN().equals(this.orb.getORBVersion()) || ORBVersionFactory.getNEWER().compareTo(this.orb.getORBVersion()) <= 0) {
            this.write_value((Serializable)((java.lang.Object)this.getCodebase(clz)));
            this.write_value((Serializable)((java.lang.Object)this.repIdStrs.createForAnyType(clz, cinfo)));
        } else {
            this.write_value((Serializable)((java.lang.Object)this.repIdStrs.createForAnyType(clz, cinfo)));
            this.write_value((Serializable)((java.lang.Object)this.getCodebase(clz)));
        }
    }

    @CDR
    @CDRWrite
    private void writeIDLEntity(IDLEntity object) {
        this.mustChunk = true;
        String repository_id = this.repIdStrs.createForJavaType((Serializable)object);
        final Class<?> clazz = object.getClass();
        String codebase = this.getCodebase(clazz);
        int indirection = this.writeValueTag(true, true, codebase);
        this.updateIndirectionTable(indirection, object);
        this.write_repositoryId(repository_id);
        this.startValueChunk(true);
        try {
            ClassLoader clazzLoader = clazz == null ? null : clazz.getClassLoader();
            final Class helperClass = Utility.loadClassForClass(clazz.getName() + "Helper", codebase, clazzLoader, clazz, clazzLoader);
            Method writeMethod = null;
            try {
                writeMethod = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                    @Override
                    public Method run() throws NoSuchMethodException {
                        return helperClass.getDeclaredMethod(CDROutputStream_1_0.kWriteMethod, org.omg.CORBA.portable.OutputStream.class, clazz);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (NoSuchMethodException)pae.getException();
            }
            writeMethod.invoke(null, this.parent, object);
        }
        catch (Exception exc) {
            throw this.wrapper.errorInvokingHelperWrite(CompletionStatus.COMPLETED_MAYBE, exc);
        }
        this.endValueChunk(true);
    }

    @Override
    @CDR
    @CDRWrite
    public void write_Abstract(java.lang.Object value) {
        this.write_abstract_interface(value);
    }

    @Override
    @CDR
    @CDRWrite
    public void write_Value(Serializable value) {
        this.write_value(value);
    }

    @Override
    public void write_fixed(BigDecimal bigDecimal, short digits, short scale) {
        String fractionPart;
        String integerPart;
        int dotIndex;
        String string = bigDecimal.toString();
        if (string.charAt(0) == '-' || string.charAt(0) == '+') {
            string = string.substring(1);
        }
        if ((dotIndex = string.indexOf(46)) == -1) {
            integerPart = string;
            fractionPart = null;
        } else if (dotIndex == 0) {
            integerPart = null;
            fractionPart = string;
        } else {
            integerPart = string.substring(0, dotIndex);
            fractionPart = string.substring(dotIndex + 1);
        }
        StringBuffer stringBuffer = new StringBuffer(digits);
        if (fractionPart != null) {
            stringBuffer.append(fractionPart);
        }
        while (stringBuffer.length() < scale) {
            stringBuffer.append('0');
        }
        if (integerPart != null) {
            stringBuffer.insert(0, integerPart);
        }
        while (stringBuffer.length() < digits) {
            stringBuffer.insert(0, '0');
        }
        this.write_fixed(stringBuffer.toString(), bigDecimal.signum());
    }

    @Override
    public void write_fixed(BigDecimal bigDecimal) {
        this.write_fixed(bigDecimal.toString(), bigDecimal.signum());
    }

    public void write_fixed(String string, int signum) {
        char ch;
        int i;
        int stringLength = string.length();
        byte doubleDigit = 0;
        int numDigits = 0;
        for (i = 0; i < stringLength; ++i) {
            ch = string.charAt(i);
            if (ch == '-' || ch == '+' || ch == '.') continue;
            ++numDigits;
        }
        for (i = 0; i < stringLength; ++i) {
            ch = string.charAt(i);
            if (ch == '-' || ch == '+' || ch == '.') continue;
            byte digit = (byte)Character.digit(ch, 10);
            if (digit == -1) {
                throw this.wrapper.badDigitInFixed(CompletionStatus.COMPLETED_MAYBE);
            }
            if (numDigits % 2 == 0) {
                doubleDigit = (byte)(doubleDigit | digit);
                this.write_octet(doubleDigit);
                doubleDigit = 0;
            } else {
                doubleDigit = (byte)(doubleDigit | digit << 4);
            }
            --numDigits;
        }
        doubleDigit = signum == -1 ? (byte)((byte)(doubleDigit | 0xD)) : (byte)((byte)(doubleDigit | 0xC));
        this.write_octet(doubleDigit);
    }

    @Override
    public String[] _truncatable_ids() {
        if (_ids == null) {
            return null;
        }
        return (String[])_ids.clone();
    }

    @Override
    public void writeIndirection(int tag, int posIndirectedTo) {
        this.handleSpecialChunkBegin(this.computeAlignment(4) + 8);
        this.write_long(tag);
        this.write_long(posIndirectedTo - this.parent.getRealIndex(this.get_offset()));
        this.handleSpecialChunkEnd();
    }

    protected CodeSetConversion.CTBConverter getCharConverter() {
        if (this.charConverter == null) {
            this.charConverter = this.parent.createCharCTBConverter();
        }
        return this.charConverter;
    }

    protected CodeSetConversion.CTBConverter getWCharConverter() {
        if (this.wcharConverter == null) {
            this.wcharConverter = this.parent.createWCharCTBConverter();
        }
        return this.wcharConverter;
    }

    protected void dprint(String msg) {
        if (this.orb.cdrDebugFlag) {
            ORBUtility.dprint(this, msg);
        }
    }

    @Override
    void alignOnBoundary(int octetBoundary) {
        this.alignAndReserve(octetBoundary, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CDR
    @CDRWrite
    public void start_value(String rep_id) {
        if (this.orb.cdrDebugFlag) {
            this.dputil.enter("start_value", "rep_id", rep_id, "called at position", this.get_offset(), "position", this.bbwi.position());
        }
        try {
            if (this.inBlock) {
                this.end_block();
            }
            this.writeValueTag(true, true, null);
            this.write_repositoryId(rep_id);
            --this.end_flag;
            --this.chunkedValueNestingLevel;
            this.start_block();
        }
        finally {
            if (this.orb.cdrDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CDR
    @CDRWrite
    public void end_value() {
        if (this.orb.cdrDebugFlag) {
            this.dputil.enter("end_value", "called as position", this.get_offset(), "position", this.bbwi.position());
        }
        try {
            this.end_block();
            this.writeEndTag(true);
            if (this.orb.cdrDebugFlag) {
                this.dprint("mustChunk is " + this.mustChunk);
            }
            if (this.mustChunk) {
                this.start_block();
            }
        }
        finally {
            if (this.orb.cdrDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.getBufferManager().close();
        if (this.getByteBufferWithInfo() != null && this.getByteBuffer() != null) {
            CDRInputObject inputObj;
            CorbaMessageMediator messageMediator = this.parent.getMessageMediator();
            if (messageMediator != null && (inputObj = messageMediator.getInputObject()) != null && this.bbwi.getByteBuffer() == inputObj.getByteBuffer()) {
                inputObj.setByteBuffer(null);
                inputObj.setByteBufferWithInfo(null);
            }
            ByteBufferPool byteBufferPool = this.orb.getByteBufferPool();
            if (this.orb.cdrDebugFlag) {
                int bbAddress = System.identityHashCode(this.bbwi.getByteBuffer());
                StringBuffer sb = new StringBuffer(80);
                sb.append(".close - releasing ByteBuffer id (");
                sb.append(bbAddress).append(") to ByteBufferPool.");
                String msg = sb.toString();
                this.dprint(msg);
            }
            byteBufferPool.releaseByteBuffer(this.getByteBuffer());
            this.bbwi.setByteBuffer(null);
            this.bbwi = null;
        }
    }
}

